//  UXInput.h version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//
//
//
#ifndef __uxinput_h__
#define __uxinput_h__

#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include "UWidgetX.h"
#include "UString.h"
#include "UFont.h"

//
// Generic Input Method handler for X
// The trick is: XInput knows about UWidget.
//
class UXInput
{
public:
	enum UInputStyle	{UROOT, UOVER, UOFF};
	enum			UInputEvent { UPROPERTY_CHANGE, UNO_EVENT, 
					U_MAX_EVENT };

	enum UAttribute		{UNONE=0, UBACKGROUND=1, UFOREGROUND=2, 
					UCURSORXY=4, UFONT=8, 
					UISTYLE=32, 
					UTEXT_TYPE=64, 
					UWINDOW=128, 
					UEVENT_CAPTURE=256, 
					UCURSOR_SHAPE=512,
					USTATUS_AREA=1024,
					UCLIENT_AREA=2048,
					ULINE_SPACING=4096,
					UALL=65535};
	enum UStatus		{ERROR, OK};
				UXInput (UWidgetX* uwidgetIn); 
	virtual			~UXInput ();

	UStatus			uSetup (const char *	imIn,	
					const UInputStyle inputStyleIn,
					const char* textType,
					const char* uStringIn,
					UFontX11 *font,
					float verisonIn=0.0);
	UStatus			uStart ();

	void			uChangeAttributes(const UAttribute attrIn);

	void			uEnd ();

	virtual void		propertyChangeHandler (const XEvent* event);
	virtual void		noEventHandler (const XEvent* event);

protected:
	UWidgetX*		uwidget;
	UString*		uString;
	UFontX11*		font;

	int			started;
	int			initialized;
	float 			version;

	char*			inputMethod;
	UInputStyle		inputStyle;
	char*			textType;
	Atom			textTypeAtom;

	virtual UStatus		uStartIM ();
	virtual void		uEndIM();
	virtual void		uChangeIM (UAttribute attrIn);

	// The following functions should register an event handler
	// that calls the functions above. This is widget set dependent.
	// override this to suit your event handling style

	virtual void		addEventHandler (const UInputEvent eventType);
	virtual void		removeEventHandler (const UInputEvent eventType);
};


#endif /* __uxinput_h__ */
