//  uniconv.cpp version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//
// Simple demo to convert
//

#include <stdlib.h>
#include <iostream.h>
#include <UString.h>
#include <UCommon.h>

void usage();

#ifdef __sun__
#ifndef __svr4__
extern "C" {
int getopt(int argc, char* const* argv, const char* optstring);
extern int optind;
extern char *optarg;
}
#endif
#else
#include <unistd.h>
#endif

#define LINE_LENGTH	4096


int
main (int argc, char *argv[])
{
	ifstream*	file=0;
	ofstream*	ofile=0;
	ostream*	output;
	istream *	input;
	UString	*	str;
	char*		umaps;
	unsigned char*	buffer;
	int		option;
	char*		ofileName;
	char*		iencoding;
	char*		oencoding;

	ofileName = 0;
	iencoding = 0;
	oencoding = 0;
	
	while ((option=getopt (argc, argv, "o:I:O:h"))!= -1)
	{
		switch (option)
		{
		case 'o':
			ofileName =  optarg; break;
		case 'I':
			iencoding =  optarg; break;
		case 'O':
			oencoding =  optarg; break;
		case 'h':
			usage(); exit (0);
		default:
			usage(); exit (1);
		}
	}
	if (argc-optind > 1)
	{
		usage();
		exit (1);
	}
	if (argc-optind == 1)
	{
		file = new ifstream (argv[argc-1]);
		if (file->rdbuf() == 0 || !file->rdbuf()->is_open())
		{
			cerr << "uniconv: can not open '" << argv[argc-1] << "' for reading.\n";
			exit (1);
		}
		input = file;
	}
	else
	{
		input = &cin;
	}

	if (ofileName!=0)
	{
		ofile = new ofstream (ofileName);
		if (ofile->rdbuf() == 0 || !ofile->rdbuf()->is_open())
		{
			cerr << "uniconv: can not open '" << ofileName << "' for writing.\n";
			exit (1);
		}
		output = ofile;
	}
	else
	{
		output = &cout;
	}
	
	if ((umaps=getenv ("YUDITDATA"))!=0)
	{
		USetMapPath (umaps);
	}
	else
	{
		USetMapPath (DATA_DIR);
	}
	str = new UString();
	if (iencoding==0) iencoding = "UTF8";
	if (oencoding==0) oencoding = "UTF8";
	if (str->setConverter (iencoding) == UString::ERROR)
	{
		cerr << "uniconv: can not find converter for '" << iencoding << "'\n";
	}
	else if (str->setConverter (oencoding) == UString::ERROR)
	{
		cerr << "uniconv: can not find converter for '" << oencoding << "'\n";
	}
	buffer = UReadBuffer (input);
	if (buffer==0)
	{
		cerr << "uniconv: failed to read file.\n";
		exit (1);
	}
	str->setConverter (iencoding);
	str->putString (buffer);
	delete buffer;

	str->setConverter (oencoding);
	buffer = str->getString();
	if (UWriteBuffer (output, buffer) < 0)
	{
		cerr << "uniconv: write failed.\n";
	}
	delete buffer;
	
	if (argc-optind == 1)
	{
		delete (file);
	}
	if (ofileName!=0)
	{
		ofile->close();
		delete ofile;
	}
	exit (0);
}

void
usage ()
{
	cerr << UWidgetVersion();
	cerr << "\n";
	cerr << "usage: uniconv [-o file-out] [-I encoding-in] [-O encoding-out] [file-in] \n";
	cerr << "Currently known encodings:                                 \n";
	cerr << "  UTF8     UTF7   8859_1    8859_2    8859_5   KOI8_R   JIS \n";
	cerr << "  EUC_JP   SJIS   CTEXT_KR  EUC_KR    JOHAB    UHC      GB2312_7 \n";
	cerr << "  GB2312_8 HZ     BIG5      CTEXT_JA  UCS2LE   UCS2BE   MSTXT \n";
	cerr << "  VISCII   UNI    JAVA      CP1251    10646  \n";
	cerr << "The umap files should be located on your YUDITDATA.\n";
}

