/* Aisleriot - draw.c
 * Copyright (C) 1998 Jonathan Blandford <jrb@mit.edu>
 *
 * This game is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "draw.h"
#include "sol.h"
#include "slot.h"
#include "card.h"

void draw_cards () {
  GList* slot;
  gint x, y, dx, dy;
  GList* card_list;
  GdkPixmap *image;

  gdk_gc_set_clip_mask(draw_gc,mask); 
  
  for (slot = get_slot_list(); slot; slot = slot->next) {
    hslot_type hslot = (hslot_type)slot->data;

    if ((card_list = hslot->cards)) {

      switch(hslot->type) {

      case NORMAL_SLOT:

	card_list = g_list_last (card_list);
	break;

      case PARTIALLY_EXPANDING_SLOT:
      case PARTIALLY_EXPANDING_SLOT_RIGHT:

	if (g_list_length(card_list) > hslot->expansion_depth)
	  card_list = g_list_nth(card_list, 
				 g_list_length(card_list) - 
				 hslot->expansion_depth);
	break;

      case EXPANDING_SLOT:
      case EXPANDING_SLOT_RIGHT:

	break;
      }

      x = hslot->x;
      y = hslot->y;
      dx = dy = 0; 

      switch(hslot->type) {

      case NORMAL_SLOT:

	break;

      case PARTIALLY_EXPANDING_SLOT:
      case EXPANDING_SLOT:

	dy = EXPANDED_VERT_OFFSET;
	break;

      case PARTIALLY_EXPANDING_SLOT_RIGHT:
      case EXPANDING_SLOT_RIGHT:

	dx = EXPANDED_HORIZ_OFFSET;
	break;
      }

      for (; card_list; card_list = card_list->next) {
	card_type *card = card_list->data;

	if (card->direction == DOWN) 
	  image = get_card_back_pixmap();
	else 
	  image = get_card_picture(card->suit, card->value);
	
	gdk_gc_set_clip_origin(draw_gc, x, y);
	gdk_draw_pixmap(surface, draw_gc, image, 0, 0, x, y, -1, -1);
	
	x += dx; y += dy;
      }
    }
  }
  gdk_gc_set_clip_mask(draw_gc,NULL); 
}

void take_snapshot() {
  GList* slot;

  gdk_draw_rectangle (surface, draw_gc, TRUE, 0, 0, -1, -1);

  for (slot = get_slot_list(); slot; slot = slot->next) {
    gdk_draw_pixmap (surface, draw_gc,
		     get_slot_pixmap(), 0, 0, 
		     ((hslot_type)slot->data)->x, 
		     ((hslot_type)slot->data)->y, -1, -1);
  }
  draw_cards();
  gdk_window_set_back_pixmap(playing_area->window, surface, 0);
}

void refresh_screen() {
  take_snapshot();
  gdk_window_clear(playing_area->window);
}
