/* XQF - Quake server browser and launcher
 * Copyright (C) 1998 Roman Pozlevich <roma@botik.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef __DNS_H__
#define __DNS_H__

#include <gtk/gtk.h>


#define RESOLVE_DELIM	'|'


extern	int hosts_total (void);
extern	struct host *host_add (const char *address);
extern	void host_unref (struct host *h);

extern	char *dns_lookup_by_addr (char *ip);
extern	char *dns_lookup_by_name (char *name);

extern	GSList *merge_host_to_resolve  (GSList *hosts, struct host *h);
extern	GSList *merge_hosts_to_resolve (GSList *hosts, GSList *servers);

extern	void resolve (GSList *strings, int maxprocs);


#endif /* __DNS_H__ */
