/* XQF - Quake server browser and launcher
 * Copyright (C) 1998 Roman Pozlevich <roma@botik.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <gtk/gtk.h>

#include "pixmaps.h"


#include "xpm/q.xpm"
#include "xpm/q2.xpm"
#include "xpm/green-plus.xpm"
#include "xpm/red-minus.xpm"


GdkPixmap *q_pix = NULL;
GdkBitmap *q_pix_mask = NULL;

GdkPixmap *q2_pix = NULL;
GdkBitmap *q2_pix_mask = NULL;

GdkPixmap *gplus_pix = NULL;
GdkBitmap *gplus_pix_mask = NULL;

GdkPixmap *rminus_pix = NULL;
GdkBitmap *rminus_pix_mask = NULL;


static void free_pixmap (GdkPixmap **pixmap) {
  if (*pixmap) {
    gdk_pixmap_unref (*pixmap);
    *pixmap = NULL;
  }
}


static void free_bitmap (GdkBitmap **bitmap) {
  if (*bitmap) {
    gdk_bitmap_unref (*bitmap);
    *bitmap = NULL;
  }
}


void free_pixmaps (void) {
  free_pixmap (&q_pix);
  free_bitmap (&q_pix_mask);

  free_pixmap (&q2_pix);
  free_bitmap (&q2_pix_mask);

  free_pixmap (&gplus_pix);
  free_bitmap (&gplus_pix_mask);

  free_pixmap (&rminus_pix);
  free_bitmap (&rminus_pix_mask);
}


void init_pixmaps (GtkWidget *window) {
  free_pixmaps ();

  q_pix = gdk_pixmap_create_from_xpm_d (
                   window->window, &q_pix_mask, &window->style->white, q_xpm);
  q2_pix = gdk_pixmap_create_from_xpm_d (
                 window->window, &q2_pix_mask, &window->style->white, q2_xpm);

  gplus_pix = gdk_pixmap_create_from_xpm_d (
      window->window, &gplus_pix_mask, &window->style->white, green_plus_xpm);
  rminus_pix = gdk_pixmap_create_from_xpm_d (
      window->window, &rminus_pix_mask, &window->style->white, red_minus_xpm);
}


int pixmap_height (GdkPixmap *pixmap) {
  int height, width;

  if (!pixmap)	
    return 0;

  gdk_window_get_size (pixmap, &width, &height);

  return height;
}

