/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Verwendet: GTK                                                            *
 * Modul:     filesel.c                                                      *
 *            functions concerning fileselection list widget                 *
 * Autor:     Andreas Tille                                                  *
 * Datum:     10.09.1998                                                     *
 *                                                                           *
 *****************************************************************************/

#include "paul.h"
#include "callback.h"

#ifdef __DMALLOC__
#include <dmalloc.h>
#endif

int FileListSelectionStatus = 0,
    FileListKeyboardStatus  = 0;
int UPDATE_IMAGE            = 0;

void FileListButtonPressed(GtkWidget *gtklist, GdkEventButton *event, gpointer data)
{
   if ( event && event->type == GDK_BUTTON_PRESS ) 
      FileListSelectionStatus = event->button;
   if ( event->state & GDK_SHIFT_MASK )
      FileListKeyboardStatus  = 1;
}

void FileListSelectChild(GtkList *gtklist, GtkWidget *data)
/*
 * --- Parameter: ---
 * GtkList   *gtklist : file selection list (p->filelist)
 * GtkWidget *data    : selected list item
 */
{
   static    GList *last_displayed = NULL;
   PAUL            *p;
   GList           *gl;
   GtkObject       *list_item;
   
   g_return_if_fail(GTK_IS_LIST(gtklist));
   g_return_if_fail(GTK_IS_LIST_ITEM(data));

   if ( ANIMATION_SPEED != SINGLE ) {
      g_warning("Please avoid selecting images while animation %i", ANIMATION_SPEED);
      return;
   }
   
   p         = (PAUL *)gtk_object_get_user_data(GTK_OBJECT(gtklist));
   p->activ  = LI2PL(GTK_OBJECT(data));
   g_return_if_fail( data == GTK_WIDGET((BILD(p->activ)->label)->parent) );
   
   if ( DoMatchPictures(p->opt->f) ) SetMoveTitle(p);
   else if ( FileListKeyboardStatus ) {
      PICTURE   *new_op    = BILD(p->activ);
      GtkWidget *list_item = SearchListItem(GTK_LIST(p->filelist)->children, p->activ);
      
      FileListKeyboardStatus = 0; /* necessary to cope with the trick in AddImageToFilelist() */
      RemoveImageFromFilelist(p, list_item);
      if ( p->op ) OperationToList((gpointer *)p, NULL);
      p->op = new_op;
      CreateOperationImageWindow(p);
      ButtonSensitive(p);
      return;
   }

   switch ( FileListSelectionStatus ) {
   case 0: break;
   case 1: SelectSingleListItem(gtklist, data);
           break;
   case 2: if ( (gl = GTK_LIST(gtklist)->children) ) do {
              list_item = gl->data;
              if ( GTK_WIDGET(list_item)->state == GTK_STATE_NORMAL) {
                 gtklist->selection = g_list_prepend(gtklist->selection, list_item);
                 gtk_widget_ref(GTK_WIDGET(list_item));
                 gtk_list_item_select(GTK_LIST_ITEM(list_item));
	      }
           } while ( (gl = gl->next) );
           break;
   case 3: if ( !(GTK_LIST(gtklist)->selection) ) {
           /* if there arent any selected files, let the last clicked be selected */
              if ( data->state == GTK_STATE_NORMAL) {
                 gtklist->selection = g_list_prepend(gtklist->selection, data);
	         gtk_widget_ref(data);
                 gtk_list_item_select(GTK_LIST_ITEM(data));
              }
           } 
           break;
   default: printf("GDK_OTHER_EVENT: %i\n", FileListSelectionStatus); break;
   }

   if ( last_displayed != p->activ || UPDATE_IMAGE ) {
      ApplyPicture(p->show->window, BILD(last_displayed = p->activ));
      if ( Info(p->opt->f) ) {
         GtkWidget *nbwindow;
	 
         nbwindow = gtk_object_get_user_data(GTK_OBJECT(p->w));
	 if ( nbwindow && GTK_IS_WINDOW(nbwindow) ) {
            GtkWidget *notebook;
	    
            notebook = gtk_object_get_user_data(GTK_OBJECT(nbwindow));
	    if ( GTK_IS_NOTEBOOK(notebook) )
               gtk_notebook_set_page(GTK_NOTEBOOK(notebook), GetListPosition(p->piclist, p->activ));
	 }
      }
      UPDATE_IMAGE = 0;
   }
   
   ButtonSensitive(p);
   FileListSelectionStatus = 0;
}

void SelectSingleListItem(GtkList *gtklist, GtkWidget *data)
{
   GList     *gl;
   GtkObject *list_item;
   
   if ( (gl = GTK_LIST(gtklist)->selection) ) do {
      list_item = gl->data;
      if ( list_item != GTK_OBJECT(data) ) {
         gtk_list_item_deselect(GTK_LIST_ITEM(list_item));
         gl = gtklist->selection = g_list_remove(gtklist->selection, list_item);
      } else 
         gl = gl->next;
   } while ( gl );
   if ( data->state == GTK_STATE_NORMAL) {
      gtklist->selection = g_list_prepend(gtklist->selection, data);
      gtk_widget_ref(data);
      gtk_list_item_select(GTK_LIST_ITEM(data));
   }
   gtk_signal_emit_by_name(GTK_OBJECT(gtklist), "selection_changed");
}

