/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Verwendet: GTK, Imlib                                                     *
 * Modul:     ginfo.c                                                        *
 *            GTK-notebook to display image information                      *
 * Autor:     Andreas Tille                                                  *
 * Datum:     20.10.1998                                                     *
 *                                                                           *
 *****************************************************************************/

#include <assert.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/param.h>

#include "paul.h"
#include "callback.h"

static gint PageSwitchTag = 0;

static void PageSwitch(GtkWidget *widget, GtkNotebookPage *page, gint page_num)
/* 
 * --- Parameter: ---
 * GtkWidget       *widget   : information notebook (connected to PAUL structure)
 * GtkNotebookPage *page     : current page (connected to PICTURE list)
 * gint             page_num : current page number
 */
{
   PAUL  *p  = (PAUL *)gtk_object_get_user_data(GTK_OBJECT(widget));
   GList *pl = (GList *)gtk_object_get_user_data(GTK_OBJECT(page->child));
    
   p->activ = pl;
   SelectSingleListItem(p->filelist, GTK_WIDGET((BILD(p->activ)->label)->parent));
   ApplyPicture(p->show->window, BILD(p->activ = pl));
}

static void InfoTableEntry(GtkWidget *table, char *desc, char *value, int i, int editable)
/* 
 * --- Parameter: ---
 * GtkWidget *table : table to draw in
 * char      *desc  : description for label
 * char      *value : value according to the description
 * int        i     : row number to draw in
 */
{
#define TEXT_LENGTH 64
#define LINE_HEIGHT 20
   GtkWidget      *label, *text;
   register  char *sp, *ep, *fip;
   char            buf[TEXT_LENGTH];
   int             l = 0, ml = 0;

   label = gtk_label_new(desc);
   gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
   gtk_table_attach(GTK_TABLE(table), label, 0, 1, i, i+1, GTK_EXPAND|GTK_FILL, GTK_EXPAND|GTK_FILL, 2, 0);
/* How to obtain the size of a letter in a font
   gtk_widget_realize(label); 
   gtk_widget_show(label);
   gdk_window_get_size(label->window, &w, &h);
printf("%s(%i): desc = %s, w = %i, h = %i\n", __FILE__, __LINE__, desc, w, h);
 */

   text = gtk_text_new(NULL, NULL);
   if ( editable ) gtk_text_set_editable(GTK_TEXT(text), TRUE);
   gtk_widget_show(text);
   gtk_table_attach(GTK_TABLE(table), text, 1, 2, i, i+1, GTK_EXPAND|GTK_FILL, GTK_EXPAND|GTK_FILL, 2, 0);
   gtk_widget_realize(text); 

   for ( fip = (sp = value) + strlen(value); sp < fip; sp = ep + 1) {
      if ( sp > value ) gtk_text_insert(GTK_TEXT(text), NULL, NULL, NULL, "\n", -1);
      memset(buf, 0, TEXT_LENGTH);
      if ( !(ep = strchr(sp, '\n')) ) ep = sp + strlen(sp);
      if ( ep - sp > TEXT_LENGTH-1 )  ep = sp + TEXT_LENGTH - 1;
      strncpy(buf, sp, ep-sp);
      gtk_text_insert(GTK_TEXT(text), NULL, NULL, NULL, buf, -1);
      if ( strlen(buf) > ml ) ml = strlen(buf);
      l++;
   } 
   gtk_widget_set_usize(text, 7*ml, l*LINE_HEIGHT);
}

static void CreatePages(GtkNotebook *notebook, PAUL *p)
{
   GtkWidget *child = NULL,
             *label,
             *label_box,
             *table,
             *menu_box;
   char       buffer[1024];
   GList     *pl;
   PICTURE   *bild;
   CHUNK     *cp;
   int        i;

   for ( bild = BILD(pl = p->piclist); pl; bild = BILD(pl = pl->next) ) {
      child = gtk_frame_new(bild->file);
      gtk_container_border_width(GTK_CONTAINER(child), 10);
      gtk_object_set_user_data(GTK_OBJECT(child), pl);

      i = 2;
      if ( bild->zeit > 0 ) i++;
      for ( cp = bild->spec; cp->key != NULL; cp++ ) 
         if ( cp->value != NULL ) i++;

      table = gtk_table_new(i, 2, FALSE);
      gtk_container_add(GTK_CONTAINER(child), table);

      label_box = gtk_hbox_new(FALSE, 0);
      label     = gtk_label_new(bild->file);
      gtk_box_pack_start(GTK_BOX(label_box), label, FALSE, TRUE, 0);
      gtk_widget_show_all(label_box);
      
      menu_box = gtk_hbox_new(FALSE, 0);
      label    = gtk_label_new(bild->file);
      gtk_box_pack_start(GTK_BOX(menu_box), label, FALSE, TRUE, 0);
      gtk_widget_show_all(menu_box);

      gtk_notebook_append_page_menu(notebook, child, label_box, menu_box);

      i = 0;
      sprintf(buffer, "%i x %i = %i", bild->W, bild->H, bild->size);
      InfoTableEntry(table, "Imagesize", buffer, i++, FALSE);
      sprintf(buffer, "%i", bild->spp);
      InfoTableEntry(table, "Samples per Pixel", buffer, i++, FALSE);
      if ( bild->zeit > 0 ) 
         InfoTableEntry(table, "Source date", asctime(localtime(&(bild->zeit))), i++, FALSE);

      for ( cp = bild->spec; cp->key != NULL; cp++ ) 
         if ( cp->value != NULL ) InfoTableEntry(table, cp->key, cp->value, i++, TRUE);

      gtk_widget_show_all (child);

   }
   gtk_notebook_set_tab_pos(notebook, GTK_POS_RIGHT);
   gtk_notebook_set_show_tabs(notebook, TRUE);
   gtk_notebook_set_scrollable(notebook, TRUE);
}


static void NotebookDestroy(GtkWidget *button, GtkWidget *window)
/* Destroy the info notebook
 * This is necessary to avoid displaying all images form active up to the last
 * by disconnecting the PageSwitch function
 * --- Parameter: ---
 * GtkWidget *button : can be ignored
 * GtkWidget *window : window to close (connected with notebook)
 */
{
   GtkWidget *notebook, *tmp;
   PAUL      *p;

   notebook = gtk_object_get_user_data(GTK_OBJECT(window));
   p        = gtk_object_get_user_data(GTK_OBJECT(notebook));
   if ( PageSwitchTag) gtk_signal_disconnect(GTK_OBJECT(notebook), PageSwitchTag);

   tmp = gtk_object_get_user_data(GTK_OBJECT(p->w));
   if ( tmp && (tmp != window) ) g_warning("Inconsistent data in info widget.");
   gtk_object_set_user_data(GTK_OBJECT(p->w), NULL);

   gtk_widget_destroy(window);
}

static void InfoCleanUp(GtkWidget *widget, PAUL *p)
/* Reset info flag
 */
{
   gtk_object_set_user_data(GTK_OBJECT(p->w), NULL);
   p->opt->f &= ~INFO;
}

void FileInfo(GtkWidget *widget, PAUL *p)
/* Create notebook with information about all pictures
 * --- Parameter: ---
 * GtkWidget *widget : can be ignored
 * PAUL      *p      : structure of all pictures
 * --- Return: ---
 * GtkWidget *(p->w) : the notebook window is set via gtk_object_set_user_data to
 *                     give other functions a chance to update the informations
 */
{
   static    GtkWidget *window = NULL;  /* notebook will be connected,       *
                                         * window will be connected to p->w  */
   GtkWidget           *box1,
                       *box2,
                       *button,
                       *separator,
                       *notebook;       /* PAUL *p will be connected  */
   int                  x = -1, y = -1;

   if ( window ) {
      gdk_window_get_position(window->window, &x, &y);
      NotebookDestroy(NULL, window);
   }
      
   if ( !p->piclist ) return;
   window   = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   if ( x > -1 && y > -1 ) gtk_widget_set_uposition(window, x, y);
   gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &window);

   gtk_window_set_title(GTK_WINDOW(window), "Paul image information");
   gtk_container_border_width(GTK_CONTAINER(window), 0);

   box1     = gtk_vbox_new(FALSE, 0);
   gtk_container_add(GTK_CONTAINER(window), box1);

   notebook = gtk_notebook_new();
   gtk_box_pack_start(GTK_BOX(box1), notebook, TRUE, TRUE, 0);
   gtk_container_border_width(GTK_CONTAINER(notebook), 10);
   gtk_object_set_user_data(GTK_OBJECT(notebook), p);

   gtk_widget_realize(notebook);
   CreatePages(GTK_NOTEBOOK(notebook), p);

   separator = gtk_hseparator_new ();
   gtk_box_pack_start(GTK_BOX(box1), separator, FALSE, TRUE, 10);
   
   box2      = gtk_hbox_new(FALSE, 10);
   gtk_container_border_width(GTK_CONTAINER(box2), 10);
   gtk_box_pack_start(GTK_BOX(box1), box2, FALSE, TRUE, 0);
   
   button    = gtk_button_new_with_label("close");
   gtk_object_set_user_data(GTK_OBJECT(window), notebook);
   gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(InfoCleanUp), p);
   gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(NotebookDestroy), GTK_OBJECT(window));
   gtk_box_pack_start(GTK_BOX(box2), button, TRUE, TRUE, 0);
   GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
   gtk_widget_grab_default(button);

   button = gtk_button_new_with_label("next");
   gtk_signal_connect_object(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(gtk_notebook_next_page),
                             GTK_OBJECT(notebook));
   gtk_box_pack_start(GTK_BOX(box2), button, TRUE, TRUE, 0);

   button = gtk_button_new_with_label("prev");
   gtk_signal_connect_object(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(gtk_notebook_prev_page),
				 GTK_OBJECT (notebook));
   gtk_box_pack_start(GTK_BOX(box2), button, TRUE, TRUE, 0);

   gtk_notebook_set_page(GTK_NOTEBOOK(notebook), GetListPosition(p->piclist, p->activ));
   PageSwitchTag = gtk_signal_connect(GTK_OBJECT(notebook), "switch_page", GTK_SIGNAL_FUNC(PageSwitch), p);
   /* set window as userdata of filelist window */
   gtk_object_set_user_data(GTK_OBJECT(p->w), window);
   p->opt->f |= INFO;

   gtk_widget_show_all(window);
}

