/* tnt: Hostmode Terminal for TNC
   Copyright (C) 1993-1996 by Mark Wahl
   For license details see documentation
   Procedures for huffman compression (comp.c)
   created: Mark Wahl DL4YBG 95/02/05
   updated: Mark Wahl DL4YBG 96/03/21
*/

#include "tnt.h"
#include "comp.h"

/* huffman encoding table */
static struct huffencodtab huffencodtab[] = {
{0xab2c,15},{0xaa84,15},{0x9fc4,15},{0xab3c,15},
{0xab1c,15},{0xaafc,15},{0xaaec,15},{0xaad4,15},
{0xaab4,15},{0xf340,10},{0xaaa4,15},{0x7d64,15},
{0xaadc,15},{0xf400, 7},{0xaa94,15},{0x9ff4,15},
{0x9fd4,15},{0x7d74,15},{0xab44,15},{0xab34,15},
{0xab24,15},{0xab14,15},{0xab04,15},{0xaaf4,15},
{0xaae4,15},{0xab60,14},{0xab0c,15},{0xaacc,15},
{0xaabc,15},{0xaaac,15},{0xaa9c,15},{0xaa8c,15},
{0xc000, 3},{0x3a80, 9},{0xabc0,10},{0x0060,11},
{0x7d40,12},{0xab5c,14},{0x0000,12},{0xab58,14},
{0x7c00, 9},{0x3c80, 9},{0x7d00,11},{0x0010,12},
{0x1200, 7},{0x7a00, 7},{0xb800, 6},{0x3200, 7},
{0x2200, 7},{0xf600, 8},{0x3d00, 8},{0x9e00, 9},
{0xbd80, 9},{0x7c80, 9},{0x0080, 9},{0xaa00, 9},
{0xbd00, 9},{0x9f00, 9},{0x0300, 8},{0xab78,13},
{0xab68,13},{0x3c00, 9},{0x3000, 9},{0x0020,11},
{0x7d50,12},{0x3800, 7},{0x7800, 7},{0x9c00, 7},
{0xfe00, 7},{0x2400, 6},{0xbc00, 8},{0x0200, 8},
{0x0100, 8},{0xf100, 8},{0x0040,11},{0x3100, 8},
{0xf200, 8},{0x3400, 7},{0x1c00, 7},{0x1e00, 7},
{0xbe00, 7},{0xaba0,11},{0x3e00, 7},{0x1400, 6},
{0x3600, 7},{0xf380, 9},{0xf080, 9},{0x2000, 8},
{0xfc00, 8},{0x9f80,10},{0x9e80, 9},{0xab90,12},
{0x3b80, 9},{0xab80,12},{0xab54,14},{0x3a50,13},
{0xab50,14},{0xa000, 5},{0x1800, 6},{0x9800, 6},
{0x7000, 5},{0x4000, 3},{0x0400, 6},{0xac00, 6},
{0xf800, 6},{0x6000, 4},{0x3a00,10},{0xfd00, 8},
{0x2800, 5},{0xb000, 6},{0x8000, 4},{0xb400, 6},
{0x1000, 7},{0x7d20,12},{0xe000, 5},{0x9000, 5},
{0xe800, 5},{0x0800, 5},{0xf700, 8},{0xa800, 7},
{0x7d80, 9},{0xf300,10},{0x7e00, 7},{0xab48,14},
{0x3a48,13},{0xab4c,14},{0x3a60,12},{0x9ffc,15},
{0x9fec,15},{0x2100, 8},{0x9fdc,15},{0x9fcc,15},
{0xf000, 9},{0x7d7c,15},{0x7d6c,15},{0x3a40,14},
{0xab40,15},{0xab38,15},{0xab30,15},{0xab28,15},
{0xab20,15},{0xab18,15},{0xab70,13},{0xab10,15},
{0xab08,15},{0xab00,15},{0xaaf8,15},{0xaaf0,15},
{0x3b00, 9},{0xaae8,15},{0xaae0,15},{0xaad8,15},
{0xaad0,15},{0xab64,14},{0x7d30,12},{0xaac8,15},
{0xaac0,15},{0xaab8,15},{0xaab0,15},{0xaaa8,15},
{0xaaa0,15},{0xaa98,15},{0xaa90,15},{0xaa88,15},
{0xaa80,15},{0x9ff8,15},{0x9ff0,15},{0x9fe8,15},
{0x9fe0,15},{0x9fd8,15},{0x9fd0,15},{0x9fc8,15},
{0x9fc0,15},{0x7d78,15},{0x7d70,15},{0x3a58,13},
{0x7d68,15},{0x7d60,15},{0xab46,15},{0xab42,15},
{0xab3e,15},{0xab3a,15},{0xab36,15},{0xab32,15},
{0xab2e,15},{0xab2a,15},{0xab26,15},{0xab22,15},
{0xab1e,15},{0xab1a,15},{0xab16,15},{0xab12,15},
{0xab0e,15},{0xab0a,15},{0xab06,15},{0xab02,15},
{0xaafe,15},{0xaafa,15},{0xaaf6,15},{0xaaf2,15},
{0xaaee,15},{0xaaea,15},{0xaae6,15},{0xaae2,15},
{0xaade,15},{0xaada,15},{0xaad6,15},{0xaad2,15},
{0xaace,15},{0xaaca,15},{0xaac6,15},{0xaac2,15},
{0xaabe,15},{0xaaba,15},{0xaab6,15},{0xaab2,15},
{0xaaae,15},{0xaaaa,15},{0xaaa6,15},{0xaaa2,15},
{0xaa9e,15},{0x3a70,12},{0xaa9a,15},{0xaa96,15},
{0xaa92,15},{0x3080, 9},{0xaa8e,15},{0xaa8a,15},
{0xaa86,15},{0xaa82,15},{0x9ffe,15},{0x9ffa,15},
{0x9ff6,15},{0x9ff2,15},{0x9fee,15},{0x9fea,15},
{0x9fe6,15},{0x9fe2,15},{0x9fde,15},{0x9fda,15},
{0x9fd6,15},{0x9fd2,15},{0x9fce,15},{0x9fca,15},
{0x9fc6,15},{0x9fc2,15},{0x7d7e,15},{0x7d7a,15},
{0x7d76,15},{0x7d72,15},{0x7d6e,15},{0x7d6a,15},
{0x7d66,15},{0x7d62,15},{0x3a46,15},{0x3a44,15}
};

/* huffman decoding table */
static struct huffdecodtab huffdecodtab[] = {
{ 79,  1},{  2, 66},{ 24,  3},{  4,208},
{292,  5},{  6,298},{317,  7},{ 16,  8},
{  9,173},{ 10,116},{ 41, 11},{ 12, 37},
{125, 13},{357, 14},{ 15,438},{  0,  0},
{229, 17},{ 18, 46},{ 19, 61},{ 20, 99},
{ 21,161},{404, 22},{ 23,483},{  1,  0},
{306, 25},{313, 26},{294, 27},{245, 28},
{221, 29},{231, 30},{277, 31},{ 32,103},
{ 33,108},{ 34,339},{421, 35},{ 36,500},
{  2,  0},{122, 38},{353, 39},{ 40,434},
{  3,  0},{131, 42},{128, 43},{361, 44},
{ 45,442},{  4,  0},{ 56, 47},{ 52, 48},
{135, 49},{370, 50},{ 51,450},{  5,  0},
{138, 53},{375, 54},{ 55,454},{  6,  0},
{148, 57},{ 58, 94},{381, 59},{ 60,460},
{  7,  0},{ 75, 62},{ 63,152},{392, 64},
{ 65,469},{  8,  0},{164, 67},{311, 68},
{ 69,246},{ 70, 97},{253, 71},{257, 72},
{ 73,270},{319, 74},{  9,  0},{ 76,155},
{396, 77},{ 78,473},{ 10,  0},{165, 80},
{296, 81},{300, 82},{295, 83},{206, 84},
{ 85,320},{193, 86},{ 87,318},{199, 88},
{184, 89},{ 90,112},{ 91,346},{430, 92},
{ 93,508},{ 11,  0},{379, 95},{ 96,458},
{ 12,  0},{ 98,218},{ 13,  0},{100,158},
{400,101},{102,478},{ 14,  0},{331,104},
{105,328},{408,106},{107,487},{ 15,  0},
{109,336},{417,110},{111,496},{ 16,  0},
{113,343},{425,114},{115,504},{ 17,  0},
{117,141},{118,186},{119,321},{351,120},
{121,432},{ 18,  0},{355,123},{124,436},
{ 19,  0},{359,126},{127,440},{ 20,  0},
{364,129},{130,444},{ 21,  0},{132,145},
{368,133},{134,448},{ 22,  0},{372,136},
{137,452},{ 23,  0},{377,139},{140,456},
{ 24,  0},{142,234},{143,236},{144,383},
{ 25,  0},{366,146},{147,446},{ 26,  0},
{387,149},{385,150},{151,462},{ 27,  0},
{390,153},{154,467},{ 28,  0},{394,156},
{157,471},{ 29,  0},{398,159},{160,475},
{ 30,  0},{402,162},{163,481},{ 31,  0},
{ 32,  0},{175,166},{214,167},{211,168},
{169,195},{243,170},{171,281},{286,172},
{ 33,  0},{265,174},{ 34,  0},{176,202},
{177,315},{178,297},{179,232},{180,252},
{181,228},{189,182},{255,183},{ 35,  0},
{185,242},{ 36,  0},{284,187},{192,188},
{ 37,  0},{190,241},{191,201},{ 38,  0},
{ 39,  0},{194,227},{ 40,  0},{196,267},
{197,220},{237,198},{ 41,  0},{200,309},
{ 42,  0},{ 43,  0},{203,260},{204,268},
{308,205},{ 44,  0},{244,207},{ 45,  0},
{304,209},{210,223},{ 46,  0},{212,258},
{238,213},{ 47,  0},{215,303},{216,249},
{273,217},{ 48,  0},{219,316},{ 49,  0},
{ 50,  0},{222,278},{ 51,  0},{224,264},
{250,225},{230,226},{ 52,  0},{ 53,  0},
{ 54,  0},{ 55,  0},{ 56,  0},{ 57,  0},
{251,233},{ 58,  0},{363,235},{ 59,  0},
{ 60,  0},{ 61,  0},{239,256},{240,480},
{ 62,  0},{ 63,  0},{ 64,  0},{ 65,  0},
{ 66,  0},{ 67,  0},{299,247},{275,248},
{ 68,  0},{ 69,  0},{ 70,  0},{ 71,  0},
{ 72,  0},{271,254},{ 73,  0},{ 74,  0},
{ 75,  0},{ 76,  0},{259,269},{ 77,  0},
{293,261},{262,263},{ 78,  0},{ 79,  0},
{ 80,  0},{279,266},{ 81,  0},{ 82,  0},
{ 83,  0},{ 84,  0},{ 85,  0},{342,272},
{ 86,  0},{274,335},{ 87,  0},{276,302},
{ 88,  0},{ 89,  0},{ 90,  0},{283,280},
{ 91,  0},{374,282},{ 92,  0},{ 93,  0},
{291,285},{ 94,  0},{301,287},{288,326},
{323,289},{290,427},{ 95,  0},{ 96,  0},
{ 97,  0},{ 98,  0},{ 99,  0},{100,  0},
{101,  0},{102,  0},{103,  0},{104,  0},
{105,  0},{106,  0},{107,  0},{108,  0},
{305,307},{109,  0},{110,  0},{111,  0},
{112,  0},{310,384},{113,  0},{312,314},
{114,  0},{115,  0},{116,  0},{117,  0},
{118,  0},{119,  0},{120,  0},{121,  0},
{122,  0},{322,325},{123,  0},{349,324},
{124,  0},{125,  0},{327,476},{126,  0},
{406,329},{330,485},{127,  0},{412,332},
{410,333},{334,489},{128,  0},{129,  0},
{415,337},{338,494},{130,  0},{419,340},
{341,498},{131,  0},{132,  0},{423,344},
{345,502},{133,  0},{428,347},{348,506},
{134,  0},{350,510},{135,  0},{352,433},
{136,  0},{354,435},{137,  0},{356,437},
{138,  0},{358,439},{139,  0},{360,441},
{140,  0},{362,443},{141,  0},{142,  0},
{365,445},{143,  0},{367,447},{144,  0},
{369,449},{145,  0},{371,451},{146,  0},
{373,453},{147,  0},{148,  0},{376,455},
{149,  0},{378,457},{150,  0},{380,459},
{151,  0},{382,461},{152,  0},{153,  0},
{154,  0},{386,463},{155,  0},{388,464},
{389,466},{156,  0},{391,468},{157,  0},
{393,470},{158,  0},{395,472},{159,  0},
{397,474},{160,  0},{399,477},{161,  0},
{401,479},{162,  0},{403,482},{163,  0},
{405,484},{164,  0},{407,486},{165,  0},
{409,488},{166,  0},{411,490},{167,  0},
{413,491},{414,493},{168,  0},{416,495},
{169,  0},{418,497},{170,  0},{420,499},
{171,  0},{422,501},{172,  0},{424,503},
{173,  0},{426,505},{174,  0},{175,  0},
{429,507},{176,  0},{431,509},{177,  0},
{178,  0},{179,  0},{180,  0},{181,  0},
{182,  0},{183,  0},{184,  0},{185,  0},
{186,  0},{187,  0},{188,  0},{189,  0},
{190,  0},{191,  0},{192,  0},{193,  0},
{194,  0},{195,  0},{196,  0},{197,  0},
{198,  0},{199,  0},{200,  0},{201,  0},
{202,  0},{203,  0},{204,  0},{205,  0},
{206,  0},{207,  0},{208,  0},{209,  0},
{  0,465},{210,  0},{211,  0},{212,  0},
{213,  0},{214,  0},{215,  0},{216,  0},
{217,  0},{218,  0},{219,  0},{220,  0},
{221,  0},{222,  0},{223,  0},{224,  0},
{225,  0},{226,  0},{227,  0},{228,  0},
{229,  0},{230,  0},{231,  0},{232,  0},
{233,  0},{234,  0},{235,  0},{  0,492},
{236,  0},{237,  0},{238,  0},{239,  0},
{240,  0},{241,  0},{242,  0},{243,  0},
{244,  0},{245,  0},{246,  0},{247,  0},
{248,  0},{249,  0},{250,  0},{251,  0},
{252,  0},{253,  0},{512,511},{254,  0},
{255,  0}
};

static unsigned char mask8tab[8] = {
0x80,0x40,0x20,0x10,0x08,0x04,0x02,0x01
};

static unsigned short mask16tab[16] = {
0x8000,0x4000,0x2000,0x1000,0x0800,0x0400,0x0200,0x0100,
0x0080,0x0040,0x0020,0x0010,0x0008,0x0004,0x0002,0x0001
};


/* The buffer in src (first byte length-1) is decoded into dest
   (first byte length-1). If decoding is not successful, non-0 
   is returned
*/
int encstathuf(src,srclen,dest,destlen)
char *src;
int srclen;
char *dest;
int *destlen;
{
  char *srcptr;
  char *destptr;
  int wrklen;
  int bit16;
  int bit8;
  unsigned short huffcode;
  int hufflen;
  
  if ((src == NULL) || (dest == NULL)) return(1);
  if (srclen > 255) return(1);
  srcptr = src;
  destptr = &dest[1];
  *destlen = 0;
  wrklen = 0;
  bit8 = 0;
  *destptr = 0;
  huffcode = huffencodtab[(int)*srcptr].code;
  hufflen = huffencodtab[(int)*srcptr].len;
  bit16 = 0;
  for (;;) {
    if (huffcode & mask16tab[bit16])
      *destptr |= mask8tab[bit8];
    bit8++;
    if (bit8 > 7) {
      destptr++;
      (*destlen)++;
      if ((*destlen) >= srclen) {
        /* coding uneffective, use copy */
        memcpy(&dest[1],src,srclen);
        dest[0] = 255;
        *destlen = srclen + 1;
        return(0);
      }
      bit8 = 0;
      *destptr = 0;
    }
    bit16++;
    if (bit16 == hufflen) {
      srcptr++;
      wrklen++;
      if (wrklen == srclen) break;
      huffcode = huffencodtab[(int)*srcptr].code;
      hufflen = huffencodtab[(int)*srcptr].len;
      bit16 = 0;
    }
  }
  if (bit8 != 0) (*destlen)++;
  (*destlen)++;
  dest[0] = (char)(srclen-1);
  return(0);
}

/* The buffer in src (first byte length-1) is decoded into dest
   (first byte length-1). If decoding is not successful, non-0 
   is returned
*/
int decstathuf(src,dest)
char *src;
char *dest;
{
  int srclen;
  int destlen;
  char *srcptr;
  char *destptr;
  int wrklen;
  unsigned char bitmask;
  unsigned short decod;
  unsigned short newnode;
  
  if ((src == NULL) || (dest == NULL)) return(1);
  srclen = (int)((*src) + 1);
  srcptr = &src[1];
  destptr = &dest[1];
  destlen = (int)((*srcptr)+1);
  srcptr++;
  if (--srclen == 0) return(1);
  if (destlen == 0) return(1);
  if (destlen == 256) {
    /* no compression, only copy */
    srclen = (int)((*src) + 1);
    memcpy(&dest[1],&src[2],srclen-1);
    *dest = (char)(srclen-2);
    return(0);
  }
  wrklen = 0;
  decod = 0;
  bitmask = 0x80;
  for (;;) {
    while (bitmask > 0) {
      if ((*srcptr) & bitmask) {
        newnode = huffdecodtab[decod].node2;
        if (newnode == 0) {
          *destptr = (char)huffdecodtab[decod].node1;
          destptr++;
          wrklen++;
          if (wrklen >= destlen) break; /* decoding finished */
          decod = 0;
        }
        else decod = newnode;
      }
      else {
        newnode = huffdecodtab[decod].node1;
        if (huffdecodtab[decod].node2 == 0) {
          *destptr = (char)huffdecodtab[decod].node1;
          destptr++;
          wrklen++;
          if (wrklen >= destlen) break; /* decoding finished */
          decod = 0;
        }
        else decod = newnode;
      }
      if (decod) bitmask = bitmask >> 1;
    }
    if (wrklen >= destlen) break;
    bitmask = 0x80;
    srcptr++;
    if (srclen == 0) return(1);
    srclen--;
  }
  *dest = (char)(destlen-1);
  return(0);
}
