/* Copyright (C) 1994 Guido Vattrodt DL3BZN
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* menu.c	menufunctions for xconvers
 */

#include <sys/types.h>
#include <stdio.h>
#include <unistd.h>

#include <Xm/Xm.h>
#include <Xm/Text.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>

#include "xconvers.h"
#include "file.h"
#include "misc.h"
#include "text.h"
#include "settings.h"
#include "menu_util.h"
#include "menu.h"

/* globals */
extern int 	socket_fd;		/* socket filedescriptor */


/*---------------------------------------------------------------------------
 * CommandsCB  send command to socket
 */
void CommandsCB(widget, client_data, call_data)
	Widget	widget;
	caddr_t	client_data, call_data;
{
  char 	string[MAX_COMMANDLEN+5];
  char	*command;

  /* -- write to socket -- */
  if(socket_fd) {
     command = ResourceText(widget, "command", "/help");
     if(strlen(command) > MAX_COMMANDLEN) command[MAX_COMMANDLEN] = 0;
     sprintf(string, "\n%s\n", command);
     if(!strcmp(command, QUIT_COMMAND)) DisconnectCB(widget, client_data, call_data);
     else if(write(socket_fd, string, strlen(string)) < 0) stop("write to socket"); 
  }
}

/*---------------------------------------------------------------------------
 *   CreateMenu  create pulldownmenue
 */
Widget CreatePulldownMenu(parent, app_w)
	Widget(parent);
 	AppWidgets	*app_w;
{
  Widget	menu_bar, pane;
  Arg		arg[3];
  Cardinal	n;
  int		nr;
  char		b_name[8];
  
  /* -- create menubar -- */
  n = 0;
  XtSetArg(arg[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(arg[n], XmNrightAttachment, XmATTACH_FORM); n++;
  menu_bar = XmCreateMenuBar(parent, "menuBar", arg, n);

  pane = CreatePulldownPane(menu_bar, "filePane");
  CascadeButton(menu_bar, "fileMenu", pane);
  PushButton(pane, "start_record", DisplayFileBoxCB, (caddr_t) app_w);
  app_w->button_stop_recording = PushButton(pane, "stop_record", StopRecordingCB, (caddr_t) app_w);
  XtSetSensitive(app_w->button_stop_recording, False);  
  Separator(pane);
  PushButton(pane, "quit", ExitCB, NULL);

  /* -- create 2. menu -- */
  pane = CreatePulldownPane(menu_bar, "optionPane");
  CascadeButton(menu_bar, "optionMenu", pane);
  app_w->button_settings = PushButton(pane, "menuSettings", SettingsCB, (caddr_t) app_w);

  /* -- create 3. menu -- */
  pane = CreatePulldownPane(menu_bar, "commPane");
  CascadeButton(menu_bar, "commMenu", pane);
  for(nr=1; nr <=MAXNR_COMMANDS; nr++) {
     sprintf(b_name, "commM%d", nr);			/* create widget name */
     if(*ResourceText(pane, b_name, "_") != '_') 	/* does this resource exist? */
        PushButton(pane, b_name, CommandsCB, (caddr_t) app_w);
  }
  XtSetSensitive(pane, False);  
  app_w->menu_comm = pane;

  /* -- register menubar on parent -- */
  XtManageChild(menu_bar);
  return(menu_bar);
}  

/*---------------------------------------------------------------------------
 *   CreateCommands  create line with commandbuttons; returns Form-Widget
 */
Widget CreateCommands(parent, app_w)
	Widget		parent;
	AppWidgets	*app_w;
{
  Widget	form, button1, button2;
  Arg		arg[10];
  Cardinal	n;

  n = 0;
  XtSetArg(arg[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(arg[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(arg[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(arg[n], XmNorientation, XmHORIZONTAL); n++;
  XtSetArg(arg[n], XmNbottomOffset, 5); n++;
  XtSetArg(arg[n], XmNleftOffset, 10); n++;
  form = XmCreateForm(parent, "commands", arg, n); 
  XtManageChild(form);

  n = 0;
  XtSetArg(arg[n], XmNleftAttachment, XmATTACH_FORM); n++;
  button1 = XmCreatePushButton(form, "clear", arg, n);
  XtManageChild(button1);
  XtAddCallback(button1, XmNactivateCallback, (XtCallbackProc)ClearCB, app_w);

  n = 0;
  XtSetArg(arg[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(arg[n], XmNleftWidget, button1); n++;
  XtSetArg(arg[n], XmNleftOffset, 10); n++;
  button2 = XmCreatePushButton(form, "connect", arg, n);
  XtManageChild(button2);
  app_w->button_connect = button2;
  XtAddCallback(button2, XmNactivateCallback, (XtCallbackProc)ConnectCB, app_w);

  n = 0;
  XtSetArg(arg[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(arg[n], XmNleftWidget, button2); n++;
  XtSetArg(arg[n], XmNsensitive, False); n++;
  XtSetArg(arg[n], XmNleftOffset, 10); n++;
  button1 = XmCreatePushButton(form, "disconnect", arg, n);
  XtManageChild(button1);
  app_w->button_disconnect = button1;
  XtAddCallback(button1, XmNactivateCallback, (XtCallbackProc)DisconnectCB, app_w);

  return(form);
}

