/*
 * FILE : ../_gnomemodule.c
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1 (Patch 2)
 * 
 * Portions Copyright (c) 1995-1997
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 * 
 * Do not make changes to this file--changes will be lost!
 *
 */


#define SWIGCODE
/* Implementation : PYTHON */

#define SWIGPYTHON
#include <string.h>
#include <stdlib.h>
/***********************************************************************
 * $Header:$
 * swig_lib/python/python.cfg
 *
 * This file contains coded needed to add variable linking to the
 * Python interpreter.   C variables are added as a new kind of Python
 * datatype.
 *
 * Also contains supporting code for building python under Windows
 * and things like that.
 *
 * $Log:$
 ************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif
#include "Python.h"
#ifdef __cplusplus
}
#endif

/* Definitions for Windows/Unix exporting */
#if defined(__WIN32__)
#   if defined(_MSC_VER)
#	define SWIGEXPORT(a,b) __declspec(dllexport) a b
#   else
#	if defined(__BORLANDC__)
#	    define SWIGEXPORT(a,b) a _export b
#	else
#	    define SWIGEXPORT(a,b) a b
#	endif
#   endif
#else
#   define SWIGEXPORT(a,b) a b
#endif

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif

typedef struct {
  char  *name;
  PyObject *(*get_attr)(void);
  int (*set_attr)(PyObject *);
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar **vars;
  int      nvars;
  int      maxvars;
} swig_varlinkobject;

/* ----------------------------------------------------------------------
   swig_varlink_repr()

   Function for python repr method
   ---------------------------------------------------------------------- */

static PyObject *
swig_varlink_repr(swig_varlinkobject *v)
{
  v = v;
  return PyString_FromString("<Global variables>");
}

/* ---------------------------------------------------------------------
   swig_varlink_print()

   Print out all of the global variable names
   --------------------------------------------------------------------- */

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags)
{

  int i = 0;
  flags = flags;
  fprintf(fp,"Global variables { ");
  while (v->vars[i]) {
    fprintf(fp,"%s", v->vars[i]->name);
    i++;
    if (v->vars[i]) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

/* --------------------------------------------------------------------
   swig_varlink_getattr
 
   This function gets the value of a variable and returns it as a
   PyObject.   In our case, we'll be looking at the datatype and
   converting into a number or string
   -------------------------------------------------------------------- */

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n)
{
  int i = 0;
  char temp[128];

  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->get_attr)();
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return NULL;
}

/* -------------------------------------------------------------------
   swig_varlink_setattr()

   This function sets the value of a variable.
   ------------------------------------------------------------------- */

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p)
{
  char temp[128];
  int i = 0;
  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->set_attr)(p);
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return 1;
}

statichere PyTypeObject varlinktype = {
/*  PyObject_HEAD_INIT(&PyType_Type)  Note : This doesn't work on some machines */
  PyObject_HEAD_INIT(0)              
  0,
  "varlink",                          /* Type name    */
  sizeof(swig_varlinkobject),         /* Basic size   */
  0,                                  /* Itemsize     */
  0,                                  /* Deallocator  */ 
  (printfunc) swig_varlink_print,     /* Print        */
  (getattrfunc) swig_varlink_getattr, /* get attr     */
  (setattrfunc) swig_varlink_setattr, /* Set attr     */
  0,                                  /* tp_compare   */
  (reprfunc) swig_varlink_repr,       /* tp_repr      */    
  0,                                  /* tp_as_number */
  0,                                  /* tp_as_mapping*/
  0,                                  /* tp_hash      */
};

/* Create a variable linking object for use later */

SWIGSTATIC PyObject *
SWIG_newvarlink(void)
{
  swig_varlinkobject *result = 0;
  result = PyMem_NEW(swig_varlinkobject,1);
  varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
  result->ob_type = &varlinktype;
  /*  _Py_NewReference(result);  Does not seem to be necessary */
  result->nvars = 0;
  result->maxvars = 64;
  result->vars = (swig_globalvar **) malloc(64*sizeof(swig_globalvar *));
  result->vars[0] = 0;
  Py_XINCREF((PyObject *) result);
  return ((PyObject*) result);
}

SWIGSTATIC void
SWIG_addvarlink(PyObject *p, char *name,
	   PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p))
{
  swig_varlinkobject *v;
  v= (swig_varlinkobject *) p;
	
  if (v->nvars >= v->maxvars -1) {
    v->maxvars = 2*v->maxvars;
    v->vars = (swig_globalvar **) realloc(v->vars,v->maxvars*sizeof(swig_globalvar *));
    if (v->vars == NULL) {
      fprintf(stderr,"SWIG : Fatal error in initializing Python module.\n");
      exit(1);
    }
  }
  v->vars[v->nvars] = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  v->vars[v->nvars]->name = (char *) malloc(strlen(name)+1);
  strcpy(v->vars[v->nvars]->name,name);
  v->vars[v->nvars]->get_attr = get_attr;
  v->vars[v->nvars]->set_attr = set_attr;
  v->nvars++;
  v->vars[v->nvars] = 0;
}



/* remove swig pointer handling code */
#define SWIG_RegisterMapping(o,n,f)
#define SWIG_MakePtr(b,p,t)
#define SWIG_GetPtr(b,p,t) NULL

#define SWIG_init    init_gnome

#define SWIG_name    "_gnome"

#include "libgnome/libgnome.h"
#include "libgnome/gnome-history.h"
#include "libgnome/gnome-fileconvert.h"
/* #include "libgnome/gnome-mime.h" */

static PyObject *gnome__config_get_vector(PyObject *self, PyObject *args) {
  char *path;
  int argc, i;
  char **argv;
  PyObject *ret;

  if (!PyArg_ParseTuple(args, "s:gnome_config_get_vector", &path))
    return NULL;
  gnome_config_get_vector(path, &argc, &argv);
  ret = PyTuple_New(argc);
  for (i = 0; i < argc; i++)
    PyTuple_SetItem(ret, i, PyString_FromString(argv[i]));
  return ret;
}
static PyObject *gnome__config_private_get_vector(PyObject *self,
						  PyObject *args) {
  char *path;
  int argc, i;
  char **argv;
  PyObject *ret;

  if (!PyArg_ParseTuple(args, "s:gnome_config_private_get_vector", &path))
    return NULL;
  gnome_config_private_get_vector(path, &argc, &argv);
  ret = PyTuple_New(argc);
  for (i = 0; i < argc; i++)
    PyTuple_SetItem(ret, i, PyString_FromString(argv[i]));
  return ret;
}

static PyObject *gnome__config_set_vector(PyObject *self, PyObject *args) {
  char *path;
  PyObject *seq, *item;
  int argc, i;
  char **argv;
  if (!PyArg_ParseTuple(args, "sO:gnome_config_set_vector", &path, &seq))
    return NULL;
  if (!PySequence_Check(seq)) {
    PyErr_SetString(PyExc_TypeError, "second argument not a sequence");
    return NULL;
  }
  argc = PySequence_Length(seq);
  argv = g_new(char *, argc);
  for (i = 0; i < argc; i++) {
    item = PySequence_GetItem(seq, i);
    if (!PyString_Check(item)) {
      PyErr_SetString(PyExc_TypeError, "sequence member not a string");
      g_free(argv);
      return NULL;
    }
    argv[i] = PyString_AsString(item);
  }
  gnome_config_set_vector(path, argc, (const char **)argv);
  g_free(argv);
  Py_INCREF(Py_None);
  return Py_None;
}
static PyObject *gnome__config_private_set_vector(PyObject *self,
						  PyObject *args) {
  char *path;
  PyObject *seq, *item;
  int argc, i;
  char **argv;
  if (!PyArg_ParseTuple(args, "sO:gnome_config_private_set_vector", &path,
			&seq))
    return NULL;
  if (!PySequence_Check(seq)) {
    PyErr_SetString(PyExc_TypeError, "second argument not a sequence");
    return NULL;
  }
  argc = PySequence_Length(seq);
  argv = g_new(char *, argc);
  for (i = 0; i < argc; i++) {
    item = PySequence_GetItem(seq, i);
    if (!PyString_Check(item)) {
      PyErr_SetString(PyExc_TypeError, "sequence member not a string");
      g_free(argv);
      return NULL;
    }
    argv[i] = PyString_AsString(item);
  }
  gnome_config_private_set_vector(path, argc, (const char **)argv);
  g_free(argv);
  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *gnome_config_section_contents(PyObject *self,PyObject *args) {
  char *path, *key, *value;
  void *iterator;
  PyObject *ret;
  
  if (!PyArg_ParseTuple(args, "s:gnome_config_section_contents", &path))
    return NULL;
  iterator = gnome_config_init_iterator(path);
  ret = PyDict_New();
  while (iterator) {
    iterator = gnome_config_iterator_next(iterator, &key, &value);
    PyDict_SetItemString(ret, key, PyString_FromString(value));
  }
  return ret;
}
static PyObject *gnome_config_enum_sections(PyObject *self, PyObject *args) {
  char *path, *key;
  void *iterator;
  PyObject *ret;
  if (!PyArg_ParseTuple(args, "s:gnome_config_enum_sections", &path))
    return NULL;
  iterator = gnome_config_init_iterator_sections(path);
  ret = PyList_New(0);
  while (iterator) {
    iterator = gnome_config_iterator_next(iterator, &key, NULL);
    PyList_Append(ret, PyString_FromString(key));
  }
  return ret;
}
static PyObject *gnome_config_private_section_contents(PyObject *self,
						       PyObject *args) {
  char *path, *key, *value;
  void *iterator;
  PyObject *ret;
  
  if (!PyArg_ParseTuple(args, "s:gnome_config_private_section_contents",&path))
    return NULL;
  iterator = gnome_config_private_init_iterator(path);
  ret = PyDict_New();
  while (iterator) {
    iterator = gnome_config_iterator_next(iterator, &key, &value);
    PyDict_SetItemString(ret, key, PyString_FromString(value));
  }
  return ret;
}
static PyObject *gnome_config_private_enum_sections(PyObject *self,
						    PyObject *args) {
  char *path, *key;
  void *iterator;
  PyObject *ret;
  if (!PyArg_ParseTuple(args, "s:gnome_config_private_enum_sections", &path))
    return NULL;
  iterator = gnome_config_private_init_iterator_sections(path);
  ret = PyList_New(0);
  while (iterator) {
    iterator = gnome_config_iterator_next(iterator, &key, NULL);
    PyList_Append(ret, PyString_FromString(key));
  }
  return ret;
}

static PyObject *gnome_file_convert_stream(PyObject *self, PyObject *args) {
  PyObject *in_file;
  int fd, out_fd;
  char *fromtype, *totype;
  FILE *fp;

  if (!PyArg_ParseTuple(args, "O!ss:gnome_file_convert_stream", &PyFile_Type,
			&in_file, &fromtype, &totype))
    return NULL;
  fd = fileno(PyFile_AsFile(in_file));
  out_fd = gnome_file_convert_fd(fd, fromtype, totype);
  if (fd < 0 || (fp = fdopen(out_fd, "rb")) == NULL) {
    PyErr_SetString(PyExc_IOError, "can't make conversion");
    return NULL;
  }
  return PyFile_FromFile(fp, "<conversion>", "rb", fclose);
}
static PyObject *gnome__file_convert(PyObject *self, PyObject *args) {
  char *filename, *fromtype, *totype;
  int fd;
  FILE *fp;
  if (!PyArg_ParseTuple(args, "sss:gnome_file_convert", &filename, &fromtype,
			&totype))
    return NULL;
  fd = gnome_file_convert(filename, fromtype, totype);
  if (fd < 0 || (fp = fdopen(fd, "rb")) == NULL) {
    PyErr_SetString(PyExc_IOError, "can't make conversion");
    return NULL;
  }
  return PyFile_FromFile(fp, "<conversion>", "rb", fclose);
}

static PyObject *gnome__help_file_find_file(PyObject *self, PyObject *args) {
  char *app, *path, *ret;
  PyObject *py_ret;
  if (!PyArg_ParseTuple(args, "ss:gnome_help_file_find_file", &app, &path))
    return NULL;
  ret = gnome_help_file_find_file(app, path);
  py_ret = PyString_FromString(ret);
  g_free(ret);
  return py_ret;
}
static PyObject *gnome__help_file_path(PyObject *self, PyObject *args) {
  char *app, *path, *ret;
  PyObject *py_ret;
  if (!PyArg_ParseTuple(args, "ss:gnome_help_file_path", &app, &path))
    return NULL;
  ret = gnome_help_file_path(app, path);
  py_ret = PyString_FromString(ret);
  g_free(ret);
  return py_ret;
}
static PyObject *gnome__help_display(PyObject *self, PyObject *args) {
  GnomeHelpMenuEntry ref;
  if (!PyArg_ParseTuple(args, "ss:gnome_help_display", &(ref.name),
			&(ref.path)))
    return NULL;
  gnome_help_display(NULL, &ref);
  Py_INCREF(Py_None);
  return Py_None;
}
static PyObject *gnome__help_goto(PyObject *self, PyObject *args) {
  char *file;
  if (!PyArg_ParseTuple(args, "s:gnome_help_goto", &file))
    return NULL;
  gnome_help_goto(NULL, file);
  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *gnome__history_get_recently_used(PyObject *self,
						 PyObject *args) {
  GList *list;
  PyObject *py_list;
  GnomeHistoryEntry entry;
  if (!PyArg_ParseTuple(args, ":gnome_history_get_recently_used"))
    return NULL;
  list = gnome_history_get_recently_used();
  py_list = PyList_New(0);
  while (list) {
    entry = list->data;
    PyList_Append(py_list, Py_BuildValue("(ssss)", entry->filename,
					 entry->filetype, entry->creator,
					 entry->desc));
    list = g_list_next(list);
  }
  gnome_history_free_recently_used_list(list);
  return py_list;
}

/* translate return value */
static PyObject *metadata_set_ret(int retval) {
  if (retval == GNOME_METADATA_IO_ERROR) {
    PyErr_SetString(PyExc_IOError, "low-level communications/storage error");
    return NULL;
  } else if (retval == GNOME_METADATA_NOT_FOUND) {
    PyErr_SetString(PyExc_KeyError, "metadata attribute not found");
    return NULL;
  } else {
    Py_INCREF(Py_None);
    return Py_None;
  }
}
static PyObject *gnome__metadata_set(PyObject *self, PyObject *args) {
  char *file, *key, *value;
  int vallen;
  if (!PyArg_ParseTuple(args, "sss#:gnome_metadata_set", &file, &key, &value,
			&vallen))
    return NULL;
  return metadata_set_ret(gnome_metadata_set(file, key, vallen, value));
}
static PyObject *gnome__metadata_remove(PyObject *self, PyObject *args) {
  char *file, *key;
  if (!PyArg_ParseTuple(args, "ss:gnome_metadata_remove", &file, &key))
    return NULL;
  return metadata_set_ret(gnome_metadata_remove(file, key));
}
static PyObject *gnome__metadata_list(PyObject *self, PyObject *args) {
  char *file, **ret, **tmp;
  PyObject *list;
  if (!PyArg_ParseTuple(args, "s:gnome_metadata_list", &file))
    return NULL;
  ret = gnome_metadata_list(file);
  list = PyList_New(0);
  for (tmp = ret; *tmp != NULL; tmp++)
    PyList_Append(list, PyString_FromString(*tmp));
  gnome_string_array_free(ret);
  return list;
}
static PyObject *gnome__metadata_get(PyObject *self, PyObject *args) {
  char *file, *key, *value;
  int valuelen;
  PyObject *ret;
  if (!PyArg_ParseTuple(args, "ss:gnome_metadata_get", &file, &key))
    return NULL;
  ret = metadata_set_ret(gnome_metadata_get(file, key, &valuelen, &value));
  if (ret == NULL) return NULL;
  Py_DECREF(ret);
  ret = PyString_FromStringAndSize(value, valuelen);
  g_free(value);
  return ret;
}
static PyObject *gnome__metadata_get_fast(PyObject *self, PyObject *args) {
  char *file, *key, *value;
  int valuelen;
  PyObject *ret;
  if (!PyArg_ParseTuple(args, "ss:gnome_metadata_get_fast", &file, &key))
    return NULL;
  ret = metadata_set_ret(gnome_metadata_get_fast(file, key, &valuelen,&value));
  if (ret == NULL) return NULL;
  Py_DECREF(ret);
  ret = PyString_FromStringAndSize(value, valuelen);
  g_free(value);
  return ret;
}
static PyObject *gnome__metadata_rename(PyObject *self, PyObject *args) {
  char *file, *to;
  if (!PyArg_ParseTuple(args, "ss:gnome_metadata_rename", &file, &to))
    return NULL;
  return metadata_set_ret(gnome_metadata_rename(file, to));
}
static PyObject *gnome__metadata_copy(PyObject *self, PyObject *args) {
  char *file, *to;
  if (!PyArg_ParseTuple(args, "ss:gnome_metadata_copy", &file, &to))
    return NULL;
  return metadata_set_ret(gnome_metadata_copy(file, to));
}
static PyObject *gnome__metadata_delete(PyObject *self, PyObject *args) {
  char *file;
  if (!PyArg_ParseTuple(args, "s:gnome_metadata_delete", &file))
    return NULL;
  return metadata_set_ret(gnome_metadata_delete(file));
}
static PyObject *gnome__metadata_regex_add(PyObject *self, PyObject *args) {
  char *regex, *key, *value;
  int vallen;
  if (!PyArg_ParseTuple(args, "sss#:gnome_metadata_regex_add", &regex, &key,
			&value, &vallen))
    return NULL;
  gnome_metadata_regex_add(regex, key, vallen, value);
  Py_INCREF(Py_None);
  return Py_None;
}
static PyObject *gnome__metadata_regex_remove(PyObject *self, PyObject *args) {
  char *regex, *key;
  if (!PyArg_ParseTuple(args, "ss:gnome_metadata_regex_remove", &regex, &key))
    return NULL;
  gnome_metadata_regex_remove(regex, key);
  Py_INCREF(Py_None);
  return Py_None;
}
static PyObject *gnome__metadata_type_add(PyObject *self, PyObject *args) {
  char *type, *key, *value;
  int vallen;
  if (!PyArg_ParseTuple(args, "sss#:gnome_metadata_type_add", &type, &key,
			&value, &vallen))
    return NULL;
  gnome_metadata_type_add(type, key, vallen, value);
  Py_INCREF(Py_None);
  return Py_None;
}
static PyObject *gnome__metadata_type_remove(PyObject *self, PyObject *args) {
  char *type, *key;
  if (!PyArg_ParseTuple(args, "ss:gnome_metadata_type_remove", &type, &key))
    return NULL;
  gnome_metadata_type_remove(type, key);
  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *gnome__score_log(PyObject *self, PyObject *args) {
  double score;
  char *level = NULL;
  int high_to_low;
  if (!PyArg_ParseTuple(args, "fzi:gnome_score_log", &score, &level,
			&high_to_low))
    return NULL;
  return PyInt_FromLong(gnome_score_log(score, level, high_to_low));
}
static PyObject *gnome__score_get_notable(PyObject *self, PyObject *args) {
  char *gamename = NULL, *level = NULL, **names;
  gfloat *scores;
  time_t *scoretimes;
  PyObject *ret;
  int len, i;
  if (!PyArg_ParseTuple(args, "zz:gnome_score_get_notable", &gamename, &level))
    return NULL;
  len = gnome_score_get_notable(gamename, level, &names, &scores, &scoretimes);
  ret = PyList_New(len);
  for (i = 0; i < len; i++) {
    PyList_SetItem(ret, i, Py_BuildValue("(sfi)", names[i], scores[i],
					 scoretimes[i]));
    g_free(names[i]);
  }
  g_free(names);
  g_free(scores);
  g_free(scoretimes);
  return ret;
}

static PyObject *gnome__triggers_add_trigger(PyObject *self, PyObject *args) {
  int len, i;
  struct _GnomeTrigger nt;
  PyObject *two, *supinf, *item;
  char **supinfo;

  if (!PyArg_ParseTuple(args, "iOsO:gnome_triggers_add_trigger", &(nt.type),
			&two, &(nt.level), &supinf))
    return NULL;
  switch (nt.type) {
  case GTRIG_NONE:
    break;
  /*GTRIG_FUNCTION:*/
  case GTRIG_COMMAND:
    if (!PyString_Check(two)) {
      PyErr_SetString(PyExc_TypeError, "second arg not a string");
      return NULL;
    }
    nt.u.command = PyString_AsString(two);
    break;
  case GTRIG_MEDIAPLAY:
    if (!PyString_Check(two)) {
      PyErr_SetString(PyExc_TypeError, "second arg not a string");
      return NULL;
    }
    nt.u.mediafile = PyString_AsString(two);
    break;
  default:
    PyErr_SetString(PyExc_TypeError, "unsupported trigger type");
    return NULL;
  }
  if (!PySequence_Check(supinf)) {
    PyErr_SetString(PyExc_TypeError, "forth argument not a sequence");
    return NULL;
  }
  len = PySequence_Length(supinf);
  supinfo = g_new(char *, len+1);
  supinfo[len] = NULL;
  for (i = 0; i < len; i++) {
    item = PySequence_GetItem(supinf, i);
    if (!PyString_Check(item)) {
      PyErr_SetString(PyExc_TypeError, "sequence member not a string");
      g_free(supinfo);
      return NULL;
    }
    supinfo[i] = PyString_AsString(item);
  }
  gnome_triggers_vadd_trigger(&nt, supinfo);
  g_free(supinfo);
  Py_INCREF(Py_None);
  return Py_None;
}
static PyObject *gnome__triggers_do(PyObject *self, PyObject *args) {
  PyObject *supinf, *item;
  int len, i;
  char *msg, *level, **supinfo;

  if (!PyArg_ParseTuple(args, "ssO:gnome_triggers_do", &msg, &level, &supinf))
    return NULL;
  if (!PySequence_Check(supinf)) {
    PyErr_SetString(PyExc_TypeError, "third argument not a sequence");
    return NULL;
  }
  len = PySequence_Length(supinf);
  supinfo = g_new(char *, len+1);
  supinfo[len] = NULL;
  for (i = 0; i < len; i++) {
    item = PySequence_GetItem(supinf, i);
    if (!PyString_Check(item)) {
      PyErr_SetString(PyExc_TypeError, "sequence member not a string");
      g_free(supinfo);
      return NULL;
    }
    supinfo[i] = PyString_AsString(item);
  }
  gnome_triggers_vdo(msg, level, supinfo);
  g_free(supinfo);
  Py_INCREF(Py_None);
  return Py_None;
}
static PyObject *_wrap_gnomelib_init(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnomelib_init",&_arg0)) 
        return NULL;
    gnomelib_init(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_config_get_string(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_config_get_string",&_arg0)) 
        return NULL;
    _result = (char *)gnome_config_get_string(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gnome_config_get_translated_string(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_config_get_translated_string",&_arg0)) 
        return NULL;
    _result = (char *)gnome_config_get_translated_string(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gnome_config_get_int(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_config_get_int",&_arg0)) 
        return NULL;
    _result = (int )gnome_config_get_int(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_config_get_float(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_config_get_float",&_arg0)) 
        return NULL;
    _result = (double )gnome_config_get_float(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_config_get_bool(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_config_get_bool",&_arg0)) 
        return NULL;
    _result = (int )gnome_config_get_bool(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_config_private_get_string(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_config_private_get_string",&_arg0)) 
        return NULL;
    _result = (char *)gnome_config_private_get_string(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gnome_config_private_get_translated_string(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_config_private_get_translated_string",&_arg0)) 
        return NULL;
    _result = (char *)gnome_config_private_get_translated_string(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gnome_config_private_get_int(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_config_private_get_int",&_arg0)) 
        return NULL;
    _result = (int )gnome_config_private_get_int(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_config_private_get_float(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_config_private_get_float",&_arg0)) 
        return NULL;
    _result = (double )gnome_config_private_get_float(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_config_private_get_bool(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_config_private_get_bool",&_arg0)) 
        return NULL;
    _result = (int )gnome_config_private_get_bool(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_config_set_string(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;
    char * _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:gnome_config_set_string",&_arg0,&_arg1)) 
        return NULL;
    gnome_config_set_string(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_config_set_translated_string(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;
    char * _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:gnome_config_set_translated_string",&_arg0,&_arg1)) 
        return NULL;
    gnome_config_set_translated_string(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_config_set_int(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"si:gnome_config_set_int",&_arg0,&_arg1)) 
        return NULL;
    gnome_config_set_int(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_config_set_float(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;
    double  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"sd:gnome_config_set_float",&_arg0,&_arg1)) 
        return NULL;
    gnome_config_set_float(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_config_set_bool(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"si:gnome_config_set_bool",&_arg0,&_arg1)) 
        return NULL;
    gnome_config_set_bool(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_config_private_set_string(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;
    char * _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:gnome_config_private_set_string",&_arg0,&_arg1)) 
        return NULL;
    gnome_config_private_set_string(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_config_private_set_translated_string(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;
    char * _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:gnome_config_private_set_translated_string",&_arg0,&_arg1)) 
        return NULL;
    gnome_config_private_set_translated_string(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_config_private_set_int(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"si:gnome_config_private_set_int",&_arg0,&_arg1)) 
        return NULL;
    gnome_config_private_set_int(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_config_private_set_float(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;
    double  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"sd:gnome_config_private_set_float",&_arg0,&_arg1)) 
        return NULL;
    gnome_config_private_set_float(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_config_private_set_bool(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"si:gnome_config_private_set_bool",&_arg0,&_arg1)) 
        return NULL;
    gnome_config_private_set_bool(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_config_has_section(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_config_has_section",&_arg0)) 
        return NULL;
    _result = (int )gnome_config_has_section(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_config_private_has_section(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_config_private_has_section",&_arg0)) 
        return NULL;
    _result = (int )gnome_config_private_has_section(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_config_drop_all(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_config_drop_all")) 
        return NULL;
    gnome_config_drop_all();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_config_sync(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_config_sync")) 
        return NULL;
    gnome_config_sync();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_config_clean_file(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_config_clean_file",&_arg0)) 
        return NULL;
    gnome_config_clean_file(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_config_private_clean_file(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_config_private_clean_file",&_arg0)) 
        return NULL;
    gnome_config_private_clean_file(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_config_clean_section(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_config_clean_section",&_arg0)) 
        return NULL;
    gnome_config_clean_section(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_config_private_clean_section(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_config_private_clean_section",&_arg0)) 
        return NULL;
    gnome_config_private_clean_section(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_config_clean_key(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_config_clean_key",&_arg0)) 
        return NULL;
    gnome_config_clean_key(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_config_private_clean_key(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_config_private_clean_key",&_arg0)) 
        return NULL;
    gnome_config_private_clean_key(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_config_push_prefix(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_config_push_prefix",&_arg0)) 
        return NULL;
    gnome_config_push_prefix(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_config_pop_prefix(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_config_pop_prefix")) 
        return NULL;
    gnome_config_pop_prefix();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_history_recently_used(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;
    char * _arg1;
    char * _arg2;
    char * _arg3;

    self = self;
    if(!PyArg_ParseTuple(args,"ssss:gnome_history_recently_used",&_arg0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
    gnome_history_recently_used(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_mime_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_mime_type",&_arg0)) 
        return NULL;
    _result = (char *)gnome_mime_type(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gnome_mime_type_or_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    char * _arg0;
    char * _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:gnome_mime_type_or_default",&_arg0,&_arg1)) 
        return NULL;
    _result = (char *)gnome_mime_type_or_default(_arg0,_arg1);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gnome_mime_program(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_mime_program",&_arg0)) 
        return NULL;
    _result = (char *)gnome_mime_program(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gnome_mime_description(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_mime_description",&_arg0)) 
        return NULL;
    _result = (char *)gnome_mime_description(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gnome_mime_nametemplate(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_mime_nametemplate",&_arg0)) 
        return NULL;
    _result = (char *)gnome_mime_nametemplate(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gnome_mime_test(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_mime_test",&_arg0)) 
        return NULL;
    _result = (char *)gnome_mime_test(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gnome_mime_composetyped(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_mime_composetyped",&_arg0)) 
        return NULL;
    _result = (char *)gnome_mime_composetyped(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gnome_mime_copiousoutput(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_mime_copiousoutput",&_arg0)) 
        return NULL;
    _result = (int )gnome_mime_copiousoutput(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_mime_needsterminal(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_mime_needsterminal",&_arg0)) 
        return NULL;
    _result = (int )gnome_mime_needsterminal(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_score_init(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_score_init",&_arg0)) 
        return NULL;
    _result = (int )gnome_score_init(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gnome_triggers_init(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":gnome_triggers_init")) 
        return NULL;
    gnome_triggers_init();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gnome_triggers_readfile(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gnome_triggers_readfile",&_arg0)) 
        return NULL;
    _result = (int )gnome_triggers_readfile(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyMethodDef _gnomeMethods[] = {
	 { "gnome_triggers_do", gnome__triggers_do, 1 },
	 { "gnome_triggers_add_trigger", gnome__triggers_add_trigger, 1 },
	 { "gnome_triggers_readfile", _wrap_gnome_triggers_readfile, 1 },
	 { "gnome_triggers_init", _wrap_gnome_triggers_init, 1 },
	 { "gnome_score_get_notable", gnome__score_get_notable, 1 },
	 { "gnome_score_log", gnome__score_log, 1 },
	 { "gnome_score_init", _wrap_gnome_score_init, 1 },
	 { "gnome_mime_needsterminal", _wrap_gnome_mime_needsterminal, 1 },
	 { "gnome_mime_copiousoutput", _wrap_gnome_mime_copiousoutput, 1 },
	 { "gnome_mime_composetyped", _wrap_gnome_mime_composetyped, 1 },
	 { "gnome_mime_test", _wrap_gnome_mime_test, 1 },
	 { "gnome_mime_nametemplate", _wrap_gnome_mime_nametemplate, 1 },
	 { "gnome_mime_description", _wrap_gnome_mime_description, 1 },
	 { "gnome_mime_program", _wrap_gnome_mime_program, 1 },
	 { "gnome_mime_type_or_default", _wrap_gnome_mime_type_or_default, 1 },
	 { "gnome_mime_type", _wrap_gnome_mime_type, 1 },
	 { "gnome_metadata_type_remove", gnome__metadata_type_remove, 1 },
	 { "gnome_metadata_type_add", gnome__metadata_type_add, 1 },
	 { "gnome_metadata_regex_remove", gnome__metadata_regex_remove, 1 },
	 { "gnome_metadata_regex_add", gnome__metadata_regex_add, 1 },
	 { "gnome_metadata_delete", gnome__metadata_delete, 1 },
	 { "gnome_metadata_copy", gnome__metadata_copy, 1 },
	 { "gnome_metadata_rename", gnome__metadata_rename, 1 },
	 { "gnome_metadata_get_fast", gnome__metadata_get_fast, 1 },
	 { "gnome_metadata_get", gnome__metadata_get, 1 },
	 { "gnome_metadata_list", gnome__metadata_list, 1 },
	 { "gnome_metadata_remove", gnome__metadata_remove, 1 },
	 { "gnome_metadata_set", gnome__metadata_set, 1 },
	 { "gnome_history_get_recently_used", gnome__history_get_recently_used, 1 },
	 { "gnome_history_recently_used", _wrap_gnome_history_recently_used, 1 },
	 { "gnome_help_goto", gnome__help_goto, 1 },
	 { "gnome_help_display", gnome__help_display, 1 },
	 { "gnome_help_file_find_file", gnome__help_file_find_file, 1 },
	 { "gnome_help_file_path", gnome__help_file_path, 1 },
	 { "gnome_file_convert", gnome__file_convert, 1 },
	 { "gnome_file_convert_stream", gnome_file_convert_stream, 1 },
	 { "gnome_config_pop_prefix", _wrap_gnome_config_pop_prefix, 1 },
	 { "gnome_config_push_prefix", _wrap_gnome_config_push_prefix, 1 },
	 { "gnome_config_private_clean_key", _wrap_gnome_config_private_clean_key, 1 },
	 { "gnome_config_clean_key", _wrap_gnome_config_clean_key, 1 },
	 { "gnome_config_private_clean_section", _wrap_gnome_config_private_clean_section, 1 },
	 { "gnome_config_clean_section", _wrap_gnome_config_clean_section, 1 },
	 { "gnome_config_private_clean_file", _wrap_gnome_config_private_clean_file, 1 },
	 { "gnome_config_clean_file", _wrap_gnome_config_clean_file, 1 },
	 { "gnome_config_sync", _wrap_gnome_config_sync, 1 },
	 { "gnome_config_drop_all", _wrap_gnome_config_drop_all, 1 },
	 { "gnome_config_private_enum_sections", gnome_config_private_enum_sections, 1 },
	 { "gnome_config_private_section_contents", gnome_config_private_section_contents, 1 },
	 { "gnome_config_enum_sections", gnome_config_enum_sections, 1 },
	 { "gnome_config_section_contents", gnome_config_section_contents, 1 },
	 { "gnome_config_private_has_section", _wrap_gnome_config_private_has_section, 1 },
	 { "gnome_config_has_section", _wrap_gnome_config_has_section, 1 },
	 { "gnome_config_private_set_vector", gnome__config_private_set_vector, 1 },
	 { "gnome_config_set_vector", gnome__config_set_vector, 1 },
	 { "gnome_config_private_set_bool", _wrap_gnome_config_private_set_bool, 1 },
	 { "gnome_config_private_set_float", _wrap_gnome_config_private_set_float, 1 },
	 { "gnome_config_private_set_int", _wrap_gnome_config_private_set_int, 1 },
	 { "gnome_config_private_set_translated_string", _wrap_gnome_config_private_set_translated_string, 1 },
	 { "gnome_config_private_set_string", _wrap_gnome_config_private_set_string, 1 },
	 { "gnome_config_set_bool", _wrap_gnome_config_set_bool, 1 },
	 { "gnome_config_set_float", _wrap_gnome_config_set_float, 1 },
	 { "gnome_config_set_int", _wrap_gnome_config_set_int, 1 },
	 { "gnome_config_set_translated_string", _wrap_gnome_config_set_translated_string, 1 },
	 { "gnome_config_set_string", _wrap_gnome_config_set_string, 1 },
	 { "gnome_config_private_get_vector", gnome__config_private_get_vector, 1 },
	 { "gnome_config_get_vector", gnome__config_get_vector, 1 },
	 { "gnome_config_private_get_bool", _wrap_gnome_config_private_get_bool, 1 },
	 { "gnome_config_private_get_float", _wrap_gnome_config_private_get_float, 1 },
	 { "gnome_config_private_get_int", _wrap_gnome_config_private_get_int, 1 },
	 { "gnome_config_private_get_translated_string", _wrap_gnome_config_private_get_translated_string, 1 },
	 { "gnome_config_private_get_string", _wrap_gnome_config_private_get_string, 1 },
	 { "gnome_config_get_bool", _wrap_gnome_config_get_bool, 1 },
	 { "gnome_config_get_float", _wrap_gnome_config_get_float, 1 },
	 { "gnome_config_get_int", _wrap_gnome_config_get_int, 1 },
	 { "gnome_config_get_translated_string", _wrap_gnome_config_get_translated_string, 1 },
	 { "gnome_config_get_string", _wrap_gnome_config_get_string, 1 },
	 { "gnomelib_init", _wrap_gnomelib_init, 1 },
	 { NULL, NULL }
};
static PyObject *SWIG_globals;
#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT(void,init_gnome)() {
	 PyObject *m, *d;
	 SWIG_globals = SWIG_newvarlink();
	 m = Py_InitModule("_gnome", _gnomeMethods);
	 d = PyModule_GetDict(m);
/*
 * These are the pointer type-equivalency mappings. 
 * (Used by the SWIG pointer type-checker).
 */
	 SWIG_RegisterMapping("_signed_long","_long",0);
	 SWIG_RegisterMapping("_long","_unsigned_long",0);
	 SWIG_RegisterMapping("_long","_signed_long",0);
	 SWIG_RegisterMapping("_unsigned_long","_long",0);
	 SWIG_RegisterMapping("_signed_int","_int",0);
	 SWIG_RegisterMapping("_unsigned_short","_short",0);
	 SWIG_RegisterMapping("_signed_short","_short",0);
	 SWIG_RegisterMapping("_unsigned_int","_int",0);
	 SWIG_RegisterMapping("_short","_unsigned_short",0);
	 SWIG_RegisterMapping("_short","_signed_short",0);
	 SWIG_RegisterMapping("_int","_unsigned_int",0);
	 SWIG_RegisterMapping("_int","_signed_int",0);
}
