APP_POS_TOP      = 0
APP_POS_BOTTOM   = 1
APP_POS_LEFT     = 2
APP_POS_RIGHT    = 3
APP_POS_FLOATING = 4

# the GnomeUIInfo related stuff
APP_UI_ENDOFINFO     = 0
APP_UI_ITEM          = 1
APP_UI_TOGGLEITEM    = 2
APP_UI_RADIOITEMS    = 3
APP_UI_SUBTREE       = 4
APP_UI_SEPARATOR     = 5
APP_UI_HELP          = 6
APP_UI_JUSTIFY_RIGHT = 7

APP_PIXMAP_NONE     = 0
APP_PIXMAP_STOCK    = 1
#APP_PIXMAP_DATA     = 2 # not supported by pygnome
APP_PIXMAP_FILENAME = 3

UIINFO_END       = (APP_UI_ENDOFINFO, None, None, None,
		    APP_PIXMAP_NONE, None, '\0', 0)
UIINFO_SEPARATOR = (APP_UI_SEPARATOR, None, None, None,
		    APP_PIXMAP_NONE, None, '\0', 0)
UIINFO_JUSTIFY_RIGHT = (APP_UI_JUSTIFY_RIGHT, None, None, None,
			APP_PIXMAP_NONE, None, '\0', 0)
def UIINFO_ITEM(label, tip=None, cb=None, image=None):
	if image:
		return (APP_UI_ITEM, label, tip, cb,
			APP_PIXMAP_FILENAME, image, '\0', 0)
	else:
		return (APP_UI_ITEM, label, tip, cb,
			APP_PIXMAP_NONE, None, '\0', 0)
def UIINFO_ITEM_STOCK(label, tip=None, cb=None, stock=None):
	return (APP_UI_ITEM, label, tip, cb,
		APP_PIXMAP_STOCK, stock, '\0', 0)
	
def UIINFO_TOGGLEITEM(label, tip=None, cb=None, image=None):
	if image:
		return (APP_UI_TOGGLEITEM, label, tip, cb,
			APP_PIXMAP_FILENAME, image, '\0', 0)
	else:
		return (APP_UI_TOGGLEITEM, label, tip, cb,
			APP_PIXMAP_NONE, None, '\0', 0)
def UIINFO_HELP(name):
	return (APP_UI_HELP, None, None, name,
		APP_PIXMAP_NONE, None, '\0', 0)
def UIINFO_SUBTREE(label, tree):
	return (APP_UI_SUBTREE, label, None, tree,
		APP_PIXMAP_NONE, None, '\0', 0)
def UIINFO_RADIOLIST(list):
	return (APP_UI_RADIOITEMS, None, None, list,
		APP_PIXMAP_NONE, None, '\0', 0)
def UIINFO_RADIOITEM(label, tip=None, cb=None, image=None):
	print "Deprecated -- just use UIINFO_ITEM for radio list items"
	if image:
		return (APP_UI_ITEM, label, tip, cb,
			APP_PIXMAP_FILENAME, image, '\0', 0)
	else:
		return (APP_UI_ITEM, label, tip, cb,
			APP_PIXMAP_NONE, None, '\0', 0)

INTERACT_NONE   = 0
INTERACT_ERRORS = 1
INTERACT_ANY    = 2
DIALOG_ERROR  = 0
DIALOG_NORMAL = 1
SAVE_GLOBAL = 0
SAVE_LOCAL  = 1
SAVE_BOTH   = 2
RESTART_IF_RUNNING  = 0
RESTART_ANYWAY      = 1
RESTART_IMMEDIATELY = 2
RESTART_NEVER       = 3
CLIENT_IDLE    = 0
CLIENT_SAVING  = 1
CLIENT_WAITING = 2

ICON_LIST_ICONS      = 0
ICON_LIST_TEXT_BELOW = 1
ICON_LIST_TEXT_RIGHT = 2

MESSAGE_BOX_INFO     = "info"
MESSAGE_BOX_WARNING  = "warning"
MESSAGE_BOX_ERROR    = "error"
MESSAGE_BOX_QUESTION = "question"
MESSAGE_BOX_GENERIC  = "generic"

STOCK_PIXMAP_NEW         = "New"
STOCK_PIXMAP_OPEN        = "Open"
STOCK_PIXMAP_CLOSE       = "Close"
STOCK_PIXMAP_REVERT      = "Revert"
STOCK_PIXMAP_SAVE        = "Save"
STOCK_PIXMAP_SAVE_AS     = "Save As"
STOCK_PIXMAP_CUT         = "Cut"
STOCK_PIXMAP_COPY        = "Copy"
STOCK_PIXMAP_PASTE       = "Paste"
STOCK_PIXMAP_PROPERTIES  = "Properties"
STOCK_PIXMAP_PREFERENCES = "Preferences"
STOCK_PIXMAP_HELP        = "Help"
STOCK_PIXMAP_SCORES      = "Scores"
STOCK_PIXMAP_PRINT       = "Print"
STOCK_PIXMAP_SEARCH      = "Search"
STOCK_PIXMAP_SRCHRPL     = "Search/Replace"
STOCK_PIXMAP_BACK        = "Back"
STOCK_PIXMAP_FORWARD     = "Forward"
STOCK_PIXMAP_FIRST       = "First"
STOCK_PIXMAP_LAST        = "Last"
STOCK_PIXMAP_HOME        = "Home"
STOCK_PIXMAP_STOP        = "Stop"
STOCK_PIXMAP_REFRESH     = "Refresh"
STOCK_PIXMAP_UNDO        = "Undo"
STOCK_PIXMAP_REDO        = "Redo"
STOCK_PIXMAP_TIMER       = "Timer"
STOCK_PIXMAP_TIMER_STOP  = "Timer Stopped"
STOCK_PIXMAP_MAIL        = "Mail"
STOCK_PIXMAP_MAIL_RCV    = "Receive Mail"
STOCK_PIXMAP_MAIL_SND    = "Send Mail"
STOCK_PIXMAP_MAIL_RPL    = "Reply to Mail"
STOCK_PIXMAP_MAIL_FWD    = "Forward Mail"
STOCK_PIXMAP_MAIL_NEW    = "New Mail"
STOCK_PIXMAP_TRASH       = "Trash"
STOCK_PIXMAP_TRASH_FULL  = "Trash Full"
STOCK_PIXMAP_UNDELETE    = "Undelete"
STOCK_PIXMAP_SPELLCHECK  = "Spellchecker"
STOCK_PIXMAP_MIC         = "Microphone"
STOCK_PIXMAP_LINE_IN     = "Line In"
STOCK_PIXMAP_VOLUME      = "Volume"
STOCK_PIXMAP_BOOK_RED    = "Book Red"
STOCK_PIXMAP_BOOK_GREEN  = "Book Green"
STOCK_PIXMAP_BOOK_BLUE   = "Book Blue"
STOCK_PIXMAP_BOOK_YELLOW = "Book Yellow"
STOCK_PIXMAP_BOOK_OPEN   = "Book Open"
STOCK_PIXMAP_ABOUT       = "About"
STOCK_PIXMAP_QUIT        = "Quit"
STOCK_PIXMAP_MULTIPLE    = "Multiple"
STOCK_PIXMAP_NOT         = "Not"
STOCK_PIXMAP_CONVERT     = "Convert"
STOCK_PIXMAP_JUMP_TO     = "Jump To"

STOCK_PIXMAP_EXIT        = STOCK_PIXMAP_QUIT

STOCK_PIXMAP_REGULAR  = "regular"
STOCK_PIXMAP_DISABLED = "disabled"
STOCK_PIXMAP_FOCUSED  = "focused"

STOCK_BUTTON_OK       = "Button_Ok"
STOCK_BUTTON_CANCEL   = "Button_Cancel"
STOCK_BUTTON_YES      = "Button_Yes"
STOCK_BUTTON_NO       = "Button_No"
STOCK_BUTTON_CLOSE    = "Button_Close"
STOCK_BUTTON_APPLY    = "Button_Apply"
STOCK_BUTTON_HELP     = "Button_Help"
STOCK_BUTTON_NEXT     = "Button_Next"
STOCK_BUTTON_PREV     = "Button_Prev"

STOCK_MENU_BLANK      = "Menu_"
STOCK_MENU_NEW        = "Menu_New"
STOCK_MENU_SAVE       = "Menu_Save"
STOCK_MENU_SAVE_AS    = "Menu_Save As"
STOCK_MENU_REVERT     = "Menu_Revert"
STOCK_MENU_OPEN       = "Menu_Open"
STOCK_MENU_CLOSE      = "Menu_Close"
STOCK_MENU_QUIT       = "Menu_Quit"
STOCK_MENU_CUT        = "Menu_Cut"
STOCK_MENU_COPY       = "Menu_Copy"
STOCK_MENU_PASTE      = "Menu_Paste"
STOCK_MENU_PROP       = "Menu_Properties"
STOCK_MENU_PREF       = "Menu_Preferences"
STOCK_MENU_ABOUT      = "Menu_About"
STOCK_MENU_SCORES     = "Menu_Scores"
STOCK_MENU_UNDO       = "Menu_Undo"
STOCK_MENU_REDO       = "Menu_Redo"
STOCK_MENU_PRINT      = "Menu_Print"
STOCK_MENU_SEARCH     = "Menu_Search"
STOCK_MENU_SRCHRPL    = "Menu_Search/Replace"
STOCK_MENU_BACK       = "Menu_Back"
STOCK_MENU_FORWARD    = "Menu_Forward"
STOCK_MENU_FIRST      = "Menu_First"
STOCK_MENU_LAST       = "Menu_Last"
STOCK_MENU_HOME       = "Menu_Home"
STOCK_MENU_STOP       = "Menu_Stop"
STOCK_MENU_REFRESH    = "Menu_Refresh"
STOCK_MENU_MAIL       = "Menu_Mail"
STOCK_MENU_MAIL_RCV   = "Menu_Receive Mail"
STOCK_MENU_MAIL_SND   = "Menu_Send Mail"
STOCK_MENU_MAIL_RPL   = "Menu_Reply to Mail"
STOCK_MENU_MAIL_FWD   = "Menu_Forward Mail"
STOCK_MENU_MAIL_NEW   = "Menu_New Mail"
STOCK_MENU_TRASH      = "Menu_Trash"
STOCK_MENU_TRASH_FULL = "Menu_Trash Full"
STOCK_MENU_UNDELETE   = "Menu_Undelete"
STOCK_MENU_TIMER      = "Menu_Timer"
STOCK_MENU_TIMER_STOP = "Menu_Timer Stopped"
STOCK_MENU_SPELLCHECK = "Menu_Spellchecker"
STOCK_MENU_MIC        = "Menu_Microphone"
STOCK_MENU_LINE_IN    = "Menu_Line In"
STOCK_MENU_VOLUME     = "Menu_Volume"
STOCK_MENU_BOOK_RED   = "Menu_Book Red"
STOCK_MENU_BOOK_GREEN = "Menu_Book Green"
STOCK_MENU_BOOK_BLUE  = "Menu_Book Blue"
STOCK_MENU_BOOK_YELLOW= "Menu_Book Yellow"
STOCK_MENU_BOOK_OPEN  = "Menu_Book Open"
STOCK_MENU_CONVERT    = "Menu_Convert"
STOCK_MENU_JUMP_TO    = "Menu_Jump To"

STOCK_MENU_EXIT     = STOCK_MENU_QUIT

PAD       = 8
PAD_SMALL = 4
PAD_BIG   = 12

CALENDAR_SHOW_HEADING    = 1
CALENDAR_SHOW_DAY_NAMES  = 2
CALENDAR_NO_MONTH_CHANGE = 4

CALENDAR_FONT_HEADING  = 0
CALENDAR_FONT_DAY_NAME = 1
CALENDAR_FONT_DAY      = 2

CALENDAR_COLOR_HEADING    = 0
CALENDAR_COLOR_DAY_NAME   = 1
CALENDAR_COLOR_PREV_MONTH = 2
CALENDAR_COLOR_NEXT_MONTH = 3
CALENDAR_COLOR_NORMAL_DAY = 4

CLOCK_INCREASING = 0
CLOCK_DECREASING = 1
CLOCK_REALTIME   = 2

YES = 0
NO = 1
OK = 0
CANCEL = 1

LAMP_CLEAR  = 'C'
LAMP_RED    = 'R'
LAMP_GREEN  = 'G'
LAMP_BLUE   = 'B'
LAMP_YELLOW = 'Y'
LAMP_AQUA   = 'A'
LAMP_PURPLE = 'P'

LAMP_IDLE     = "idle"
LAMP_BUSY     = "busy"
LAMP_INPUT    = "input"
LAMP_WARNING  = "warning"
LAMP_ERROR    = "error"
LAMP_PROC0    = "proc00"
LAMP_PROC10   = "proc10"
LAMP_PROC20   = "proc20"
LAMP_PROC30   = "proc30"
LAMP_PROC40   = "proc40"
LAMP_PROC50   = "proc50"
LAMP_PROC60   = "proc60"
LAMP_PROC70   = "proc70"
LAMP_PROC80   = "proc80"
LAMP_PROC90   = "proc90"
LAMP_FINISHED = LAMP_IDLE
LAMP_PROC100  = LAMP_FINISHED

MDI_NOTEBOOK     = 0
MDI_TOPLEVEL     = 1
MDI_MODAL        = 2
MDI_MS           = 3  # I don't think this is implemented yet */
MDI_DEFAULT_MODE = 42
MDI_REDRAW       = -1


PREFERENCES_NEVER  = 0
PREFERENCES_USER   = 1
PREFERENCES_ALWAYS = 2

CAULDRON_ENTER = "GTK_CAULDRON_ENTER"
CAULDRON_ESCAPE = "GTK_CAULDRON_ESCAPE"

CAULDRON_TOPLEVEL     = 1 << 0
CAULDRON_DIALOG       = 1 << 1
CAULDRON_POPUP        = 1 << 2
CAULDRON_SPACE1       = 1 << 3
CAULDRON_SPACE2       = 2 << 3
CAULDRON_SPACE3       = 3 << 3
CAULDRON_SPACE4       = 4 << 3
CAULDRON_SPACE5       = 5 << 3
CAULDRON_SPACE6       = 6 << 3
CAULDRON_SPACE7       = 7 << 3
CAULDRON_SPACE8       = 8 << 3
CAULDRON_SPACE9       = 9 << 3
CAULDRON_SPACE10      = 10 << 3
CAULDRON_SPACE11      = 11 << 3
CAULDRON_SPACE12      = 12 << 3
CAULDRON_SPACE13      = 13 << 3
CAULDRON_SPACE14      = 14 << 3
CAULDRON_SPACE15      = 15 << 3
CAULDRON_IGNOREESCAPE = 1 << 6
CAULDRON_IGNOREENTER  = 1 << 7
CAULDRON_GRAB         = 1 << 8
