%module _zvt

%{
#include <zvt/zvtterm.h>
%}
%include "glue.i"

%typemap(python,in) ZvtTerm * {
  if (PyGtk_Check($source))
    $target = ZVT_TERM(PyGtk_Get($source));
  else {
    PyErr_SetString(PyExc_TypeError, "noe a GtkObject");
    return NULL;
  }
}
%typemap(python,out) ZvtTerm * {
  $target = PyGtk_New((GtkObject *)$source);
}

void pygtk_init();

int zvt_term_get_type();
GtkWidget *zvt_term_new();
int zvt_term_forkpty(ZvtTerm *term);
int zvt_term_closepty(ZvtTerm *term);
int zvt_term_killchild(ZvtTerm *term, int signal);
void zvt_term_set_scrollback(ZvtTerm *term, int lines);
void zvt_term_set_font_name(ZvtTerm *term, char *name);
void zvt_term_set_fonts(ZvtTerm *term, GdkFont *font, GdkFont *font_bold);
void zvt_term_hide_pointer(ZvtTerm *term);
void zvt_term_show_pointer(ZvtTerm *term);
void zvt_term_set_blink(ZvtTerm *term, int state);
//void zvt_term_set_color_scheme
void zvt_term_set_default_color_scheme(ZvtTerm *term);
