""" NewBuiltins - Provides and installs extra functions from the C
                  extension package mxTools as builtins.

    (c) Copyright Marc-Andre Lemburg; All Rights Reserved.
    See the documentation for further information on copyrights,
    or contact the author (mal@lemburg.com).
"""
__package_info__ = """
BEGIN PYTHON-PACKAGE-INFO 1.0
Current-Version:	0.8
Title:          	mxTools - A collection of new builtins for Python
Home-page:      	http://starship.skyport.net/crew/lemburg/mxTools.html
Primary-site:		http://startship.skyport.net/crew/lemburg/mxTools-0.8.zip

The package contains a collection of useful functions that aid in
common tasks like iterating over objects or applying functions to
sets of parameters. The functions contained in the package auto-install
themselves as builtins when the package is imported.

You should visit the home page every now and then for updates, since
the package will eventually evolve with time.

END PYTHON-PACKAGE-INFO
"""
from mxTools.mxTools import *
from mxTools.mxTools import __version__
from mxTools.xmap import *

def make_builtin(dict):
    """ Install all functions / objects defined in dict as builtins.
        Doesn't overwrite anything already defined in the builtins.
    """
    for k,v in dict.items():
	if k[:2] != '__' and not __builtins__.has_key(k):
	    __builtins__[k] = v

### Comment this out, if you don't want the package to autoinstall
### the functions as builtins.
make_builtin(globals()); del make_builtin

