/* $Id: fillscreen.c,v 1.9 1998/09/26 03:20:43 marcus Exp $
***************************************************************************

   Graphics library for GGI.

   Copyright (C) 1995 Andreas Beck     [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <string.h>

#include "lin4lib.h"

/*************************************/
/* fill (erase) the (virtual) screen */
/*************************************/

int GGI_lin4_fillscreen(ggi_visual *vis)
{
	DPRINT("fillscreen: fb=%p, fg=0x%.2x, width=%d, height=%d\n",
	       LIBGGI_CURWRITE(vis),LIBGGI_GC_FGCOLOR(vis),
	       LIBGGI_VIRTX(vis),LIBGGI_VIRTY(vis));
	memset(LIBGGI_CURWRITE(vis),LIBGGI_GC_FGCOLOR(vis),
				 (LIBGGI_FB_W_STRIDE(vis))*LIBGGI_VIRTY(vis));
	return 0;
}

