/* $Id: box.c,v 1.7 1998/09/23 21:36:00 marcus Exp $
***************************************************************************

   Display-Xlib: copying boxes

   Copyright (C) 1998 Marcus Sundberg    [marcus@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>
#include "Xvisual.h"

int GGI_Xlib_drawbox(ggi_visual *vis, int x, int y, int w, int h)
{
	XFillRectangle(XLIB_PRIV(vis)->display,
				   XLIB_PRIV(vis)->window,
				   XLIB_PRIV(vis)->gc,
				   x, y, w, h);

	XLIB_DOSYNC(vis);
	return 0;
}

int GGI_Xlib_putbox(ggi_visual *vis, int x, int y, int w, int h, void *data)
{
	XImage *ximg;
	
	ximg=XCreateImage(XLIB_PRIV(vis)->display, 
					  DefaultVisual(XLIB_PRIV(vis)->display, 0),
					  LIBGGI_PIXFMT(vis)->size, ZPixmap, 0,
					  data, w, h, 8, 0);
	XPutImage(XLIB_PRIV(vis)->display, 
			  XLIB_PRIV(vis)->window,
			  XLIB_PRIV(vis)->gc,
			  ximg, 0, 0, x, y, w, h);
	XFree(ximg);

	XLIB_DOSYNC(vis);
	return 0;
}

int GGI_Xlib_copybox(ggi_visual *vis, int x, int y, 
			   int w, int h, int nx, int ny)
{
	XCopyArea(XLIB_PRIV(vis)->display, 
			  XLIB_PRIV(vis)->window,
			  XLIB_PRIV(vis)->window,
			  XLIB_PRIV(vis)->gc,
			  x, y, w, h, nx, ny);

	XLIB_DOSYNC(vis);
	return 0;
}

int GGI_Xlib_getbox(ggi_visual *vis, int x, int y, int w, int h, void *data)
{
	XImage *ximg;

	ximg = XGetImage(XLIB_PRIV(vis)->display, XLIB_PRIV(vis)->window, x, y,
			  w, h, AllPlanes, ZPixmap);
	memcpy(data, ximg->data, w*h*LIBGGI_PIXFMT(vis)->size/8);
	XFree(ximg);

	XLIB_DOSYNC(vis);
	return 0;
}
