/* $Id: monotext.h,v 1.10 1998/09/24 01:24:10 marcus Exp $
***************************************************************************

   Display-monotext: graphics emulation on text modes

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#ifndef _DISPLAY_MONOTEXT_H
#define _DISPLAY_MONOTEXT_H

#include <ggi/internal/ggi-dl.h>


/**************************************************
 **
 **  MonoText private defines
 **
 **************************************************/


#ifndef NULL
#define NULL  ((void *) 0L)
#endif

#ifndef MIN
#define MIN(a, b)  ((a) < (b) ? (a) : (b))
#endif

#ifndef MAX
#define MAX(a, b)  ((a) > (b) ? (a) : (b))
#endif

#ifndef ABS
#define ABS(n)  (((n) < 0) ? -(n) : (n))
#endif


#define UPDATE_MOD(mh, xx, yy, w, h)  \
	if ((xx) < mh->dirty_tl.x) mh->dirty_tl.x = (xx);  \
	if ((yy) < mh->dirty_tl.y) mh->dirty_tl.y = (yy);  \
	if ((xx)+(w) > mh->dirty_br.x) mh->dirty_br.x = (xx)+(w);  \
	if ((yy)+(h) > mh->dirty_br.y) mh->dirty_br.y = (yy)+(h);

#define UPDATE_SYNC  \
	do { if (! (LIBGGI_FLAGS(vis) & GGIFLAG_ASYNC))  \
		ggiFlush(vis);  \
	} while (0)


/**************************************************** 
 **
 **  MonoText private data
 **
 ****************************************************/

ggifunc_getmode		GGI_monotext_getmode;
ggifunc_setmode		GGI_monotext_setmode;
ggifunc_checkmode	GGI_monotext_checkmode;
ggifunc_getapi		GGI_monotext_getapi;
ggifunc_flush		GGI_monotext_flush;
ggifunc_setflags	GGI_monotext_setflags;
	
ggifunc_eventpoll	GGI_monotext_eventpoll;
ggifunc_eventread	GGI_monotext_eventread;
ggifunc_seteventmask	GGIseteventmask;

ggifunc_drawpixel	GGI_monotext_drawpixel_nc;
ggifunc_drawpixel	GGI_monotext_drawpixel;
ggifunc_drawhline	GGI_monotext_drawhline_nc;
ggifunc_drawhline	GGI_monotext_drawhline;
ggifunc_drawvline	GGI_monotext_drawvline_nc;
ggifunc_drawvline	GGI_monotext_drawvline;
ggifunc_drawline	GGI_monotext_drawline;

ggifunc_putc		GGI_monotext_putc;
ggifunc_putpixel	GGI_monotext_putpixel_nc;
ggifunc_putpixel	GGI_monotext_putpixel;
ggifunc_puthline	GGI_monotext_puthline;
ggifunc_putvline	GGI_monotext_putvline;
ggifunc_putbox		GGI_monotext_putbox;

ggifunc_drawbox		GGI_monotext_drawbox;
ggifunc_copybox		GGI_monotext_copybox;
ggifunc_crossblit	GGI_monotext_crossblit;
ggifunc_fillscreen	GGI_monotext_fillscreen;

ggifunc_setorigin	GGI_monotext_setorigin;
ggifunc_setpalvec	GGI_monotext_setpalvec;

typedef struct monotext_hook
{
	ggi_visual_t parent;

	int flags;
	int parent_gt;

	ggi_coord size;
	ggi_coord accuracy;
	ggi_coord squish;

	/* framebuffer */

	void *fb_ptr;
	long  fb_size;
	
	/* color info */
	
	uint8 *greymap;
	ggi_color *colormap;

	uint8 *rgb_to_grey;	/* index = RGB 5:5:5 */

	ggi_float red_gamma;
	ggi_float green_gamma;
	ggi_float blue_gamma;

	/* 2D operations on memory buffer */

	struct ggi_visual_opdraw *mem_opdraw;

	ggi_coord dirty_tl;
	ggi_coord dirty_br;
	
	/* blitter function */

	void (* do_blit) (struct monotext_hook *mt, void *dest, 
			  void *src, int w);

} MonotextHook;


/****************************************************
 **
 **  MonoText private functions
 **
 ****************************************************/
 
  
extern int _ggi_monotextOpen(ggi_visual *vis);
extern int _ggi_monotextClose(ggi_visual *vis);
extern int _ggi_monotextUpdate(ggi_visual*vis, int x, int y, int w, int h);
extern int _ggi_monotextFlush(ggi_visual*vis);
 

#endif  /* _DISPLAY_MONOTEXT_H */
