/* 
   Graphics library for GGI. CRT specifics

   Copyright (C) 1998 Andreas Beck - becka@ggi-project.org

   If you do any modifications, I would like you to send diffs to me
   to allow for collecting a more and more complete set of drivers and
   to improve existing ones.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>

#include <ggi/internal/ggi-dl.h>
#include "../../misc.h"
#include "../display/X/Xvisual.h"

int GGIwaitraypos(ggi_visual *vis,sint32 *x,sint32 *y)
{
	*x = GGI_RP_DONTCARE;
	*y = GGI_RP_DONTCARE;

	return 1;
}

int GGIsetsplitline(ggi_visual *vis,int y)
{
	struct Xhooks *xhook;
	DPRINT("GOTCHA ! X setting splitline %d !\n",y);

	if (y<0 || y>LIBGGI_MODE(vis)->visible.y) return -1;

	xhook=LIBGGI_PRIVATE(vis);

	if ( xhook->yoff > LIBGGI_MODE(vis)->virt.y-y )
		xhook->yoff = LIBGGI_MODE(vis)->virt.y-y;

	xhook->ysplit=y;

	ggiFlush(vis);

	return 0;
}
