/* 
 *  pixel drawing
 *
 *  Copyright (C) 1998 Thomas Tanner. See CREDITS for details.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "lib.h"
#include "util.h"

/*----------------------------------------------------------------------*/

#define	PUTPIXEL(OP,EXPR) \
		case GGI2D_ ## OP: *ptr = EXPR; break;

static void	putPixel_NOOP(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_pixel color)
{
}

static void	putPixel_INVERT(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_pixel color)
{
	if (!CLIP(vis, x, y)) {
		pixel	*ptr = LFBADDR(vis, x, y);
		*ptr	= ~*ptr;
	}
}

static void	putPixel_SET(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_pixel color)
{
	if (CLIP(vis, x, y)) {
		pixel	*ptr = LFBADDR(vis, x, y);
		*ptr	= color;
	}
}

static void	putPixel_XOR(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_pixel color)
{
	if (CLIP(vis, x, y)) {
		pixel	*ptr = LFBADDR(vis, x, y);
		*ptr	^= color;
	}
}

static void	putPixel_GENERIC(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_pixel color)
{
	if (CLIP(vis, x, y)) {
		pixel	*ptr = LFBADDR(vis, x, y);
		switch (GGI2D_GC_OP(vis)) {
		case GGI2D_NOOP:
		case GGI2D_INVERT:
		case GGI2D_SET:
		PUTPIXEL(SET_INVERTED, ~color )
		PUTPIXEL(AND, *ptr & color )
		PUTPIXEL(NAND, ~(*ptr & color) )
		PUTPIXEL(AND_REVERSE, ~*ptr & color )
		PUTPIXEL(AND_INVERTED, *ptr & ~color )
		PUTPIXEL(OR, *ptr | color )
		PUTPIXEL(NOR, ~(*ptr | color) )
		PUTPIXEL(OR_REVERSE, ~*ptr | color )
		PUTPIXEL(OR_INVERTED, *ptr | ~color )
		case GGI2D_XOR:
		PUTPIXEL(EQUIV, ~(*ptr ^ color) )
		PUTPIXEL(ADD, *ptr + color )
		PUTPIXEL(SUB, *ptr - color )
		}
	}
}

void	(*GGIEXP(putPixel)[16])(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_pixel color) =
{
    putPixel_NOOP,
    putPixel_INVERT,
    putPixel_SET,
    putPixel_GENERIC,
    putPixel_GENERIC,
    putPixel_GENERIC,
    putPixel_GENERIC,
    putPixel_GENERIC,
    putPixel_GENERIC,
    putPixel_GENERIC,
    putPixel_GENERIC,
    putPixel_GENERIC,
    putPixel_XOR,
    putPixel_GENERIC,
    putPixel_GENERIC,
    putPixel_GENERIC
};

/*----------------------------------------------------------------------*/

static void	drawPixel_NOOP(ggi_visual_t vis, ggi_sint x, ggi_sint y)
{
}

static void	drawPixel_INVERT(ggi_visual_t vis, ggi_sint x, ggi_sint y)
{
	if (CLIP(vis, x, y)) {
		pixel	*ptr = LFBADDR(vis, x, y);
		*ptr	= ~*ptr;
	}
}

static void	drawPixel_SET(ggi_visual_t vis, ggi_sint x, ggi_sint y)
{
	if (CLIP(vis, x, y)) {
		pixel	*ptr = LFBADDR(vis, x, y);
		*ptr  = GGI2D_GC_DRAWCOL(vis);
	}
}

static void	drawPixel_XOR(ggi_visual_t vis, ggi_sint x, ggi_sint y)
{
	if (CLIP(vis, x, y)) {
		pixel	*ptr = LFBADDR(vis, x, y);
		*ptr	^= GGI2D_GC_DRAWCOL(vis);
	}
}

static void	drawPixel_GENERIC(ggi_visual_t vis, ggi_sint x, ggi_sint y)
{
	if (CLIP(vis, x, y)) {
		pixel	*ptr = LFBADDR(vis, x, y);
		pixel	color = GGI2D_GC_DRAWCOL(vis);
		switch (GGI2D_GC_OP(vis)) {
		case GGI2D_NOOP:
		case GGI2D_INVERT:
		case GGI2D_SET:
		PUTPIXEL(SET_INVERTED, ~color )
		PUTPIXEL(AND, *ptr & color )
		PUTPIXEL(NAND, ~(*ptr & color) )
		PUTPIXEL(AND_REVERSE, ~*ptr & color )
		PUTPIXEL(AND_INVERTED, *ptr & ~color )
		PUTPIXEL(OR, *ptr | color )
		PUTPIXEL(NOR, ~(*ptr | color) )
		PUTPIXEL(OR_REVERSE, ~*ptr | color )
		PUTPIXEL(OR_INVERTED, *ptr | ~color )
		case GGI2D_XOR:
		PUTPIXEL(EQUIV, ~(*ptr ^ color) )
		PUTPIXEL(ADD, *ptr + color )
		PUTPIXEL(SUB, *ptr - color )
		}
	}
}

void	(*GGIEXP(drawPixel)[16])(ggi_visual_t vis, ggi_sint x, ggi_sint y) =
{
    drawPixel_NOOP,
    drawPixel_INVERT,
    drawPixel_SET,
    drawPixel_GENERIC,
    drawPixel_GENERIC,
    drawPixel_GENERIC,
    drawPixel_GENERIC,
    drawPixel_GENERIC,
    drawPixel_GENERIC,
    drawPixel_GENERIC,
    drawPixel_GENERIC,
    drawPixel_GENERIC,
    drawPixel_XOR,
    drawPixel_GENERIC,
    drawPixel_GENERIC,
    drawPixel_GENERIC
};

/*----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*/

void	GGIEXP(fillPixel)(ggi_visual_t vis, ggi_sint x, ggi_sint y)
{
	if (CLIP(vis, x, y)) {
		pixel	color = GGI2D_GC_FILLCOL(vis);
		pixel	*ptr = LFBADDR(vis, x, y);
		switch (GGI2D_GC_OP(vis)) {
		case GGI2D_NOOP:	break;
		PUTPIXEL(INVERT, ~*ptr )
		PUTPIXEL(SET, color )
		PUTPIXEL(SET_INVERTED, ~color )
		PUTPIXEL(AND, *ptr & color )
		PUTPIXEL(NAND, ~(*ptr & color) )
		PUTPIXEL(AND_REVERSE, ~*ptr & color )
		PUTPIXEL(AND_INVERTED, *ptr & ~color )
		PUTPIXEL(OR, *ptr | color )
		PUTPIXEL(NOR, ~(*ptr | color) )
		PUTPIXEL(OR_REVERSE, ~*ptr | color )
		PUTPIXEL(OR_INVERTED, *ptr | ~color )
		PUTPIXEL(XOR, *ptr ^ color )
		PUTPIXEL(EQUIV, ~(*ptr ^ color) )
		PUTPIXEL(ADD, *ptr + color )
		PUTPIXEL(SUB, *ptr - color )
		}
	}
}

/*----------------------------------------------------------------------*/

