/*
  !!! WARNING: This file is for libggi 1.4 compatibility
*/

/* 
 *  Library initialization
 *
 *  Copyright (C) 1998 Thomas Tanner
 *                1998 Jon Taylor
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "internal3d.h"

/*
 * Initalize the structures for the library
 */
static int 	_ggi3dLibIsUp=0;

int ggi3dDebugState=0;

ggi_extid ggi3dID=-1;

static int changed(ggi_visual_t vis,int whatchanged)
{
	int temp;
	ggi_dlhandle *lib;
	char api[256],args[256];
	
	printf("changed() called for libggi3d - vis=%p, %i \n",
		vis,whatchanged);

	switch(whatchanged) 
	{
	case GGI_CHG_APILIST:	
		
		printf("changed() APILIST \n");
		for(temp=0;0==ggiGetAPI(vis,temp,api,args);temp++) {
			strcat(api,"-3d");
                	printf("Trying #%d: %s(%s)\n",temp,api,args);
			lib=_ggiAddDL(vis,api,args,GGI_DLTYPE_EXTENSION);
                	printf("Loaded #%d: %s(%s) : %p\n",temp,api,args,lib);
		}
		break;
	}
                                
	return 0;
}

int ggi3DInit(void)
{
	char *str;
    
	_ggi3dLibIsUp++;
	if (_ggi3dLibIsUp!=1) return 0;	/* Initialize only at first call. */

	str=getenv("GGI_DEBUG");
	if (str!=NULL) {
		ggi3dDebugState=atoi(str);
		printf("Debugging=%d\n",ggi3dDebugState);
	}

	ggi3dID=ggiExtensionRegister("GGI3D",sizeof(ggi3d_data),changed);
	printf("Initialized LibGGI3D, ID=%i\n",ggi3dID);

	return ggi3dID >= 0 ? 0 : -1;
}

int ggi3DExit(void)
{
	int rc;
    
	if (!_ggi3dLibIsUp)
		return -1;

	if (_ggi3dLibIsUp > 1) {
		_ggi3dLibIsUp--;
		return 0;	/* Exit only at last call */
	}
	
	rc=ggiExtensionUnregister(ggi3dID);
	printf("Deinitialized LibGGI3D (rc=%i)\n", rc);

	_ggi3dLibIsUp = 0;
	return rc;
}

int ggi3DOpen(ggi_visual_t vis)
{
	int rc;
    
	rc=ggiExtensionAttach(vis,ggi3dID);
	printf("Attached LibGGI3D to %p (rc=%i)\n", vis, rc);

	if (rc==0) {	/* We are actually creating the primary instance. */
		memset(GGI3D_DATA(vis), 0, sizeof(ggi3d_data));
                        
		/* Now fake an "API change" so the right libs get loaded */
		changed(vis,GGI_CHG_APILIST);
		GGI3DInitGC(vis);
        	GGI3DUpdate(vis, GGI3D_UPD_ALL);
	}

	return rc;
}

int ggi3DClose(ggi_visual_t vis)
{
	int rc;
	rc=ggiExtensionDetach(vis,ggi3dID);
	printf("Detached libggi3d from %p. rc=%i\n", vis, rc);

	return rc;
}

/*----------------------------------------------------------------------*/
