case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh
    ;;
esac
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac

case "$d_usenls" in
define)	mcsrc="mcprt.c mcprtlib.c msgcat.c"
	mcobj="mcprt.o mcprtlib.o msgcat.o"
	;;
*)	mcsrc= mcobj= ;;
esac

case "$d_strstr" in
define)	strsrc= strobj= ;;
*)	strsrc="strstr.c"
	strobj="strstr.o"
	;;
esac

case "$d_strftime" in
define)	ftimesrc= ftimeobj= ;;
*)	ftimesrc="strftime.c"
	ftimeobj="strftime.o"
	;;
esac

echo "Extracting lib/Makefile (with variable substitutions)"
cat >Makefile <<!GROK!THIS!
# $Id: Makefile.SH,v 1.2.2.1 1999/05/22 15:16:27 hurtta Exp $
#
#  Makefile for the ELM mail program.
#
#	Copyright (c) 1986,1987 Dave Taylor
#	Copyright (c) 1988-1992 USENET Community Trust
#
#
#
# Variables
#	Variables established by Configure
AR		=	ar
CC		=	$cc
CCFLAGS		=	$ccflags $xencf
CHMOD		=	$chmod
LINT		=	$lint
OPTIMIZE	=	$optimize
RANLIB		=	$ranlib
RM		= 	$rm -f
TOUCH		=	$touch
TAGS		=	ctags

MCSRC		=	$mcsrc
MCOBJ		=	$mcobj

STRSRC		=	$strsrc
STROBJ		=	$strobj

FTIMESRC	=	$ftimesrc
FTIMEOBJ	=	$ftimeobj

!GROK!THIS!

cat >>Makefile <<'!NO!SUBS!'

#	Variables you may want to manually edit
#		If you want debug logging then you'll
#		want to uncomment the following.
#DEBUG		=	-DDEBUG

#		If you're on an ACSnet system (Australia) then
#		you'll want to uncomment the following.
# DACSNET	=	-DACSNET

#	Other general variables
CFLAGS		=	-I$(INCLDIR) $(CCFLAGS) $(OPTIMIZE) $(DEBUG) $(DACSNET) 
INCLDIR		=	../hdrs
LINTFLAGS	=	-I$(INCLDIR)
SHELL		=	/bin/sh

# 	Lists
LIB_SRC		=	add_site.c	\
			addrmchusr.c	\
			atonum.c	\
			mk_aliases.c	\
			aliasdb.c	\
			mk_lockname.c	\
			can_access.c	\
			can_open.c	\
			chloc.c		\
			date_util.c	\
			dispaddr.c	\
			dynarray.c	\
			errno.c		\
			expand.c	\
			forwarded.c     \
			gcos_name.c	\
			getaddr.c	\
			getaddr.c	\
			getaddrfrm.c	\
			getarpdate.c	\
			getfullnam.c	\
			getword.c	\
			get_tz.c	\
			header_cmp.c	\
			in_list.c	\
			in_string.c	\
			istrcmp.c	\
			ldstate.c	\
			len_next.c	\
			mail_gets.c	\
			$(MCSRC)	\
			move_left.c	\
			ndbz.c		\
			okay_addr.c	\
			opt_utils.c	\
			output.c        \
			parsarpdat.c	\
			parsarpwho.c	\
			pmalloc.c	\
			posixsig.c	\
			putenv.c	\
			realfrom.c	\
			qstrings.c	\
			read_rc.c       \
			remfirstwd.c	\
			reverse.c	\
			rfc822tlen.c	\
			safemalloc.c	\
			shiftlower.c	\
			strfcpy.c	\
			strincmp.c	\
			striparens.c	\
			$(STRSRC)	\
			$(FTIMESRC)	\
			strmcpy.c	\
			strtokq.c	\
			tail_of.c	\
			validname.c	\
			safeopen.c

LIB_OBJ		=	add_site.o	\
			addrmchusr.o	\
			atonum.o	\
			mk_aliases.o	\
			aliasdb.o	\
			mk_lockname.o	\
			can_access.o	\
			can_open.o	\
			chloc.o		\
			date_util.o	\
			dispaddr.o	\
			dynarray.o	\
			errno.o		\
			expand.o	\
			forwarded.o     \
			gcos_name.o	\
			get_tz.o	\
			getaddr.o	\
			getaddrfrm.o	\
			getarpdate.o	\
			getfullnam.o	\
			getword.o	\
			header_cmp.o	\
			in_list.o	\
			in_string.o	\
			istrcmp.o	\
			ldstate.o	\
			len_next.o	\
			mail_gets.o	\
			$(MCOBJ)	\
			move_left.o	\
			ndbz.o		\
			okay_addr.o	\
			opt_utils.o	\
			output.o	\
			parsarpdat.o	\
			parsarpwho.o	\
			pmalloc.o	\
			posixsig.o	\
			putenv.o	\
			qstrings.o	\
			read_rc.o	\
			realfrom.o	\
			remfirstwd.o	\
			reverse.o	\
			rfc822tlen.o	\
			safemalloc.o	\
			shiftlower.o	\
			strfcpy.o	\
			strincmp.o	\
			striparens.o	\
			$(STROBJ)	\
			$(FTIMEOBJ)	\
			strmcpy.o	\
			strtokq.o	\
			tail_of.o	\
			validname.o	\
			safeopen.o

all:			Makefile libutil.a

install:		Makefile libutil.a

uninstall:		libutil.a

libutil.a:		$(LIB_OBJ)
			$(AR) r $@ $?
			$(RANLIB) $@

Makefile: Makefile.SH ../config.sh
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

lint:		
		$(LINT) $(LINTFLAGS) $(LIB_SRC) > LINT.OUT

tags:
		$(TAGS) $(LIB_SRC)

clean:		
		$(RM) $(LIB_OBJ) libutil.a

# Dependencies and rules
#	Dependencies of header files upon other header files they include
.PRECIOUS:		$(INCLDIR)/defs.h $(INCLDIR)/elm.h $(INCLDIR)/headers.h

$(INCLDIR)/defs.h:	$(INCLDIR)/../config.h $(INCLDIR)/sysdefs.h
			$(CHMOD) u+w $@
			$(TOUCH) $@

$(INCLDIR)/elm.h:	$(INCLDIR)/curses.h $(INCLDIR)/defs.h $(INCLDIR)/melib.h
			$(CHMOD) u+w $@
			$(TOUCH) $@

$(INCLDIR)/headers.h:	$(INCLDIR)/curses.h $(INCLDIR)/defs.h $(INCLDIR)/elmlib.h $(INCLDIR)/me.h
			$(CHMOD) u+w $@
			$(TOUCH) $@

#	Dependencies of C object files
add_site.o:	$(INCLDIR)/headers.h
addrmchusr.o:	$(INCLDIR)/headers.h
atonum.o:	$(INCLDIR)/headers.h
mk_aliases.o:	$(INCLDIR)/headers.h $(INCLDIR)/ndbz.h $(INCLDIR)/s_newalias.h
aliasdb.o:	$(INCLDIR)/headers.h $(INCLDIR)/ndbz.h
mk_lockname.o:	$(INCLDIR)/headers.h
can_access.o:	$(INCLDIR)/headers.h
can_open.o:	$(INCLDIR)/headers.h
chloc.o:	$(INCLDIR)/headers.h
date_util.o:	$(INCLDIR)/headers.h
dispaddr.o:     $(INCLDIR)/headers.h
errno.o:	$(INCLDIR)/headers.h
expand.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elmrc.h 
forwarded.o:	$(INCLDIR)/headers.h
gcos_name.o:	$(INCLDIR)/headers.h
get_tz.o:	$(INCLDIR)/headers.h
getaddr.o:	$(INCLDIR)/headers.h
getaddrfrm.o:	$(INCLDIR)/headers.h
getarpdate.o:	$(INCLDIR)/headers.h
getfullnam.o:	$(INCLDIR)/headers.h
getword.o:	$(INCLDIR)/headers.h
header_cmp.o:	$(INCLDIR)/headers.h
in_list.o:	$(INCLDIR)/headers.h
in_string.o:	$(INCLDIR)/headers.h
istrcmp.o:	$(INCLDIR)/headers.h
ldstate.o:	$(INCLDIR)/headers.h
len_next.o:	$(INCLDIR)/headers.h
mail_gets.o:	$(INCLDIR)/headers.h
mcprt.o:	$(INCLDIR)/mcprt.h $(INCLDIR)/mcprtlib.h $(INCLDIR)/defs.h
mcprtlib.o:	$(INCLDIR)/mcprtlib.h $(INCLDIR)/defs.h
move_left.o:	$(INCLDIR)/headers.h
msgcat.o:	$(INCLDIR)/msgcat.h $(INCLDIR)/headers.h
ndbz.o:		$(INCLDIR)/headers.h $(INCLDIR)/ndbz.h
okay_addr.o:	$(INCLDIR)/headers.h
opt_utils.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_error.h
output.o:	$(INCLDIR)/headers.h
parsarpdat.o:	$(INCLDIR)/headers.h
parsarpwho.o:	$(INCLDIR)/headers.h
pmalloc.o:	$(INCLDIR)/defs.h $(INCLDIR)/s_elm.h
posixsig.o:	$(INCLDIR)/headers.h
putenv.o:	$(INCLDIR)/headers.h
read_rc.o:      $(INCLDIR)/headers.h $(INCLDIR)/save_opts.h $(INCLDIR)/s_elm.h
realfrom.o:	$(INCLDIR)/headers.h $(INCLDIR)/s_elm.h
qstrings.o:	$(INCLDIR)/headers.h
remfirstwd.o:	$(INCLDIR)/headers.h
reverse.o:	$(INCLDIR)/headers.h
safemalloc.o:	$(INCLDIR)/headers.h
shiftlower.o:	$(INCLDIR)/headers.h
strfcpy.o:      $(INCLDIR)/headers.h
strmcpy.o:      $(INCLDIR)/headers.h
strincmp.o:	$(INCLDIR)/headers.h
striparens.o:	$(INCLDIR)/headers.h
strstr.o:	$(INCLDIR)/headers.h
strtokq.o:	$(INCLDIR)/headers.h
tail_of.o:	$(INCLDIR)/headers.h
validname.o:	$(INCLDIR)/headers.h

!NO!SUBS!
