
static char rcsid[] = "@(#)$Id: lock.c,v 1.6.6.2 1999/09/03 13:08:22 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.6.6.2 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** leave current folder, updating etc. as needed...
  
**/


#include "headers.h"
#include "me.h"
#include "s_elm.h"
#include <sys/stat.h>

#ifdef SYSCALL_LOCKING
#  if (defined(BSD_TYPE) || !defined(apollo))
#    include <sys/file.h>
#  endif
#endif
#include <errno.h>

extern int errno;

char *error_description();

extern char *mk_lockname();

int Grab_the_file(flock_fd)
     int flock_fd;
{
    int	retcode	= FLOCKING_OK;
#ifdef USE_FCNTL_LOCKING
    struct flock lock_info;
#endif

    errno = 0;

#ifdef   USE_FCNTL_LOCKING
    lock_info.l_type = F_WRLCK;
    lock_info.l_whence = 0;
    lock_info.l_start = 0;
    lock_info.l_len = 0;

    if (fcntl(flock_fd, F_SETLK, &lock_info)) {
	return ((errno == EACCES) || (errno == EAGAIN))
		? FLOCKING_RETRY
		: FLOCKING_FAIL ;
    }
#endif

#ifdef	USE_FLOCK_LOCKING
    if (flock (flock_fd, LOCK_NB | LOCK_EX)) {

	retcode = ((errno == EWOULDBLOCK) || (errno == EAGAIN))
		   ? FLOCKING_RETRY
		   : FLOCKING_FAIL ;

#ifdef USE_FCNTL_LOCKING
	lock_info.l_type = F_UNLCK;
	lock_info.l_whence = 0;
	lock_info.l_start = 0;
	lock_info.l_len = 0;

	/*
	 *  Just unlock it because we did not succeed with the
	 *  flock()-style locking. Never mind the return value.
	 *  It was our own lock anyway if we ever got this far.
	 */
	fcntl (flock_fd, F_SETLK, &lock_info);
#endif
	return retcode;
    }
#endif

    return FLOCKING_OK;
}

int Release_the_file(flock_fd)
     int flock_fd;
{
#ifdef USE_FCNTL_LOCKING
  struct flock lock_info;
#endif

    int	fcntlret = 0,
	flockret = 0,
	fcntlerr = 0,
	flockerr = 0;

#ifdef	USE_FLOCK_LOCKING
    errno = 0;
    flockret = flock (flock_fd, LOCK_UN);
    flockerr = errno;
#endif

#ifdef	USE_FCNTL_LOCKING
    lock_info.l_type = F_UNLCK;
    lock_info.l_whence = 0;
    lock_info.l_start = 0;
    lock_info.l_len = 0;

    errno = 0;
    fcntlret = fcntl (flock_fd, F_SETLK, &lock_info);
    fcntlerr = errno;
#endif

    if (fcntlret) {
	errno = fcntlerr;
	return fcntlret;
    }
    else if (flockret) {
	errno = flockerr;
	return flockret;
    }
    return 0;
}

int lock(direction, folder)
     int direction;
     struct folder_info *folder;
{
      /** Create lock file to ensure that we don't get any mail 
	  while altering the folder contents!
	  If it already exists sit and spin until 
	     either the lock file is removed...indicating new mail
	  or
	     we have iterated MAX_ATTEMPTS times, in which case we
	     either fail or remove it and make our own (determined
	     by if REMOVE_AT_LAST is defined in header file

	  If direction == INCOMING then DON'T remove the lock file
	  on the way out!  (It'd mess up whatever created it!).

	  But if that succeeds and if we are also locking by flock(),
	  follow a similar algorithm. Now if we can't lock by flock(),
	  we DO need to remove the lock file, since if we got this far,
	  we DID create it, not another process.
      **/

      register int create_iteration = 0,
		   flock_iteration = 0;
      int kill_status;
      char pid_buffer[SHORT];

#ifdef	USE_DOTLOCK_LOCKING		/* { USE_DOTLOCK_LOCKING  */

#ifdef SAVE_GROUP_MAILBOX_ID
      setgid(mailgroupid); /* reset id so that we can get at lock file */
#endif


      if(folder->lock_state == ON) {
	dprint(1, (debugfile,
		   "Lock: Folder %s already locked.\n", 
		   folder->cur_folder));
	if (direction == INCOMING)
	  dprint(1, (debugfile,
		     "ERROR: ... And direction INCOMING! Software error!\n"));
	else
	  return 0;
      }		   
#ifdef PIDCHECK
      /** first, try to read the lock file, and if possible, check the pid.
	  If we can validate that the pid is no longer active, then remove
	  the lock file.
       **/
      errno = 0; /* most systems don't clear the errno flag */

      if((folder->create_fd=open(folder->lockfile,O_RDONLY)) != -1) {
	if (read(folder->create_fd, pid_buffer, SHORT) > 0) {
	  create_iteration = atoi(pid_buffer);
	  if (create_iteration) {
	    kill_status = kill(create_iteration, 0);
	    if (kill_status != 0 && errno != EPERM) {
	      close(folder->create_fd);
	      if (unlink(folder->lockfile) != 0) {
	        MoveCursor(elm_LINES, 0);
		Raw(OFF);
		dprint(1, (debugfile,
			   "Error %s\n\ttrying to unlink file %s (%s)\n", 
			   error_description(errno), 
			   folder->lockfile, "lock"));
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmLeaveCouldntRemoveCurLock,
				  "\nCouldn't remove the current lock file %s\n"), 
			  folder->lockfile);
		lib_error(FRM("** %s **\n"), 
			  error_description(errno));
#ifdef SAVE_GROUP_MAILBOX_ID
		setgid(groupid);
#endif
		if (direction == INCOMING)
		  leave(0);
		else
		  emergency_exit(0);
	      }
	    }
	  }
	}
	create_iteration = 0;
      }
#endif
	      
      /* try to assert create lock file MAX_ATTEMPTS times */
      do {

	errno = 0;
	if((folder->create_fd=open(folder->lockfile,
			   O_WRONLY | O_CREAT | O_EXCL,0444)) != -1)
	  break;
	else {
	  if(errno != EEXIST && errno != EACCES) {
	    /* Creation of lock failed NOT because it already exists!!! */
            /* If /var/mail nfs mounted on Solaris 2.3 at least you can */
	    /* get EACCES.  Treat it like EEXIST. */

	    MoveCursor(elm_LINES, 0);
	    Raw(OFF);
	    if (direction == OUTGOING) {
	      dprint(1, (debugfile, 
			 "Error encountered attempting to create lock %s\n", 
			 folder->lockfile));
	      dprint(1, (debugfile, "** %s **\n", error_description(errno)));
	      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveErrorCreatingLock,
				"\nError encountered while attempting to create lock file %s;\n"),
			folder->lockfile);
	      lib_error(FRM("** %s.**\n\n"), 
			error_description(errno));
	    } else {	/* incoming - permission denied in the middle?  Odd. */
	      dprint(1, (debugfile,
			 "Can't create lock file: creat(%s) raises error %s (lock)\n", 
			 folder->lockfile, 
			 error_description(errno)));
	      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveCantCreateLock,
				"Can't create lock file! Need write permission in \"%s\".\n"),
			mailhome);
	    }
#ifdef SAVE_GROUP_MAILBOX_ID
	    setgid(groupid);
#endif
	    leave(0);
	  }
	}
	dprint(2, (debugfile,"File '%s' already exists!  Waiting...(lock)\n", 
		   folder->lockfile));
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveWaitingToRead,
			  "Waiting to read mailbox while mail is being received: attempt #%d"),
		  create_iteration);
	sleep(5);
      } while (create_iteration++ < MAX_ATTEMPTS);
      clear_error();
      if (errno == ENOENT && folder->create_fd >= 0)
	errno = 0; /* Some os leave the errno from the open on the creat call */

      if(errno != 0) {
	
	/* we weren't able to create the lock file */

#ifdef REMOVE_AT_LAST

	/** time to waste the lock file!  Must be there in error! **/
	dprint(2, (debugfile, 
	   "Warning: I'm giving up waiting - removing lock file(lock)\n"));
	if (direction == INCOMING)
	  PutLine0(elm_LINES, 0, catgets(elm_msg_cat, ElmSet, ElmLeaveTimedOutRemoving,
		"\nTimed out - removing current lock file..."));
	else
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveThrowingAwayLock,
			    "Throwing away the current lock file!"));

	if (unlink(folder->lockfile) != 0) {
	  MoveCursor(elm_LINES, 0);
	  Raw(OFF);
	  dprint(1, (debugfile,
	    "Error %s\n\ttrying to unlink file %s (%s)\n", 
	    error_description(errno), folder->lockfile, "lock"));
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveCouldntRemoveCurLock,
			    "\nCouldn't remove the current lock file %s\n"), 
		    folder->lockfile);
	  lib_error(FRM("** %s **\n"), 
		    error_description(errno));
#ifdef SAVE_GROUP_MAILBOX_ID
	  setgid(groupid);
#endif
	  if (direction == INCOMING)
	    leave(0);
	  else
	    emergency_exit(0);
	}

	/* we've removed the bad lock, let's try to assert lock once more */
	if((folder->create_fd=open(folder->lockfile,
			   O_WRONLY | O_CREAT | O_EXCL,0444)) == -1){

	  /* still can't lock it - just give up */
	  dprint(1, (debugfile, 
		     "Error encountered attempting to create lock %s\n", 
		     folder->lockfile));
	  dprint(1, (debugfile, "** %s **\n", error_description(errno)));
	  MoveCursor(elm_LINES, 0);
	  Raw(OFF);
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveErrorCreatingLock,
			    "\nError encountered while attempting to create lock file %s;\n"),
		    folder->lockfile);
	  lib_error(FRM("** %s. **\n\n"), 
		    error_description(errno));
#ifdef SAVE_GROUP_MAILBOX_ID
	  setgid(groupid);
#endif
	  leave(0);
	}
#else
	/* Okay...we die and leave, not updating the mailfile mbox or
	   any of those! */

	MoveCursor(elm_LINES, 0);
	Raw(OFF);
	if (direction == INCOMING) {
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveGivingUp,
			    "\n\nGiving up after %d iterations.\n"), 
		    create_iteration);
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeavePleaseTryAgain,
			    "\nPlease try to read your mail again in a few minutes.\n\n"));
	  dprint(1, (debugfile, 
	    "Warning: bailing out after %d iterations...(lock)\n",
	    create_iteration));
#ifdef SAVE_GROUP_MAILBOX_ID
	  setgid(groupid);
#endif
	  leave_locked(0);
	} else {
	  dprint(1, (debugfile, 
	   "Warning: after %d iterations, timed out! (lock)\n",
	   create_iteration));
#ifdef SAVE_GROUP_MAILBOX_ID
	  setgid(groupid);
#endif
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveErrorTimedOutLock,
			    "Timed out on locking mailbox.  Leaving program.\n"));
	  leave(0);
	}
#endif
      }

      /* If we're here we successfully created the lock file */
      dprint(5,
	(debugfile, "Lock %s %s for file %s on.\n", 
	 folder->lockfile,
	 (direction == INCOMING ? "incoming" : "outgoing"), 
	 folder->cur_folder));

      /* Place the pid of Elm into the lock file for SVR3.2 and its ilk */
      elm_sfprintf(pid_buffer, sizeof pid_buffer,
		   FRM("%d"), 
		   getpid());
      write(folder->create_fd, pid_buffer, strlen(pid_buffer));

      (void)close(folder->create_fd);
#ifdef SAVE_GROUP_MAILBOX_ID
      setgid(groupid);
#endif
#endif	/* } USE_DOTLOCK_LOCKING */
				   
#ifdef SYSCALL_LOCKING
      /* Now we also need to lock the file with flock(2) */


      /* try to assert lock MAX_ATTEMPTS times */
      do {

	switch (Grab_the_file (fileno(folder->fh_folder))) {

	case	FLOCKING_OK:
	    goto    EXIT_RETRY_LOOP;

	case	FLOCKING_FAIL:
	    /*
	     *	Creation of lock failed
	     *	NOT because it already exists!!!
	     */

	    dprint (1, (debugfile, 
			"Error encountered attempting to flock %s\n",
			folder->cur_folder));
	    dprint (1, (debugfile, "** %s **\n", 
			error_description(errno)));
	    MoveCursor(elm_LINES, 0);
	    Raw(OFF);
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveErrorFlockMailbox,
			      "\nError encountered while attempting to flock mailbox %s;\n"), 
		      folder->cur_folder);
	    lib_error(FRM("** %s. **\n\n"), 
		      error_description(errno));
#ifdef	USE_DOTLOCK_LOCKING
	    (void)unlink(folder->lockfile);
#endif /* USE_DOTLOCK_LOCKING */
	    leave(0);

	    break;

	case	FLOCKING_RETRY:
	default:
	    dprint (2, (debugfile,
			"Mailbox '%s' already locked!  Waiting...(lock)\n", 
			folder->cur_folder));
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveWaitingToRead,
			      "Waiting to read mailbox while mail is being received: attempt #%d"),
		      flock_iteration);
	    sleep(5);
	}
      } while (flock_iteration++ < MAX_ATTEMPTS);

EXIT_RETRY_LOOP:
      clear_error();

      if(errno != 0) {

	MoveCursor(elm_LINES, 0);
	Raw(OFF);
	/* We couldn't lock the file. We die and leave not updating
	 * the mailfile mbox or any of those! */

	if (direction == INCOMING) {
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveGivingUp,
			    "\n\nGiving up after %d iterations.\n"), 
		    flock_iteration);
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeavePleaseTryAgain,
			    "\nPlease try to read your mail again in a few minutes.\n\n"));
	  dprint(1, (debugfile, 
	    "Warning: bailing out after %d iterations...(lock)\n",
		     flock_iteration));
	} else {
	  dprint(1, (debugfile, 
	   "Warning: after %d iterations, timed out! (lock)\n",
	   flock_iteration));
	}
#ifdef	USE_DOTLOCK_LOCKING
	(void)unlink(folder->lockfile);
#endif
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveErrorTimedOutLock,
		"Timed out on locking mailbox.  Leaving program.\n"));
	leave(0);
      }

      /* We locked the file */
      dprint(5,
	(debugfile, "Lock %s on file %s on.\n",
	(direction == INCOMING ? "incoming" : "outgoing"), 
	 folder->cur_folder));
#endif /* SYSCALL_LOCKING */

      dprint(5,
	(debugfile, "Lock %s for file %s on successfully.\n",
	(direction == INCOMING ? "incoming" : "outgoing"), 
	 folder->cur_folder));
      folder->lock_state = ON;
      return(0);
}

int flush_mailfile(folder)
     struct folder_info *folder;
{
	if (!MAILFILE(folder))
		return(0);
#ifdef ultrix
	/** Ultrix returns an error if fflush is called on a file opened
	    for read only, so we have to account for this.
	**/

	if ((MAILFILE(folder)->_flag & (_IOREAD|_IORW)) == _IOREAD)
		return(0);
#endif
	return(fflush(MAILFILE(folder)));
}

int unlock(interrupt, folder)
     int interrupt;
     struct folder_info *folder;
{
	/** Remove the lock file!    This must be part of the interrupt
	    processing routine to ensure that the lock file is NEVER
	    left sitting in the mailhome directory!

	    If also using flock(), remove the file lock as well.
	 **/

	int retcode = 0;

	/* If interrupt is set, avoid calling no-reentrant routines ... */

	/** Flush the mailfile buffer if necessary before removing the lock.
	**/

	if (MAILFILE(folder) && !interrupt)
	  flush_mailfile(folder);

#ifndef USE_DOTLOCK_LOCKING
	dprint(5,
	  (debugfile, "Lock (no .lock) for file %s %s off.\n",
	   folder->cur_folder, 
	   (folder-> lock_state == ON ? "going" : "already")));
#else   /* USE_DOTLOCK_LOCKING */
	dprint(5,
	  (debugfile, "Lock %s for file %s %s off.\n",
 	    (folder->lockfile ? folder->lockfile : "none"),
	   folder->cur_folder,
	   (folder->lock_state == ON ? "going" : "already")));
#endif  /* USE_DOTLOCK_LOCKING */

	if(folder->lock_state == ON) {

#ifdef SYSCALL_LOCKING
	    if (retcode = Release_the_file (fileno(folder->fh_folder))) {

		dprint(1, (debugfile,
			   "Error %s\n\ttrying to unlock file %s (%s)\n", 
			   error_description(errno), 
			   folder->cur_folder, "unlock"));

	    }
#endif
#ifndef	USE_DOTLOCK_LOCKING	/* { USE_DOTLOCK_LOCKING */
		folder->lock_state = OFF; /* indicate we don't have a lock on */
#else
#ifdef SAVE_GROUP_MAILBOX_ID
		setgid(mailgroupid);
#endif
		if((retcode = unlink(folder->lockfile)) == 0) {	/* remove lock file */
		  folder->lock_state = OFF; /* indicate we don't have a lock on */
	  } else {
	    dprint(1, (debugfile,
		       "Error %s\n\ttrying to unlink file %s (%s)\n", 
		       error_description(errno), 
		       folder->lockfile,
		       "unlock"));
	    if (!interrupt)
	      lib_error(CATGETS(elm_msg_cat, ElmSet, 
				ElmLeaveCouldntRemoveOwnLock,
				"Couldn't remove my own lock file %s!"), 
			folder->lockfile);
	  }
#ifdef SAVE_GROUP_MAILBOX_ID
	  setgid(groupid);
#endif
#endif	/* } !USE_DOTLOCK_LOCKING */
	}
	return(retcode);
}
