
static char rcsid[] = "@(#)$Id: out_utils.c,v 1.3.2.1 1999/08/27 04:06:12 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.3.2.1 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This file contains routines used for output in the ELM program.

**/

#include "headers.h"
#include "me.h"

static char err_buffer[SLEN];		/* store last error message */

static char central_message_buffer[SLEN];

void show_last_error()
{
  /** rewrite last error message! **/
  if(RawState()) {
    error(err_buffer);
  }
}

void clear_error()
{
  if(RawState()) {
    MoveCursor(elm_LINES,0);
    CleartoEOLN();
    err_buffer[0] = '\0';
  }
}

void set_error(s)
     char *s;
{
  strfcpy(err_buffer, s, sizeof err_buffer);
}


static void error_help P_((CONST char *s));
static void error_help (s)
     CONST char *s;
{
  MoveCursor(elm_LINES,0);
  CleartoEOLN();
  PutLine0(elm_LINES,(elm_COLUMNS-strlen(s))/2,s);
  fflush(stdout);
}

int error(s)
     CONST char *s;
{
	/** outputs error 's' to screen at line 22, centered! **/


  dprint(1, (debugfile, "ERROR message: %s\n", 
	     s));

  if(!RawState())
    printf("%s\n", s);

  else if (strlen(s) < elm_COLUMNS && NULL == strchr(s,'\n'))
    error_help(s);
  else {
    char * s1 = safe_strdup(s);
    char *s2, *s3;
    
    for (s2=s1; *s2 != '\0'; s2 = s3) {
      char c;
      for (s3 = s2; *s3 != '\0' && s3 - s2 < elm_COLUMNS && *s3 != '\n'; s3++);
      c = *s3;
      *s3 = '\0';
      error_help(s2);
      *s3 = c;
      if ('\n' == c)
	s3++;
    }

    free(s1);
  }
  strfcpy(err_buffer, s, sizeof err_buffer);	/* save it too! */
  return 0;
}

void out_util_setup() {
  set_error_handler(error);
}

void lower_prompt(s)
     char *s;
{
  /** prompt user for input on LINES-1 line, left justified **/
  
  if(RawState()) {
    PutLine0(elm_LINES-1,0,s);
    CleartoEOLN();
  } else {
    fprintf(stderr,"%s\n",s);
  }
}

void prompt(s)
     char *s;
{
  /** prompt user for input on LINES-3 line, left justified **/

  if(RawState()) {
    PutLine0(elm_LINES-3,0,s);
    CleartoEOLN();
  } else {
    fprintf(stderr,"%s\n",s);
  }
}

void set_central_message(string, arg)
     char *string, *arg;
{
  /** set up the given message to be displayed in the center of
    the current window **/ 

  sprintf(central_message_buffer, string, arg);
    
}

void display_central_message()
{
  /** display the message if set... **/

  if(RawState()) {
    if (central_message_buffer[0] != '\0') {
      ClearLine(elm_LINES-15);
      Centerline(elm_LINES-15, central_message_buffer);
      fflush(stdout);
    }
  }
}

void clear_central_message()
{
  /** clear the central message buffer **/

  central_message_buffer[0] = '\0';
}

void sleep_message() {
  if (sleepmsg > 0)
    sleep(sleepmsg);
}
