#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#include "config.h"
#include "mailleds.h"

extern int uid;
extern int euid;
extern int pid;
extern char opt_q;
extern char *pid_filename;
extern char *username;

void set_pidfilename(void)
{
	int size = (strlen(PIDFILE_DIR) + strlen("/mailleds-") + strlen(username) + strlen(".pid") + 1);
	pid_filename = (char *) xmalloc(size);
	sprintf(pid_filename, "%s/mailleds-%s.pid", PIDFILE_DIR, username);
}

void write_pidfile(void)
{
	FILE *pidfile;
	if ((pidfile = fopen(pid_filename, "w")) == (FILE *) NULL) {
		fprintf(stderr, "mailleds: could not write pidfile %s\n", pid_filename);
		exit(-2);
	}
	fprintf(pidfile, "%d", pid);
	fclose(pidfile);
}

int get_pid_from_file(char *pid_filename)
{
	char buf[1024];
	char *inc;
	FILE *pid_file;
	if ((pid_file = fopen(pid_filename, "r"))) {
		fgets(buf, 1024, pid_file);
		fclose(pid_file);
		inc = buf;
		while (isspace(*inc))
			inc++;
		return (atoi(inc));
	} else {
		return (0);
	}
}

int pid_check(void)
{
	int test_pid;
	test_pid = get_pid_from_file(pid_filename);
	if (test_pid) {
		if (kill(test_pid, 0) < 0 && errno == ESRCH)
			return (1);	/* pidfile is stale -- override. */
		if (!opt_q)
			fprintf(stderr, "mailleds: mailleds process %d already running for %s\n", test_pid, username);
		exit(-2);
	} else {
		return (1);
	}
}
