/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * view_install.c
 *
 * Create VIEW postmaster object
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "symbols.h"
#include "constants.h"
#include "defaults.h"
#include "pm.h"
#include "view.h"
#include "memory.h"

static void view_reset(void);
static void view_refresh_all(void);
static void view_refresh(void);
static void view_calc_nec_size(void);
static void twod_calc_nec_size(VIEW_ITEM *v);

static char *VIEW_OBJ_NAME = "View";

static char *VIEW[] = {
  "View.Refresh_Num", "View.Refresh_Type", "View.Refresh",
  "View.Refresh_All", "View.OneD_Function", "View.Calc_Nec_Size",
  "View.Nec_Size", "View.Reset"
  };

typedef enum {
  REFRESH_NUM=0, REFRESH_TYPE, REFRESH, REFRESH_ALL,
  ONED_FUNCTION, CALC_NEC_SIZE, NEC_SIZE, RESET
  } VIEW_t;


void
view_install()
{
  pm(CREATE_OBJ, VIEW_OBJ_NAME,
     CREATE_ELEM, VIEW[REFRESH_NUM], INT,
     CREATE_ELEM, VIEW[REFRESH_TYPE], STRNG,
     CREATE_ELEM, VIEW[REFRESH], FNCT,
     CREATE_ELEM, VIEW[REFRESH_ALL], FNCT,
     CREATE_ELEM, VIEW[ONED_FUNCTION], FNCT,
     CREATE_ELEM, VIEW[CALC_NEC_SIZE], FNCT,
     CREATE_ELEM, VIEW[NEC_SIZE], DBL_LIST,
     CREATE_ELEM, VIEW[RESET], FNCT,
     NULL);

  pm(INIT, VIEW[REFRESH],
     PUT, VIEW[REFRESH], view_refresh,
     INIT, VIEW[REFRESH_TYPE], 10,
     INIT, VIEW[REFRESH_ALL],
     PUT, VIEW[REFRESH_ALL], view_refresh_all,
     INIT, VIEW[RESET],
     PUT, VIEW[RESET], view_reset,
     INIT, VIEW[ONED_FUNCTION],
     PUT, VIEW[ONED_FUNCTION], oned_function,
     INIT, VIEW[CALC_NEC_SIZE], 
     PUT, VIEW[CALC_NEC_SIZE], view_calc_nec_size,
     INIT, VIEW[NEC_SIZE], 4,
     NULL);
}


/* define some variables for view to use for speed purposes */
double *view_f = NULL;
int (*view_auxf)();

static void
view_reset()
{
  int dim = *((int *) pm(GET, "Model.Funct_Dim", NULL));

  if (view_f) free(view_f);
  if (dim == 0)
    view_f = NULL;
  view_f = (double *) malloc(dim*sizeof(double));

  view_auxf = (int (*)()) pm(GET, "Model.Aux_Function", NULL);
  
}

static void
view_refresh()
{
  char t[20];
  VIEW_ITEM *v;

  int n = *((int *) pm(GET, VIEW[REFRESH_NUM], NULL));
  pm(GET, VIEW[REFRESH_TYPE], t, NULL);

/*  printf ("%d %s\n", n,t); */

  if (strcmp(t,"TWOD") == 0)
    {
      v = get_view(TWOD, n);
      if (v != NULL)
	twod_all_mem(v);
      else 
	fprintf(stdout,"view_refresh: bad twod window number %d.\n", n);
      return;
    }
  else if (strcmp(t,"ONED") == 0)
    {
      v = get_view(ONED, n);
      if (v != NULL)
	oned_all_mem(v);
      else
	fprintf(stdout, "view_refresh: bad oned window number %d.\n", n);
      return;
    }
  
  fprintf(stdout,"view_refresh: Unrecognized view type %s %d.\n",t,n);
}

void
view_refresh_all()
{
  VIEW_ITEM *v = Views;

  while (v) {
    switch(v->type)
      {
      case TWOD:
	twod_all_mem(v);
	break;
      case ONED:
      case GEOMVIEW:
      default:
	fprintf(stdout, "mem_all_view: unrecognized view type.\n");
	break;
      }
    v = v->next_View;
  }
}



void 
view_calc_nec_size()
{
    char t[20];
    VIEW_ITEM *v;

    int n = *((int *) pm(GET, VIEW[REFRESH_NUM], NULL));
    pm(GET, VIEW[REFRESH_TYPE], t, NULL);

    if (strcmp(t,"TWOD") == 0) {
        v = get_view(TWOD,n);
        if (v != NULL)
	    twod_calc_nec_size(v);
        else 
            fprintf(stdout, "view_calc_nec_size: bad twod window number %d.\n", n);
        return;
    } else if (strcmp(t,"ONED") == 0) {
        fprintf (stdout, "view_calc_nec_size: not implemented yet.\n");
        return;
        }

    fprintf (stdout, "view_calc_nec_size: Unrecognized view type %s %d.\n", t,n);

} 
   

static void
twod_calc_nec_size(v)
VIEW_ITEM *v;
{
    char *name;
    memory m;
    int i=0;
    TWOD_VIEW_ITEM *twod = &(v->data.twod);
    int fn = FALSE;
    int mempoints;
    int *color;
    double maxdx, maxdy, mindx, mindy;
    double *points, *params, dx, dy;

/* Make sure we're not wasting our time, and getting a meaningless result */
    pm(EXEC, "Memory.Count", NULL);
    mempoints = *((int *)pm(GET, "Memory.Points", NULL)); 
    if (mempoints == 0) return;

/* Okay, so there's more than one point, so set the max & min values to things we 
 * hope will get changed, and go from there...
 */
    maxdx = twod->hormin;
    maxdy = twod->vermin;
    mindx = twod->hormax;
    mindy = twod->vermax;

    while ( (name = (char *)pm(QUERY, "Memory", MEMRY, i, NULL)) ) {
        i++;
        m = (memory) pm(GET, name, NULL);
          /* will need function values */
        if ( (twod->hortype == FUNCT) || (twod->vertype == FUNCT) ) fn = TRUE;
 
        if (memory_reset_read(m) == 0) {
            while (memory_read_next_flow(m, NULL, NULL, NULL, NULL, NULL)==0) {
                while (memory_read_next_traj(m, NULL, NULL, NULL) == 0) {
                    while (memory_read_next_point(m, &points, &params, &color,
                                                NULL, NULL) == 0) {
                        if (fn == TRUE)
                            view_auxf(view_f, points, params);
                        switch ( twod->hortype ) {
                            case VARB:
                                dx = points[twod->horindex];
                                break;
                            case PARAM:
                                dx = params[twod->horindex];
                                break;
                            case FUNCT:
                                dx = view_f[twod->horindex];
                                break;
                            }
                        switch ( twod->vertype ) {
                             case VARB:
                                dy = points[twod->verindex];
                                break;
                             case PARAM:
                                dy = params[twod->verindex];
                                break;
                             case FUNCT:
                                dy = view_f[twod->verindex];
                                break;
                             }
                        if (dx < mindx)  mindx = dx;
                        if (dy < mindy)  mindy = dy;
                        if (dx > maxdx)  maxdx = dx;
                        if (dy > maxdy)  maxdy = dy;
		    }
                }
            }
        }
    }
 
    pm(PUT, "View.Nec_Size", 0, mindx, NULL);
    pm(PUT, "View.Nec_Size", 1, maxdx, NULL);
    pm(PUT, "View.Nec_Size", 2, mindy, NULL);
    pm(PUT, "View.Nec_Size", 3, maxdy, NULL);

} 
