#include "gtkicq.h"
#include "gtkfunc.h"

#ifdef USE_XSCREENSAVER
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/scrnsaver.h>

void auto_away( struct sokandlb *data )
{
	static Display *display = NULL;
	int time_idle;
	static XScreenSaverInfo *info = NULL;

	if( !display )
		display = XOpenDisplay( getenv( "DISPLAY" ) );
	
	if( Current_Status != STATUS_ONLINE && Current_Status != STATUS_AWAY &&
	    Current_Status != STATUS_FREE_CHAT )
		return;

	if( !info )
		info = XScreenSaverAllocInfo();
	XScreenSaverQueryInfo ( display, DefaultRootWindow( display ),
	                        info );

	time_idle = info->idle;

	if( time_idle > 60000 * AUTO_NA )
		icq_change_status( data->sok, STATUS_NA, data );
	else if( time_idle > 60000 * AUTO_AWAY )
		icq_change_status( data->sok, STATUS_AWAY, data );
}

#endif
