/***

fltmgr.c - filter list management routines

Copyright (c) Gerard Paul Java 1998

This software is open source; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License in the included COPYING file for
details.

***/

#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include "fltmgr.h"
#include "dirs.h"

int loadfilterlist(unsigned int protocol, struct ffnode **fltfile)
{
    int pfd;
    int result = 0;

    struct ffnode *ffiles = NULL;
    struct ffnode *ptemp;
    struct ffnode *tail = NULL;

    int br;

    if (protocol == F_TCP)
	pfd = open(TCPFLNAME, O_RDONLY);
    else
	pfd = open(UDPFLNAME, O_RDONLY);

    if (pfd < 0) {
	*fltfile = NULL;
	return 1;
    }
    do {
	ptemp = malloc(sizeof(struct ffnode));
	br = read(pfd, &(ptemp->ffe), sizeof(struct filterfileent));

	if (br > 0) {
	    if (ffiles == NULL) {
		ffiles = ptemp;
		ffiles->prev_entry = NULL;
	    } else {
		tail->next_entry = ptemp;
		ptemp->prev_entry = tail;
	    }

	    ptemp->next_entry = NULL;
	    tail = ptemp;
	} else {
	    free(ptemp);

	    if (br < 0)
		result = 1;
	}
    } while (br > 0);

    close(pfd);
    *fltfile = ffiles;

    return result;
}

void destroyfilterlist(struct ffnode *fltlist)
{
    struct ffnode *fftemp;

    if (fltlist != NULL) {
	fftemp = fltlist->next_entry;

	do {
	    free(fltlist);
	    fltlist = fftemp;
	    if (fftemp != NULL)
		fftemp = fftemp->next_entry;
	} while (fltlist != NULL);
    }
}
