/***

packet.c - routines to open the raw socket, read socket data and
           adjust the initial packet pointer
           
Written by Gerard Paul Java
Copyright (c) Gerard Paul Java 1997, 1998

This software is open source; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License in the included COPYING file for
details.

***/

#ifndef _I386_TYPES_H
#include <asm/types.h>
#endif

#include <curses.h>
#include <panel.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <unistd.h>
#include <net/if_arp.h>
#include <linux/if_packet.h>
#include <linux/if_ether.h>
#include <linux/if_fddi.h>
#include "deskman.h"
#include "error.h"
#include "options.h"

void open_socket(int *fd, char *ifname)
{
    int dummy;
    struct sockaddr si;

    *fd = socket(PF_INET, SOCK_PACKET, htons(ETH_P_ALL));

    if (*fd < 0) {
	errbox("Unable to open raw socket", ANYKEY_MSG, &dummy);
	return;
    }
    
    /*
     * Bind socket to a specific interface if one specified.
     */
     
    if (strcmp(ifname, "") != 0) {
        bzero(&si, sizeof(struct sockaddr));
        si.sa_family = PF_INET;
        strcpy(si.sa_data, ifname);
        bind(*fd, &si, sizeof(struct sockaddr));
    }
}

void adjustpacket(char *tpacket, unsigned short family, char **packet,
		  int *readlen)

{
    switch (family) {
    case ARPHRD_ETHER:
    case ARPHRD_LOOPBACK:
	*packet = tpacket + ETH_HLEN;
	*readlen -= ETH_HLEN;
	break;
    case ARPHRD_SLIP:
    case ARPHRD_PPP:
    case ARPHRD_CSLIP:
    case ARPHRD_SLIP6:
    case ARPHRD_CSLIP6:
	*packet = tpacket;
	break;
    case ARPHRD_FDDI:
        *packet = tpacket + sizeof(struct fddihdr);
        *readlen -= sizeof(struct fddihdr);
        break;
    default:
	*packet = (char *) NULL;	/* return a NULL packet to signal */
	break;			/* an unrecognized link protocol */
    }				/* to the caller.  Hopefully, this */
}				/* switch statement will grow. */

void getpacket(int fd, char *buf, struct sockaddr_pkt *fromaddr,
	       int *ch, int *br, unsigned long timeout, WINDOW * win)
{
    int fromlen;
    fd_set set;
    struct timeval tv;
    struct timeval *ptv;
    int ss;

    FD_ZERO(&set);
    FD_SET(0, &set);
    FD_SET(fd, &set);

    if (timeout > 0) {
	tv.tv_sec = 0;
	tv.tv_usec = DEFAULT_UPDATE_DELAY;
	ptv = &tv;
    } else
	ptv = NULL;

    do {
	ss = select(fd + 1, &set, 0, 0, ptv);
    } while (ss < 0);

    *br = 0;
    *ch = ERR;

    if (FD_ISSET(fd, &set)) {
	fromlen = sizeof(struct sockaddr_pkt);
	*br = recvfrom(fd, buf, 8192, 0,
		       (struct sockaddr *) fromaddr, &fromlen);
    }

    if (FD_ISSET(0, &set))
	*ch = wgetch(win);
}
