#include "irc.h"
/*#include "dcc.h"*/
#include "struct.h"
#include "ircaux.h"
#include "ctcp.h"
#include "status.h"
#include "lastlog.h"
#include "server.h"
#include "screen.h"
#include "vars.h"
#include "misc.h"
#include "output.h"
#include "module.h"
#include "hash2.h"
#include <sys/time.h>
#include <stdlib.h>
#include <stdio.h>

/*
 * I put this here because pana said I should use it, but its commented out
 * in ircaux.h :)
*/

#define new_realloc(x,y) n_realloc((x),(y),__FILE__,__LINE__)


#define MINPLAYERS 2            /* Minimum number of players per game */
#define MAXPLAYERS 10           /* Max number of players per game */
#define MINLENGTH 3             /* Minimum number of letters per acronym */
#define MAXLENGTH 5             /* Max number of letters per acronym */
#define ROUNDS 10               /* Number of rounds to play */
#define EXTENSIONS 3            /* Max number of 30 second extensions */
#define TOP 10                  /* Show the top XX names for the scores */
#define MAXLEN 15               /* Max number of characters per acro word */

#define SCOREFILE ".BitchX/acro.score"
#define WEBSCORE "acro.html"

struct prec {
	char *nick;
	char *host;
	char *acro;
	char *last;
	struct prec *next;
};

struct vrec {
	char *nick;
	char *host;
	int vote;
	struct vrec *next;
};

struct grec {
	int progress;
	int round;
	int rounds;
	int players;
	int extended;
	int top;
	int maxlen;
	char *nym;
}; 

struct srec {
	char *nick;
	unsigned long score;
	struct srec *next;
};

char letters[] = "ABCDEFGHIJKLMNOPRSTUVWY";

struct grec *init_acro(struct grec *);
void make_acro(struct grec *);
int valid_acro(struct grec *, char *);
struct srec *read_scores(void);
int write_scores(struct srec *);
struct prec *take_acro(struct grec *, struct prec *, char *, char *, char *);
struct vrec *take_vote(struct grec *, struct vrec *, struct prec *, char *, char *, char *);
struct srec *end_vote(struct vrec *, struct prec *, struct srec *);
struct srec *sort_scores(struct srec *);
int comp_score(struct srec **one, struct srec **two);
void show_scores(struct grec *, struct srec *, struct srec *, char *);
void warn_acro(char *);
void start_vote(char *);
void warn_vote(char *);
void end_voting(char *);
void show_acros(struct prec *, char *);
void free_round(struct prec **, struct vrec **);
void free_score(struct srec **);
static void put_scores _(( IrcCommandDll *, char *, char *, char *));
