/*
 * irc_std.h: header to define things used in all the programs ircii
 * comes with
 *
 * hacked together from various other files by matthew green
 * copyright(c) 1993 
 *
 * See the copyright file, or do a help ircii copyright 
 *
 * @(#)$Id: irc_std.h,v 1.20.2.1 1995/10/25 19:03:59 glen Exp $
 */

#ifndef __irc_std_h
#define __irc_std_h
#include "defs.h"

/*
 * Everybody needs these ANSI headers...
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <stdarg.h>

/*
 * Everybody needs these POSIX headers...
 */
#include <sys/types.h>
#include <unistd.h>
#include <signal.h>
#include <limits.h>
#include <sys/param.h>
#include <errno.h>

/*
 * Everybody needs these INET headers...
 */
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif



/*
 * Some systems define tputs, etc in this header
 */
#ifdef HAVE_TERMCAP_H
#include <termcap.h>
#endif


/*
 * Deal with brokenness in <time.h> and <sys/time.h>
 */
#ifdef TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# ifdef HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

/*
 * Deal with brokenness in <fcntl.h> and <sys/fcntl.h>
 */
#ifdef HAVE_SYS_FCNTL_H
# include <sys/fcntl.h>
#else
# ifdef HAVE_FCNTL_H
#  include <fcntl.h>
# endif
#endif

/*
 * Deal with brokenness figuring out struct direct
 */
#if HAVE_DIRENT_H
# include <dirent.h>
# define NAMLEN(dirent) strlen((dirent)->d_name)
#else
# define dirent direct
# define NAMLEN(dirent) (dirent)->d_namlen
# if HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif
# if HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif
# if HAVE_NDIR_H
#  include <ndir.h>
# endif
#endif



#undef _
#undef const
#undef volatile
#ifdef __STDC__
# define _(a) a
#else
# define _(a) ()
# define const
# define volatile
#endif

/*
 * First try to figure out if we can use GNU CC special features...
 */
#ifndef __GNUC__
# define __inline		/* delete gcc keyword */
# define __A(x)
# define __N
# define __inline__
#else
# if (__GNUC__ >= 2) && (__GNUC_MINOR__ >= 7)
#  define __A(x) __attribute__ ((format (printf, x, x + 1)))
#  define __N    __attribute__ ((noreturn))
# else
#  define __A(x)
#  define __N
#  define __inline
# endif
#endif

/*
 * Figure out how to make alloca work
 * I took this from the autoconf documentation
 */
#if defined(__GNUC__) && !defined(HAVE_ALLOCA_H)
# define alloca __builtin_alloca
#else
# if HAVE_ALLOCA_H
#  include <alloca.h>
# else
#  ifdef _AIX
 #pragma alloca
#  else
#   ifndef alloca
char *alloca();
#   endif
#  endif
# endif
#endif


/*
 * Deal with broken linux and its broken scandir.
 * Leave me alone.
 */
#ifdef __linux__
typedef void *scandir_arg3;
typedef void *scandir_arg4;
#else
typedef int (*scandir_arg3) ();
typedef int (*scandir_arg4) (const void *, const void *);
#endif

# include <errno.h>
extern	int	errno;

#if defined(HAVE_SYS_SELECT_H) && defined(NEED_SYS_SELECT_H)
#include <sys/select.h>
#endif


#ifndef NBBY
# define NBBY	8		/* number of bits in a byte */
#endif /* NBBY */

#ifndef NFDBITS
# define NFDBITS	(sizeof(long) * NBBY)	/* bits per mask */
#endif /* NFDBITS */

#undef FD_SET
#define FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))

#undef FD_CLR
#define FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))

#undef FD_ISSET
#define FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))

#undef FD_ZERO
#define FD_ZERO(p)	memset((void *)(p), 0, sizeof(*(p)))

#ifndef	FD_SETSIZE
#define FD_SETSIZE	32
#endif


#ifdef HAVE_SYS_SYSLIMITS_H
# include <sys/syslimits.h>
#endif
   
#include <limits.h>
   
typedef RETSIGTYPE sigfunc (int);
sigfunc *my_signal (int, sigfunc *, int);

#include <string.h>
#include <stdlib.h>
#undef index
#define index strchr

#ifndef MAXPATHLEN
#ifndef PATHSIZE
#define PATHSIZE 1024
#endif
#define MAXPATHLEN  PATHSIZE
#endif

#ifndef HAVE_STRERROR
#ifndef SYS_ERRLIST_DECLARED
extern  char    *sys_errlist[];
#endif
#define strerror(x) (char *)sys_errlist[x]
#endif

#ifdef HAVE_BSDGETTIMEOFDAY
#define gettimeofday BSDgettimeofday
#endif

#ifdef GETTOD_NOT_DECLARED
extern	int	gettimeofday(struct timeval *tv, struct timezone *tz);
#endif

/* we need an unsigned 32 bit integer for dcc, how lame */

#ifdef UNSIGNED_LONG32

typedef		unsigned long		u_32int_t;

#else
# ifdef UNSIGNED_INT32

typedef		unsigned int		u_32int_t;

# else

typedef		unsigned long		u_32int_t;

# endif /* UNSIGNED_INT32 */
#endif /* UNSIGNED_LONG32 */

#ifdef __STDC__
#define BUILT_IN_COMMAND(x) \
	void x (char *command, char *args, char *subargs, char *helparg)
#else
#define BUILT_IN_COMMAND(x) \
	void x (command, args, subargs, helparg) char *command, *args, *subargs, *helparg;
#endif


#if defined(_AIX)
int getpeername (int s, struct sockaddr *, int *);
int getsockname (int s, struct sockaddr *, int *);
int socket (int, int, int);
int bind (int, struct sockaddr *, int);
int listen (int, int);
int accept (int, struct sockaddr *, int *);
int recv (int, void *, int, unsigned int);
int send (int, void *, int, unsigned int);
int gettimeofday (struct timeval *, struct timezone *);
int gethostname (char *, int);
int setsockopt (int, int, int, void *, int);
int setitimer (int, struct itimerval *, struct itimerval *);
int ioctl (int, int, ...);

#endif


#ifdef __EMX__
#define strcasecmp stricmp
#define strncasecmp strnicmp
#endif

#ifndef HAVE_MEMMOVE
void *memmove(char *, const char *, register size_t);

#endif

#endif /* __irc_std_h */

