#include "irc.h"
#include "struct.h"

#include "alist.h"
#include "ircaux.h"
#include "screen.h"
#include "hook.h"
#include "output.h"
#include "misc.h"
#include "vars.h"

extern void reinit_status (Window *, char *, int);

IrcVariable fset_array[] = 
{
	{ "FORMAT_381",			STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_391",			STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_443",			STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_471",			STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_473",			STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_474",			STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_475",			STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_476",			STR_TYPE_VAR,	0, NULL, NULL, 0, 0},

	{ "FORMAT_ACTION",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_ACTION_AR",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_ACTION_CHANNEL",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_ACTION_OTHER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_ACTION_OTHER_AR",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_ACTION_USER",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_ACTION_USER_AR",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_ALIAS",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_ASSIGN",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_AWAY",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_BACK",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_BANS",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_BANS_HEADER",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_BITCH",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_BOT",			STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_BOT_FOOTER",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_BOT_HEADER",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_BWALL",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},

	{ "FORMAT_CHANNEL_SIGNOFF",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},

	{ "FORMAT_CONNECT",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CSET",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CTCP",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CTCP_CLOAK",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CTCP_CLOAK_FUNC",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CTCP_CLOAK_FUNC_USER",STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CTCP_CLOAK_UNKNOWN",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CTCP_CLOAK_UNKNOWN_USER", STR_TYPE_VAR,0,NULL, NULL, 0, 0},
	{ "FORMAT_CTCP_CLOAK_USER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CTCP_FUNC",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CTCP_FUNC_USER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CTCP_REPLY",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CTCP_UNKNOWN",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CTCP_UNKNOWN_USER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CTCP_USER",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_DCC",			STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_DCC_CHAT",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_DCC_CONNECT",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_DCC_ERROR",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_DCC_LOST",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_DCC_REQUEST",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_DESYNC",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	
	{ "FORMAT_DISCONNECT",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_ENCRYPTED_NOTICE",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_ENCRYPTED_PRIVMSG",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_FLOOD",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_FRIEND_JOIN",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_HELP",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_HOOK",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},

	{ "FORMAT_IGNORE_INVITE",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_IGNORE_MSG",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_IGNORE_MSG_AWAY",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_IGNORE_NOTICE",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_IGNORE_WALL",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},

	{ "FORMAT_INVITE",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_INVITE_USER",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_JOIN",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_KICK",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_KICK_USER",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_KILL",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_LEAVE",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_LINKS",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_LIST",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_MAIL",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_MODE",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_MODE_CHANNEL",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_MSG",			STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_MSGCOUNT",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_MSGLOG",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_MSG_GROUP",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_BANNER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},

	{ "FORMAT_NAMES_BOT",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_BOTCOLOR",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_FOOTER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_FRIEND",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_FRIENDCOLOR",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_IRCOP",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_NICKCOLOR",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_NONOP",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_OP",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_OPCOLOR",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_SHIT",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_SHITCOLOR",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_VOICE",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_VOICECOLOR",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},

	{ "FORMAT_NETADD",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NETJOIN",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NETSPLIT",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NETSPLIT_HEADER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NICKNAME",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NICKNAME_OTHER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NICKNAME_USER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NICK_AUTO",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NICK_COMP",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NICK_MSG",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NONICK",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NOTE",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NOTICE",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NOTIFY_OFF",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NOTIFY_ON",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NOTIFY_SIGNOFF",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NOTIFY_SIGNOFF_UH",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NOTIFY_SIGNON",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NOTIFY_SIGNON_UH",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_OPER",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_OV",			STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_PASTE",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_PUBLIC",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_PUBLIC_AR",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_PUBLIC_MSG",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_PUBLIC_MSG_AR",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_PUBLIC_NOTICE",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_PUBLIC_NOTICE_AR",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_PUBLIC_OTHER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_PUBLIC_OTHER_AR",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_REL",			STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_RELM",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_RELN",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_RELS",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_RELSM",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_RELSN",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SEND_ACTION",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SEND_ACTION_OTHER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SEND_AWAY",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SEND_CTCP",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SEND_DCC_CHAT",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SEND_MSG",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SEND_NOTICE",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SEND_PUBLIC",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SEND_PUBLIC_OTHER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_MSG1",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_MSG1_FROM",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_MSG2",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_MSG2_FROM",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},

	{ "FORMAT_SERVER_NOTICE_BOT",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_BOT1",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_BOT_ALARM",STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_CLIENT_CONNECT",STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_CLIENT_EXIT",STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_CLIENT_INVALID",STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_CLIENT_TERM",STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_FAKE",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_GLINE",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_KILL",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_KILL_LOCAL",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_KLINE",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_NICKC",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_OPER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_REHASH",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_STATS",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_TRAFFIC_HIGH",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_TRAFFIC_NORM",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_UNAUTH",STR_TYPE_VAR,	0, NULL, NULL, 0, 0},

	{ "FORMAT_SET",			STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SET_NOVALUE",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SHITLIST",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SHITLIST_FOOTER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SHITLIST_HEADER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SIGNOFF",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SILENCE",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SMODE",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_STATUS",		STR_TYPE_VAR,	0, NULL, reinit_status, 0, 0},
	{ "FORMAT_STATUS1",		STR_TYPE_VAR,	0, NULL, reinit_status, 0, 0},
	{ "FORMAT_STATUS2",		STR_TYPE_VAR,	0, NULL, reinit_status, 0, 0},
	{ "FORMAT_STATUS3",		STR_TYPE_VAR,	0, NULL, reinit_status, 0, 0},
	{ "FORMAT_TIMER",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_TOPIC",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_TOPIC_CHANGE",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_TOPIC_CHANGE_HEADER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_TOPIC_SETBY",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_TOPIC_UNSET",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_TRACE_OPER",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_TRACE_SERVER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_TRACE_USER",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_USAGE",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_USERLIST",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_USERLIST_FOOTER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_USERLIST_HEADER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_USERMODE",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_USERS",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_USERS_BOT",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_USERS_HEADER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_USERS_SHIT",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_USERS_USER",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_VERSION",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0 },
	{ "FORMAT_WALL",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WALLOP",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WALL_AR",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHO",			STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_ADMIN",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_AWAY",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_BOT",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_CHANNELS",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_FOOTER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_FRIEND",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_HEADER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_HELP",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_IDLE",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_NAME",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_NICK",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_OPER",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_REGISTER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_SERVER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_SERVICE",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_SHIT",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_SIGNON",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOLEFT_FOOTER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOLEFT_HEADER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOLEFT_USER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOWAS_HEADER",	STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOWAS_NICK",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WIDELIST",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WINDOW_SET",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_XTERM_TITLE",		STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ NULL,				0,		0, NULL, NULL, 0, 0}
};

typedef struct FSet_struc
{
	IrcVariable **list;
	int max;
	int max_set;
	alist_func func;
} FSet;

int strncasecmp(const char *s1, const char *s2, size_t n);
       
FSet ext_fset_list = { NULL, 0, 0, strncasecmp };

void add_new_fset(char *name, char *args)
{
	if (args && *args)
	{
		IrcVariable *tmp = NULL;
		int cnt, loc;
		tmp = (IrcVariable *)find_array_item((array *)&ext_fset_list, name, &cnt, &loc);
		if (!tmp || cnt >= 0)
		{
			tmp = new_malloc(sizeof(IrcVariable));
			tmp->name = m_strdup(name);
			tmp->type = STR_TYPE_VAR;
			add_to_array((array *)&ext_fset_list, (array_item *)tmp);
		}
		malloc_strcpy(&tmp->string, args);
	}
	else 
	{
		IrcVariable *tmp;
		if ((tmp = (IrcVariable *)remove_from_array((array *)&ext_fset_list, name)))
		{
			new_free(&tmp->name);
			new_free(&tmp->string);
			new_free(&tmp);
		}
	}
}

IrcVariable *find_ext_fset_var(char *name)
{
IrcVariable *tmp = NULL;
int loc, cnt;
	tmp = (IrcVariable *)find_array_item((array *)&ext_fset_list, name, &cnt, &loc);
	if (tmp && cnt < 0)
		return tmp;
	return NULL;
}



char *fget_string_var(enum FSET_TYPES var)
{
IrcVariable *tmp = NULL;
	if ((tmp = find_ext_fset_var(fset_array[var].name)))
		return tmp->string;
	return (fset_array[var].string);
}

void fset_string_var(enum FSET_TYPES var, char *value)
{
	if (value && *value)
		malloc_strcpy(&(fset_array[var].string), value);
	else
		new_free(&(fset_array[var].string));
}

static int find_fset_variable(IrcVariable *array, char *org_name, int *cnt)
{
	IrcVariable *v, *first;
	int     len, var_index;
	char    *name = NULL;

	malloc_strcpy(&name, org_name);
	upper(name);
	len = strlen(name);
	var_index = 0;
	for (first = array; first->name; first++, var_index++) 
	{
		if (strncmp(name, first->name, len) == 0) 
		{
			*cnt = 1;
			break;
		}
	}
	if (first->name) 
	{
		if (strlen(first->name) != len) 
		{
			v = first;
			for (v++; v->name; v++, (*cnt)++) 
			{
				if (strncmp(name, v->name, len) != 0)
					break;
			}
		}
		new_free(&name);
		return (var_index);
	}
	else 
	{
		*cnt = 0;
		new_free(&name);
		return (-1);
	}
}


static void set_fset_var_value(int var_index, char *name, char *value)
{
	IrcVariable *var = NULL;
	if (name)
		var = find_ext_fset_var(name);
	if (!var)
		var = &(fset_array[var_index]);
	
	switch (var->type) 
	{
	case STR_TYPE_VAR:
		{
			if (value)
			{
				if (*value)
					malloc_strcpy(&(var->string), value);
				else
				{
					put_it("%s", convert_output_format(fget_string_var(FORMAT_SET_FSET), "%s %s", var->name, var->string?var->string:empty_string));
					return;
				}
			} else
				new_free(&(var->string));
			if (var->func)
				(var->func) (current_window, var->string, 0);
			say("Value of %s set to %s", var->name, var->string ?
				var->string : "<EMPTY>");
		}
		break;
	default:
		say("FSET_type not supported");
	}
}

static inline void fset_variable_case1(char *name, int var_index, char *args)
{
	set_fset_var_value(var_index, name, args);
}

static inline void fset_variable_casedef(char *name, int cnt, int var_index, char *args)
{
	for (cnt += var_index; var_index < cnt; var_index++)
		set_fset_var_value(var_index, NULL, args);
}

static inline void fset_variable_noargs(char *name)
{
int var_index = 0;
	for (var_index = 0; var_index < NUMBER_OF_FSET; var_index++)
		set_fset_var_value(var_index, NULL, empty_string);
	for (var_index = 0; var_index < ext_fset_list.max; var_index++)
		set_fset_var_value(var_index, (*ext_fset_list.list[var_index]).name, empty_string);
}


BUILT_IN_COMMAND(fset_variable)
{
	char    *var;
	char 	*name = NULL;
	int     cnt, var_index;
	int	hook = 0;
	
	if ((var = next_arg(args, &args)) != NULL) 
	{
		if (*var == '-') 
		{
			var++;
			args = NULL;
		}
		else if (*var == '+')
		{
			var++;
			add_new_fset(var, args);
			return;
		}
		var_index = find_fset_variable(fset_array, var, &cnt);

		if ((cnt >= 0) || !(fset_array[var_index].int_flags & VIF_PENDING))
			hook = 1;

		if (cnt < 0)
			fset_array[var_index].int_flags |= VIF_PENDING;

		if (hook)
			hook = do_hook(SET_LIST, "%s %s", var, args ? args : empty_string);
		else
			hook = 1;

		if (cnt < 0)
			fset_array[var_index].int_flags &= ~VIF_PENDING;
		
		if (hook)
		{
			switch (cnt) 
			{
				case 0:
					say("No such variable \"%s\"", var);
					return;
				case 1:
					fset_variable_case1(name, var_index, args);
					return;
				default:
					say("%s is ambiguous", var);
					fset_variable_casedef(name, cnt, var_index, empty_string);
					return;
			}
		}
	} else
		fset_variable_noargs(name);
}


void create_fsets(Window *win, int ansi)
{
	fset_string_var(FORMAT_381_FSET, "%K>%n>%W> You are now a %GIRC%n whore");
	fset_string_var(FORMAT_391_FSET, "$G [$1] Channel is full");
	fset_string_var(FORMAT_443_FSET, "$G [$1] Channel is full");

	fset_string_var(FORMAT_471_FSET, "$G [$1] Channel is full");
	fset_string_var(FORMAT_473_FSET, "$G [$1] Invite only channel");
	fset_string_var(FORMAT_474_FSET, "$G [$1] Banned from channel");
	fset_string_var(FORMAT_475_FSET, "$G [$1] Bad channel key");
	fset_string_var(FORMAT_476_FSET, "$G [$1] You are not opped");

#ifdef ONLY_STD_CHARS
	fset_string_var(FORMAT_ACTION_FSET, "%K* %W$1 %n$4-");
	fset_string_var(FORMAT_ACTION_AR_FSET, "%K* %Y$1 %n$4-");
	fset_string_var(FORMAT_ACTION_CHANNEL_FSET, "%K* %Y$1/$3 %n$4-");
	fset_string_var(FORMAT_ACTION_OTHER_FSET, "%K* %n>%c$1 %n$3-");
	fset_string_var(FORMAT_ACTION_OTHER_AR_FSET, "%K* %y>%c$1 %n$3-");
	fset_string_var(FORMAT_ACTION_USER_FSET, "%K* %n>%c$1 %n$3-");
	fset_string_var(FORMAT_ACTION_USER_AR_FSET, "%K* %y>%c$1 %n$3-");
#else
	fset_string_var(FORMAT_ACTION_FSET, ansi?"%K %W$1 %n$4-":" $1 $4-");
	fset_string_var(FORMAT_ACTION_AR_FSET, ansi?"%K %Y$1 %n$4-":" $1 $4-");
	fset_string_var(FORMAT_ACTION_CHANNEL_FSET, ansi?"%K %Y$1/$3 %n$4-":" $1/$3 $4-");
	fset_string_var(FORMAT_ACTION_OTHER_FSET, ansi?"%K* %n>%c$1 %n$3-":"* >$1 $3-");
	fset_string_var(FORMAT_ACTION_OTHER_AR_FSET, ansi?"%K* %y>%c$1 %n$3-":"* >$1 $3-");
	fset_string_var(FORMAT_ACTION_USER_FSET, ansi?"%K* %n>%c$1 %n$3-":"* >$1 $3-");
	fset_string_var(FORMAT_ACTION_USER_AR_FSET, ansi?"%K* %y>%c$1 %n$3-":"* >$1 $3-");
#endif
	fset_string_var(FORMAT_ALIAS_FSET, "Alias $[20.]0 $1-");
	fset_string_var(FORMAT_ASSIGN_FSET, "Assign $[20.]0 $1-");
	fset_string_var(FORMAT_AWAY_FSET, "is away: ($3-) $1 $2");	
	fset_string_var(FORMAT_BACK_FSET, "is back from the dead. Gone $1 hrs $2 min $3 secs");
	fset_string_var(FORMAT_BANS_HEADER_FSET,"#  Channel    SetBy        Sec  Ban");
	fset_string_var(FORMAT_BANS_FSET, "$[2]0 $[10]1 $[10]3 $[-5]numdiff($time() $4)  $2");
	fset_string_var(FORMAT_BITCH_FSET, "%RBitch Mode Activated%n $1 $4 $5 on $3");
	fset_string_var(FORMAT_BOT_HEADER_FSET, "Aop Prot Bot         Channel    Hostname");
	fset_string_var(FORMAT_BOT_FOOTER_FSET, "There are $1 on the BotList");
	fset_string_var(FORMAT_BOT_FSET, "$[2]0 $[2]1 $[11]2 $[10]3 $4");

	fset_string_var(FORMAT_BWALL_FSET, "[%GBX-Wall%n/%W$1:$2%n] $4-");

	fset_string_var(FORMAT_CHANNEL_SIGNOFF_FSET, "$G %nSignOff %W$1%n: $3 %K(%n$4-%K)");
	fset_string_var(FORMAT_CONNECT_FSET, "$G Connecting to server $1/%c$2%n");


	fset_string_var(FORMAT_CTCP_FSET, "%K>%n>%W> %G$1 %K[%g$2%K]%g requested $4- from $3");
	fset_string_var(FORMAT_CTCP_CLOAK_FSET, "%K>%n>%W> %C$1 %K[%c$2%K]%c requested $4- from $3");
	fset_string_var(FORMAT_CTCP_CLOAK_FUNC_FSET, "%K>%n>%W> %C$1 %K[%c$2%K]%c requested $4- from $3");
	fset_string_var(FORMAT_CTCP_CLOAK_FUNC_USER_FSET, "%K>%n>%W> %C$1 %K[%c$2%K]%c requested $4- from you");
	fset_string_var(FORMAT_CTCP_CLOAK_UNKNOWN_FSET, "%K>%n>%W> %C$1 %K[%c$2%K]%c requested unknown ctcp $4- from $3");
	fset_string_var(FORMAT_CTCP_CLOAK_UNKNOWN_USER_FSET, "%K>%n>%W> %C$1 %K[%c$2%K]%c requested unknown ctcp $4- from $3");
	fset_string_var(FORMAT_CTCP_CLOAK_USER_FSET, "%K>%n>%W> %C$1 %K[%c$2%K]%c requested $4- from you");
	fset_string_var(FORMAT_CTCP_FUNC_FSET, "%K>%n>%W> %G$1 %K[%g$2%K]%g requested $4- from $3");
	fset_string_var(FORMAT_CTCP_FUNC_USER_FSET, "%K>%n>%W> %G$1 %K[%g$2%K]%g requested $4- from you");
	fset_string_var(FORMAT_CTCP_UNKNOWN_FSET, "%K>%n>%W> %G$1 %K[%g$2%K]%g requested unknown ctcp $4- from $3");
	fset_string_var(FORMAT_CTCP_UNKNOWN_USER_FSET, "%K>%n>%W> %G$1 %K[%g$2%K]%g requested unknown ctcp $4- from %g$3");
	fset_string_var(FORMAT_CTCP_USER_FSET, "%K>%n>%W> %G$1 %K[%g$2%K]%g requested $4- from you");
	fset_string_var(FORMAT_CTCP_REPLY_FSET, "$G %nCTCP %W$3 %nreply from %n$1: $4-");


	fset_string_var(FORMAT_DCC_CHAT_FSET, ansi?"%K[%G$1%K(%gdcc%K)] %n$3-":"[$1(dcc)] $3-");
#if 0
	fset_string_var(FORMAT_DCC_CONNECT_FSET, "$G %RDCC%n $1 %nconnection with %W$2%K[%c$4, port $5%K]%n established");
#else
	fset_string_var(FORMAT_DCC_CONNECT_FSET, "$G %RDCC%n $1 with %W$2%K[%c$4:$5%K]%n established");
#endif
	fset_string_var(FORMAT_DCC_ERROR_FSET, "$G %RDCC%n lost %w$1%w %rto $2 %K[%w$3-%K]");
	fset_string_var(FORMAT_DCC_LOST_FSET, "$G %RDCC%n %W$1%n:%g$2%n %K[%C$3%K]%n $4 $5 completed in $6 secs %K(%W$7 $8/sec%K)");
	fset_string_var(FORMAT_DCC_REQUEST_FSET, "$G %RDCC%n $1 %K(%n$2%K)%n request from %W$3%K[%c$4 [$5:$6]%K]%n $8 $7");
	fset_string_var(FORMAT_DESYNC_FSET, "$G $1 is desynced from $2 at $0");
	fset_string_var(FORMAT_DISCONNECT_FSET, "$G Use %G/Server%n to connect to a server");
	fset_string_var(FORMAT_ENCRYPTED_NOTICE_FSET, "%K-%Y$1%K(%p$2%K)-%n $3-");
	fset_string_var(FORMAT_ENCRYPTED_PRIVMSG_FSET, "%K[%Y$1%K(%p$2%K)]%n $3-");
	fset_string_var(FORMAT_FLOOD_FSET, "%Y$1%n flood detected from %G$2%K(%g$3%K)%n on %K[%G$4%K]");
	fset_string_var(FORMAT_FRIEND_JOIN_FSET, "$G %R$1 %K[%c$2%K]%n has joined $3");
	fset_string_var(FORMAT_HELP_FSET, "$0-");
	fset_string_var(FORMAT_HOOK_FSET, "$0-");
	fset_string_var(FORMAT_INVITE_FSET, "%K>%n>%W> $1 Invites You to $2-");
	fset_string_var(FORMAT_INVITE_USER_FSET, "%K>%n>%W> Inviting $1 to $2-");
	fset_string_var(FORMAT_JOIN_FSET, ansi?"$G %C$1 %K[%c$2%K]%n has joined $3":"$G $1 [$2] has joined $3");
	fset_string_var(FORMAT_KICK_FSET, "$G %n$3 was kicked off $2 by %c$1 %K(%n$4-%K)");
	fset_string_var(FORMAT_KICK_USER_FSET, "%K>%n>%W> %WYou%n have been kicked off %c$2%n by %c$1 %K(%n$4-%K)");
	fset_string_var(FORMAT_KILL_FSET, "%K>%n>%W> %RYou have been killed by $1 for $2-");
	fset_string_var(FORMAT_LEAVE_FSET, "$G $1 %K[%w$2%K]%n has left $3 %K[%W$4%K]");
#ifdef ONLY_STD_CHARS
	fset_string_var(FORMAT_LINKS_FSET, "%K|%n$[24]0%K| |%n$[24]1%K| |%n$[3]2%K| |%n$[13]3%K|");
#else
	fset_string_var(FORMAT_LINKS_FSET, "%K%n$[24]0%K %n$[24]1%K %n$[3]2%K %n$[13]3%K");
#endif
	fset_string_var(FORMAT_LIST_FSET, "$[12]1 $[-5]2   $[40]3-");
	fset_string_var(FORMAT_MAIL_FSET, "%K>%n>%W> You've got mail!@#");
	fset_string_var(FORMAT_MSGCOUNT_FSET, "[$0-]");
	
	fset_string_var(FORMAT_MSGLOG_FSET, "[$[8]0] [$1] - $2-");
	
	fset_string_var(FORMAT_MODE_FSET, ansi?"$G %nmode%K/%c$3 %K[%W$4-%K]%n by %W$1":"$G mode/$3 [$4-] by $1");
	fset_string_var(FORMAT_SMODE_FSET, "$G %RServerMode%K/%c$3 %K[%W$4-%K]%n by %W$1");

	fset_string_var(FORMAT_MODE_CHANNEL_FSET, "$G %nmode%K/%c$3 %K[%W$4-%K]%n by %W$1");

	fset_string_var(FORMAT_MSG_FSET, ansi?"%K[%P$1%K(%p$2%K)]%n $3-":"[$1($2)] $3-");

	fset_string_var(FORMAT_OPER_FSET, "%C$1 %K[%c$2%K]%n )s now %Wan%w %GIRC%n whore");

	fset_string_var(FORMAT_IGNORE_INVITE_FSET, "%K>%n>%W> You have been invited to $1-");
	fset_string_var(FORMAT_IGNORE_MSG_FSET, "%K[%P$1%P$2%K(%p$3%K)]%n $4-");
	fset_string_var(FORMAT_IGNORE_MSG_AWAY_FSET, "%K[%P$1%P$2%K(%p$3%K)]%n $4-");
	fset_string_var(FORMAT_IGNORE_NOTICE_FSET, "%K-%P$2%K(%p$3%K)-%n $4-");
	fset_string_var(FORMAT_IGNORE_WALL_FSET, "%K%P$1%n $2-");
	fset_string_var(FORMAT_MSG_GROUP_FSET, "%K-%P$1%K:%p$2%K-%n $3-");

	if (ansi)
	{
		fset_string_var(FORMAT_NAMES_FSET, "$G %K[%GUsers%K(%g$1%K:%g$2%K)]%c $3");
		fset_string_var(FORMAT_NAMES_BOT_FSET, "$G %K[%GBots%K(%g$1%K:%g$2%K)]%c $3");
		fset_string_var(FORMAT_NAMES_FRIEND_FSET, "$G %K[%GFriends%K(%g$1%K:%g$2%K)]%c $3");
		fset_string_var(FORMAT_NAMES_BOTCOLOR_FSET, "%K[%C$0%G$[10]1%K]");
		fset_string_var(FORMAT_NAMES_FRIENDCOLOR_FSET, "%K[%C$0%Y$[10]1%K]");
		fset_string_var(FORMAT_NAMES_NICKCOLOR_FSET, "%K[%B $[10]1%K]");
		fset_string_var(FORMAT_NAMES_NONOP_FSET, "$G %K[%GNonChanOps%K(%g$1%K:%g$2%K)]%c $3");
		fset_string_var(FORMAT_NAMES_VOICECOLOR_FSET, "%K[%Mv%B$[10]1%K]");
		fset_string_var(FORMAT_NAMES_OP_FSET, "$G %K[%GChanOps%K(%g$1%K:%g$2%K)]%c $3");
		fset_string_var(FORMAT_NAMES_IRCOP_FSET, "$G %K[%GIrcOps%K(%g$1%K:%g$2%K)]%c $3");
		fset_string_var(FORMAT_NAMES_SHIT_FSET, "$G %K[%MShitUsers%K(%m$1%K:%m$2%K)]%c $3");
		fset_string_var(FORMAT_NAMES_SHITCOLOR_FSET, "%K[%C$0%n%R$[10]1%K]");
		fset_string_var(FORMAT_NAMES_VOICE_FSET, "$G %K[%MVoiceUsers%K(%m$1%K:%m$2%K)]%c $3");
		fset_string_var(FORMAT_NAMES_OPCOLOR_FSET, "%K[%C$0%n%B$[10]1%K]");
	} else {
		fset_string_var(FORMAT_NAMES_FSET, "$G [Users($1:$2)] $3");
		fset_string_var(FORMAT_NAMES_BOT_FSET, "$G [Bots($1:$2)] $3");
		fset_string_var(FORMAT_NAMES_FRIEND_FSET, "$G [Friends($1:$2)] $3");
		fset_string_var(FORMAT_NAMES_BOTCOLOR_FSET, "[$0$[10]1]");
		fset_string_var(FORMAT_NAMES_FRIENDCOLOR_FSET, "[$0$[10]1]");
		fset_string_var(FORMAT_NAMES_NICKCOLOR_FSET, "[ $[10]1]");
		fset_string_var(FORMAT_NAMES_NONOP_FSET, "$G [NonChanOps($1:$2)] $3");
		fset_string_var(FORMAT_NAMES_VOICECOLOR_FSET, "[v$[10]1]");
		fset_string_var(FORMAT_NAMES_OP_FSET, "$G [ChanOps($1:$2)] $3");
		fset_string_var(FORMAT_NAMES_IRCOP_FSET, "$G [IrcOps($1:$2)] $3");
		fset_string_var(FORMAT_NAMES_SHIT_FSET, "$G [ShitUsers($1:$2)] $3");
		fset_string_var(FORMAT_NAMES_SHITCOLOR_FSET, "[$0%n%R$[10]1]");
		fset_string_var(FORMAT_NAMES_VOICE_FSET, "$G [VoiceUsers($1:$2)] $3");
		fset_string_var(FORMAT_NAMES_OPCOLOR_FSET, "[$0$[10]1]");
	}
	fset_string_var(FORMAT_NETADD_FSET, "$G %nAdded: %W$1 $2");
	fset_string_var(FORMAT_NETJOIN_FSET, "$G %nNetjoined: %W$1 $2");
#if 0
	fset_string_var(FORMAT_NETSPLIT_FSET, "$G %nNetSplit detected: %W$1%n split from %W$2 %K[%c$0%K]");
#else
	fset_string_var(FORMAT_NETSPLIT_FSET, "$G %nNetSplit: %W$1%n split from %W$2 %K[%c$0%K]");
#endif
	fset_string_var(FORMAT_NICKNAME_FSET, "$G %W$1 %nis now known as %c$3");
	fset_string_var(FORMAT_NICKNAME_OTHER_FSET, "$G %W$1 %nis now known as %c$4");
	fset_string_var(FORMAT_NICKNAME_USER_FSET, "%K>%n>%W> %WYou%K(%n$1%K)%n are now known as %c$3");
	fset_string_var(FORMAT_NONICK_FSET, "%W$1%K:%n $3-");


	fset_string_var(FORMAT_NOTE_FSET, "($0) ($1) ($2) ($3) ($4) ($5-)");


	fset_string_var(FORMAT_NOTICE_FSET, ansi?"%K-%P$1%K(%p$2%K)-%n $3-":"-$1($2)- $3-");

	fset_string_var(FORMAT_REL_FSET,  "%K[%rmsg->$1%K]%n $4-");
	fset_string_var(FORMAT_RELN_FSET, "%K-%P$1%K(%p$2%K)-%n $4-");
	fset_string_var(FORMAT_RELM_FSET, "%K[%P%P$1%K(%p$2%K)]%n $4-");

	fset_string_var(FORMAT_RELSN_FSET, "%K[%rnotice%K(%R$1%K)] %n$2-");
	fset_string_var(FORMAT_RELS_FSET, "$1-");
	fset_string_var(FORMAT_RELSM_FSET, "%K[%rmsg%K(%R$1%K)] %n$2-");

	fset_string_var(FORMAT_NOTIFY_SIGNOFF_FSET, "$G %GSignoff%n by %r$[10]1%n at $0");
	fset_string_var(FORMAT_NOTIFY_SIGNOFF_UH_FSET, "$G %GSignoff%n by %r$1%K!%r$2%n at $0");
	fset_string_var(FORMAT_NOTIFY_SIGNON_UH_FSET, "$G %GSignon%n by %R$1%K!%R$2%n at $0");
	fset_string_var(FORMAT_NOTIFY_SIGNON_FSET, "$G %GSignon%n by %r$[-10]1%n at $0");
	fset_string_var(FORMAT_PASTE_FSET, "%K[%W$1%K]%n $2-");
	fset_string_var(FORMAT_PUBLIC_FSET, ansi?"%B<%n$1%B>%n $3-":"<$1> $3-");
	fset_string_var(FORMAT_PUBLIC_AR_FSET, ansi?"%B<%Y$1%B>%n $3-":"<$1> $3-");
	fset_string_var(FORMAT_PUBLIC_MSG_FSET, ansi?"%b(%n$1%K/%n$3%b)%n $4-":"($1/$3) $4-");
	fset_string_var(FORMAT_PUBLIC_MSG_AR_FSET, ansi?"%b(%Y$1%K/%Y$3%b)%n $4-":"($1/$3) $4-");

	fset_string_var(FORMAT_PUBLIC_NOTICE_FSET, ansi?"%K-%P$1%K:%p$3%K-%n $4-":"-$1:$3- $4-");
	fset_string_var(FORMAT_PUBLIC_NOTICE_AR_FSET, ansi?"%K-%G$1%K:%g$3%K-%n $4-":"-$1:$3- $4-");

	fset_string_var(FORMAT_PUBLIC_OTHER_FSET, ansi?"%b<%n$1%K:%n$2%b>%n $3-":"<$1:$2> $3-");
	fset_string_var(FORMAT_PUBLIC_OTHER_AR_FSET, ansi?"%b<%y$1%K:%n$2%b>%n $3-":"<$1:$2> $3-");

#ifdef ONLY_STD_CHARS
	fset_string_var(FORMAT_SEND_ACTION_FSET, "%K* %W$1 %n$3-");
	fset_string_var(FORMAT_SEND_ACTION_OTHER_FSET, "%K* %n-> %W$1%n/%c$2 %n$3-");
#else
	fset_string_var(FORMAT_SEND_ACTION_FSET, "%K %W$1 %n$3-");
	fset_string_var(FORMAT_SEND_ACTION_OTHER_FSET, "%K %n-> %W$1%n/%c$2 %n$3-");
#endif

	fset_string_var(FORMAT_SEND_AWAY_FSET, "[Away ($strftime($1 %a %b %d %I:%M%p %Z))] [$tdiff2(${time() - u})] [BX-MsgLog $2]");
	fset_string_var(FORMAT_SEND_CTCP_FSET, ansi?"%K[%rctcp%K(%R$1%K)] %n$2":"[ctcp($1)] $2");
	fset_string_var(FORMAT_SEND_DCC_CHAT_FSET, ansi?"%K[%rdcc%K(%R$1%K)] %n$2-":"[dcc($1)] $2-");
	fset_string_var(FORMAT_SEND_MSG_FSET, ansi?"%K[%rmsg%K(%R$1%K)] %n$3-":"[msg($1)] $3-");
	fset_string_var(FORMAT_SEND_NOTICE_FSET, ansi?"%K[%rnotice%K(%R$1%K)] %n$3-":"[notice($1)] $3-");
	fset_string_var(FORMAT_SEND_PUBLIC_FSET, ansi?"%P<%n$2%P>%n $3-":"<$2> $3-");
	fset_string_var(FORMAT_SEND_PUBLIC_OTHER_FSET, ansi?"%p<%n$2%K:%n$1%p>%n $3-":"<$2:$1> $3-");


	fset_string_var(FORMAT_SERVER_FSET, "$G%n $1: $2-");
	fset_string_var(FORMAT_SERVER_MSG1_FSET, "$G%n $1: $2-");
	fset_string_var(FORMAT_SERVER_MSG1_FROM_FSET, "$G%n $1: $2-");
	fset_string_var(FORMAT_SERVER_MSG2_FSET, "$G%n $1-");
	fset_string_var(FORMAT_SERVER_MSG2_FROM_FSET, "$G%n $1-");

	fset_string_var(FORMAT_SERVER_NOTICE_FSET, "%G!%g$1%G%n $2-");
	fset_string_var(FORMAT_SERVER_NOTICE_BOT_FSET, "Possible bot: %C$1 %K[%c$2-%K]%n");
	fset_string_var(FORMAT_SERVER_NOTICE_BOT1_FSET, "Possible $1 bot: %C$2 %K[%c$3-%K]%n");
	fset_string_var(FORMAT_SERVER_NOTICE_BOT_ALARM_FSET, "$1 alarm activated: %C$2 %K[%c$3-%K]%n");
	fset_string_var(FORMAT_SERVER_NOTICE_CLIENT_CONNECT_FSET, "Client Connecting: %C$1 %K[%c$2-%K]%n");
	fset_string_var(FORMAT_SERVER_NOTICE_CLIENT_EXIT_FSET, "Client Exiting: %C$1 %K[%c$2-%K]%n");
	fset_string_var(FORMAT_SERVER_NOTICE_CLIENT_INVALID_FSET, "Invalid username: %C$1 %K[%c$2-%K]%n");
	fset_string_var(FORMAT_SERVER_NOTICE_CLIENT_TERM_FSET, "Terminating client for excess flood %C$1%K [%c$2-%K]%n");
	fset_string_var(FORMAT_SERVER_NOTICE_FAKE_FSET, "Fake Mode detected on $1 -> $2-");
	fset_string_var(FORMAT_SERVER_NOTICE_KILL_FSET, "Foreign OperKill: %W$1%n killed %c$2%n %K(%n$3-%K)%n");
	fset_string_var(FORMAT_SERVER_NOTICE_KILL_LOCAL_FSET, "Local OperKill: %W$1%n killed %c$2%n %K(%n$3-%K)%n");
	fset_string_var(FORMAT_SERVER_NOTICE_KLINE_FSET, "%W$1%n added a new K-Line %K[%c$2%K]%n for $3-");
	fset_string_var(FORMAT_SERVER_NOTICE_GLINE_FSET, "%W$1%n added a new K-Line %K[%c$2%K]%n from $3 for $4-");
	fset_string_var(FORMAT_SERVER_NOTICE_NICK_COLLISION_FSET, "Nick collision8 %W$1%n killed %c$2%n %K(%n$3-%K)%n");
	fset_string_var(FORMAT_SERVER_NOTICE_OPER_FSET, "%C$1 %K[%c$2%K]%n is now %Wa%w %GIRC%n whore");
	fset_string_var(FORMAT_SERVER_NOTICE_REHASH_FSET, "%W$1%n is rehashing the Server config file");
	fset_string_var(FORMAT_SERVER_NOTICE_STATS_FSET, "Stats $1: %C$2 %K[%c$3-%K]%n");
	fset_string_var(FORMAT_SERVER_NOTICE_TRAFFIC_HIGH_FSET, "Entering high-traffic mode %K(%n$1 > $2-%K)%n");
	fset_string_var(FORMAT_SERVER_NOTICE_TRAFFIC_NORM_FSET, "Resuming standard operation %K(%n$1 $2 $3-%K)%n");
	fset_string_var(FORMAT_SERVER_NOTICE_UNAUTH_FSET, "Unauthorized Connection from $1-");

	fset_string_var(FORMAT_SET_FSET, "%g$[-30.]0 %w$1-");
	fset_string_var(FORMAT_CSET_FSET, "%r$[-14]1 %R$[-20.]0   %w$2-");
	fset_string_var(FORMAT_SET_NOVALUE_FSET, "%g$[-30.]0 has no value");
	fset_string_var(FORMAT_SHITLIST_FSET," $[3]0 $[34]1 $[10]2  $3-");
	fset_string_var(FORMAT_SHITLIST_FOOTER_FSET, "There are $1 users on the shitlist");
	fset_string_var(FORMAT_SHITLIST_HEADER_FSET, " lvl nick!user@host                     channels   reason");
	fset_string_var(FORMAT_SIGNOFF_FSET, "$G %nSignOff: %W$1 %K(%n$3-%K)");


	fset_string_var(FORMAT_SILENCE_FSET, "$G %RWe are $1 silencing $2 at $0");

	fset_string_var(FORMAT_TRACE_OPER_FSET, "%R$1%n %K[%n$3%K]");
	fset_string_var(FORMAT_TRACE_SERVER_FSET, "%R$1%n $2 $3 $4 %K[%n$5%K]%n $6-");
	fset_string_var(FORMAT_TRACE_USER_FSET, "%R$1%n %K[%n$3%K]");

	fset_string_var(FORMAT_TIMER_FSET, "$G $[-5]0 $[-10]1 $[-6]2 $3-");
	fset_string_var(FORMAT_TOPIC_FSET, "$G Topic for %c$1%K:%n $2-");
	fset_string_var(FORMAT_TOPIC_CHANGE_FSET, "$G %W$1 %nhas changed the topic on channel $2 to%K:%n $3-");
	fset_string_var(FORMAT_TOPIC_SETBY_FSET, "$G %ntopic set by %c$2%K [%c$stime($3)%K]");
	fset_string_var(FORMAT_TOPIC_UNSET_FSET, "$G %ntopic unset by $1 on $2");
	
	fset_string_var(FORMAT_USAGE_FSET, "$G Usage: /$0  $1-");
	fset_string_var(FORMAT_USERMODE_FSET, "$G %nMode change %K[%W$4-%K]%n for user %c$3");

	fset_string_var(FORMAT_USERLIST_FSET,"$[16]0 $[10]1 $[-10]2   $[-25]3 $[10]4");

	fset_string_var(FORMAT_USERLIST_FOOTER_FSET, "There are $1 users on the userlist");
	fset_string_var(FORMAT_USERLIST_HEADER_FSET, "level            nick       password     host                      channels");

	fset_string_var(FORMAT_USERS_FSET, "%K[%n$[10]1%K]%K[%n%C$4%B$[9]2%K]%K[%n$[33]3%K] %K[%n$0%K]");
	fset_string_var(FORMAT_USERS_USER_FSET, "%K[%n$[10]1%K]%K[%n%C$4%B$[9]2%K]%K[%n%B$[33]3%K]%K[%n$0%K]");
	fset_string_var(FORMAT_USERS_SHIT_FSET, "%K[%n$[10]1%K]%K[%n%C$4%B$[9]2%K]%K[%n%r$[33]3%K]%K[%n$[-16]0%K]");
	fset_string_var(FORMAT_USERS_HEADER_FSET, "%K[ %WC%nhannel  %K][ %WN%wickname %K][%n %Wu%wser@host                       %K][%n %Wl%wevel         %K]");

	fset_string_var(FORMAT_VERSION_FSET, "\002$0+$4$5\002 by panasync \002-\002 $2 $3");


	fset_string_var(FORMAT_WALL_FSET, "%G!%g$1:$2%G!%n $3-");
	fset_string_var(FORMAT_WALL_AR_FSET, "%G!%g$1:$2%G!%n $3-");


	fset_string_var(FORMAT_WALLOP_FSET, "%G!%g$1$2%G!%n $3-");
	fset_string_var(FORMAT_WHO_FSET, "%Y$[10]0 %W$[10]1%w %c$[3]2 %w$3%R@%w$4 ($6-)");
#ifdef ONLY_STD_CHARS
	fset_string_var(FORMAT_WHOIS_AWAY_FSET, "%G| %Wa%nway     : $0 - $1-");
	fset_string_var(FORMAT_WHOIS_BOT_FSET, "%G| %Wb%not      : A:$0 P:$1 [$2] $3-");
	fset_string_var(FORMAT_WHOIS_CHANNELS_FSET, "%G| %Wc%nhannels : $0-");
	fset_string_var(FORMAT_WHOIS_FRIEND_FSET, "%G| %Wf%nriend   : L:$0 A:$1 P:$2 $3-");
	fset_string_var(FORMAT_WHOIS_HEADER_FSET, "%G------------------------------------------------");
	fset_string_var(FORMAT_WHOIS_IDLE_FSET, "%G| %Wi%ndle     : $0 hours $1 mins $2 secs (signon: $stime($3))");
	fset_string_var(FORMAT_WHOIS_SHIT_FSET, "%G| %Ws%nhit     : L:$0 [$1] $2 $3-");
	fset_string_var(FORMAT_WHOIS_SIGNON_FSET, "%K %Ws%nignon   : $0-");
	fset_string_var(FORMAT_WHOIS_NAME_FSET, "%G| %Wi%nrcname  : $0-");
	fset_string_var(FORMAT_WHOIS_NICK_FSET, "%G| %W$0 %K(%n$1@$2%K) %K(%W$3-%K)");
	fset_string_var(FORMAT_WHOIS_OPER_FSET, "%G| %Wo%nperator : $0 $1-");
	fset_string_var(FORMAT_WHOIS_SERVER_FSET, "%G| %Ws%nerver   : $0 ($1-)");
	fset_string_var(FORMAT_WHOLEFT_HEADER_FSET, "%G------ %WWho %G---------------------- %WChannel%G--- %wServer %G------------- %wSeconds");
	fset_string_var(FORMAT_WHOLEFT_USER_FSET, "%G|%n $[-10]0!$[20]1 $[10]2 $[20]4 $3");
	fset_string_var(FORMAT_WHOWAS_HEADER_FSET, "%G-----------------------------------------------");
	fset_string_var(FORMAT_WHOWAS_NICK_FSET, "%G| %W$0%n was %K(%n$1@$2%K)");

	fset_string_var(FORMAT_WHOIS_ADMIN_FSET,   "%K| %Wa%ndmin    : $0 - $1-");
	fset_string_var(FORMAT_WHOIS_SERVICE_FSET, "%K| %Ws%nervice  : $0 - $1-");
	fset_string_var(FORMAT_WHOIS_HELP_FSET,    "%K| %Wh%nelp     : $0 - $1-");
	fset_string_var(FORMAT_WHOIS_REGISTER_FSET,"%K| %Wr%negister : $0 - $1-");
#else
	if (ansi)
	{
		fset_string_var(FORMAT_WHOIS_AWAY_FSET,  "%K| %Wa%nway     : $0 - $1-");
		fset_string_var(FORMAT_WHOIS_BOT_FSET, "%g| %Wb%not      : A:$0 P:$1 [$2] $3-");
		fset_string_var(FORMAT_WHOIS_CHANNELS_FSET, "%g| %Wc%nhannels : $0-");
		fset_string_var(FORMAT_WHOIS_FRIEND_FSET, "%g| %Wf%nriend   : F:$0 $1-");
		fset_string_var(FORMAT_WHOIS_HEADER_FSET, "%G---%g%G--%g%G-%g---%K%g--%K%g-%K--- --  -");
		fset_string_var(FORMAT_WHOIS_IDLE_FSET, "%K: %Wi%ndle     : $0 hours $1 mins $2 secs (signon: $stime($3))");
		fset_string_var(FORMAT_WHOIS_SHIT_FSET, "%g| %Ws%nhit     : L:$0 [$1] $2 $3-");
		fset_string_var(FORMAT_WHOIS_SIGNON_FSET, "%K %Ws%nignon   : $0-");
		fset_string_var(FORMAT_WHOIS_NAME_FSET, "%G %Wi%nrcname  : $0-");
		fset_string_var(FORMAT_WHOIS_NICK_FSET, "%G| %W$0 %K(%n$1@$2%K) %K(%W$3-%K)");
		fset_string_var(FORMAT_WHOIS_OPER_FSET, "%K| %Wo%nperator : $0 $1-");
		fset_string_var(FORMAT_WHOIS_SERVER_FSET, "%K %Ws%nerver   : $0 ($1-)");
		fset_string_var(FORMAT_WHOLEFT_HEADER_FSET, "%G %WWho %G%g---%G%g--%G%g-%G %WChannel%g %wServer %G-%g--%G%g--%G%g %wSeconds");
		fset_string_var(FORMAT_WHOLEFT_USER_FSET, "%G|%n $[-10]0!$[20]1 $[10]2 $[20]4 $3");
		fset_string_var(FORMAT_WHOWAS_HEADER_FSET, "%G---%g%G--%g%G-%g---%K%g--%K%g-%K--- --  -");
		fset_string_var(FORMAT_WHOWAS_NICK_FSET, "%G| %W$0%n was %K(%n$1@$2%K)");
		fset_string_var(FORMAT_WHOIS_ADMIN_FSET,   "%K| %Wa%ndmin    : $0 - $1-");
		fset_string_var(FORMAT_WHOIS_SERVICE_FSET, "%K| %Ws%nervice  : $0 - $1-");
		fset_string_var(FORMAT_WHOIS_HELP_FSET,    "%K| %Wh%nelp     : $0 - $1-");
		fset_string_var(FORMAT_WHOIS_REGISTER_FSET,"%K| %Wr%negister : $0 - $1-");
	} else {
		fset_string_var(FORMAT_WHOIS_AWAY_FSET,  "| away     : $0 - $1-");
		fset_string_var(FORMAT_WHOIS_BOT_FSET, "| bot      : A:$0 P:$1 [$2] $3-");
		fset_string_var(FORMAT_WHOIS_CHANNELS_FSET, "| channels : $0-");
		fset_string_var(FORMAT_WHOIS_FRIEND_FSET, "| friend   : F:$0 $1-");
		fset_string_var(FORMAT_WHOIS_HEADER_FSET, "--------------- --  -");
		fset_string_var(FORMAT_WHOIS_IDLE_FSET, ": idle     : $0 hours $1 mins $2 secs (signon: $stime($3))");
		fset_string_var(FORMAT_WHOIS_SHIT_FSET, "| shit     : L:$0 [$1] $2 $3-");
		fset_string_var(FORMAT_WHOIS_SIGNON_FSET, " signon   : $0-");
		fset_string_var(FORMAT_WHOIS_NAME_FSET, " ircname  : $0-");
		fset_string_var(FORMAT_WHOIS_NICK_FSET, "| $0 ($1@$2) ($3-)");
		fset_string_var(FORMAT_WHOIS_OPER_FSET, "| operator : $0 $1-");
		fset_string_var(FORMAT_WHOIS_SERVER_FSET, " server   : $0 ($1-)");

		fset_string_var(FORMAT_WHOLEFT_HEADER_FSET, " Who ------ Channel Server ----- Seconds");
		fset_string_var(FORMAT_WHOLEFT_USER_FSET, "| $[-10]0!$[20]1 $[10]2 $[20]4 $3");

		fset_string_var(FORMAT_WHOWAS_HEADER_FSET, "--------------- --  -");
		fset_string_var(FORMAT_WHOWAS_NICK_FSET, "| $0 was ($1@$2)");
		fset_string_var(FORMAT_WHOIS_ADMIN_FSET,   "| admin    : $0 - $1-");
		fset_string_var(FORMAT_WHOIS_SERVICE_FSET, "| service  : $0 - $1-");
		fset_string_var(FORMAT_WHOIS_HELP_FSET,    "| help     : $0 - $1-");
		fset_string_var(FORMAT_WHOIS_REGISTER_FSET,"| register : $0 - $1-");
	}
#endif
	fset_string_var(FORMAT_WIDELIST_FSET, "$1-");
	fset_string_var(FORMAT_WINDOW_SET_FSET, "$0-");
	
	fset_string_var(FORMAT_NICK_MSG_FSET, "$0 $1 $2-");

	fset_string_var(FORMAT_NICK_COMP_FSET, "$0\002:\002$1-");
	fset_string_var(FORMAT_NICK_AUTO_FSET, "$0\002:\002$1-");

	fset_string_var(FORMAT_STATUS_FSET, "%4%W$0-");
	fset_string_var(FORMAT_STATUS1_FSET, "%4%W$0-");
	fset_string_var(FORMAT_STATUS2_FSET, "%4%W$0-");
	fset_string_var(FORMAT_STATUS3_FSET, "%4%W$0-");
	fset_string_var(FORMAT_NOTIFY_OFF_FSET, "$[10]0 $[35]1 $[-6]2 $[-10]3 $4 $5");
	fset_string_var(FORMAT_NOTIFY_ON_FSET, "$[10]0 $[35]1 $[-6]2 $[-10]3 $4-");
	fset_string_var(FORMAT_OV_FSET, "[41m%S %>[1;30m[[1;32mOper[1;37mView[1;30;41m] ");
	fset_string_var(FORMAT_WHOIS_FOOTER_FSET, NULL);
	fset_string_var(FORMAT_XTERM_TITLE_FSET, NULL);
	fset_string_var(FORMAT_DCC_FSET, NULL);
	fset_string_var(FORMAT_NAMES_FOOTER_FSET, NULL);
	fset_string_var(FORMAT_NETSPLIT_HEADER_FSET, NULL);
	fset_string_var(FORMAT_TOPIC_CHANGE_HEADER_FSET, NULL);
	fset_string_var(FORMAT_USERS_BOT_FSET, NULL);
	fset_string_var(FORMAT_WHOLEFT_FOOTER_FSET, NULL);
	
}

int save_formats(FILE *outfile)
{
char thefile[BIG_BUFFER_SIZE+1];
char *p;
int i;
int count = 1;
	sprintf(thefile, "%s/%s.formats", get_string_var(CTOOLZ_DIR_VAR), version);
	p = expand_twiddle(thefile);
	outfile = fopen(p, "w");
	if (!outfile)
	{
		bitchsay("Cannot open file %s for saving!", thefile);
		new_free(&p);
		return 1;
	}
	for (i = 0; i < NUMBER_OF_FSET; i++)	
	{

		if (fset_array[i].string)
			fprintf(outfile, "FSET %s %s\n", fset_array[i].name, fset_array[i].string);
		else
			fprintf(outfile, "FSET -%s\n", fset_array[i].name);
		count++;
	}
	fclose(outfile);
	bitchsay("Saved %d formats to %s", count, thefile);
	new_free(&p);
	return 0;
}

void clear_fset(void)
{
int i;
	for (i = 0; i < NUMBER_OF_FSET; i++)	
	{

		if (fset_array[i].string)
			new_free(&fset_array[i].string);
	}
}

char *get_all_fset(void)
{
	int i;
	char *ret = NULL;
	for (i = 0; i < NUMBER_OF_FSET; i++)
		m_s3cat(&ret, space, fset_array[i].name);
	return ret;
}

char *get_fset(char *str)
{
	int i;
	char *ret = NULL;
	if (!str || !*str)
		return get_all_fset();
	for (i = 0; i < NUMBER_OF_FSET; i++)
		if (wild_match(str, fset_array[i].name))
			m_s3cat(&ret, space, fset_array[i].name);
	return ret ? ret : m_strdup(empty_string);
}

IrcVariable *fget_var_address(char *var_name)
{
	IrcVariable *var = NULL;
	int	cnt,
		msv_index;
	upper(var_name);
	if ((var = find_ext_fset_var(var_name)))
		return var;
	if ((find_fixed_array_item (fset_array, sizeof(IrcVariable), NUMBER_OF_FSET, var_name, &cnt, &msv_index) == NULL))
		return NULL;
	if (cnt >= 0)
		return NULL;
	return &fset_array[msv_index];
}

char	*make_fstring_var(char *var_name)
{
	IrcVariable *var = NULL;
	int	cnt,
		msv_index;
	char	*ret = NULL;

	upper(var_name);
	if ((var = find_ext_fset_var(var_name)))
		return m_strdup(var->string);

	if ((find_fixed_array_item (fset_array, sizeof(IrcVariable), NUMBER_OF_FSET, var_name, &cnt, &msv_index) == NULL))
		return NULL;
	if (cnt >= 0)
		return NULL;
	switch (fset_array[msv_index].type)
	{
		case STR_TYPE_VAR:
			ret = m_strdup(fset_array[msv_index].string);
			break;
		case INT_TYPE_VAR:
			ret = m_strdup(ltoa(fset_array[msv_index].integer));
			break;
		case BOOL_TYPE_VAR:
			ret = m_strdup(var_settings[fset_array[msv_index].integer]);
			break;
		case CHAR_TYPE_VAR:
			ret = m_dupchar(fset_array[msv_index].integer);
			break;
	}
	return ret;
}

#ifdef WANT_TCL
char *fset_rem_str(ClientData *cd, Tcl_Interp *intp, char *name1, char *name2, int flags)
{
char *s;
IrcVariable *n;
	n = (IrcVariable *)cd;
	if ((s = Tcl_GetVar(intp, name1, TCL_GLOBAL_ONLY)))
	{
		malloc_strcpy(&n->string, s);
	}
	return NULL;
}

void add_tcl_fset(Tcl_Interp *irp)
{
char varname[80];
int i = 0;
	for(i = 0; fset_array[i].name; i++)
	{
		int type_of = -1;
		switch(fset_array[i].type)
		{
			case INT_TYPE_VAR:
				type_of = TCL_LINK_INT;
				break;
			case STR_TYPE_VAR:
				type_of = TCL_LINK_STRING;
				break;
			case BOOL_TYPE_VAR:
				type_of = TCL_LINK_BOOLEAN;
				break;
			default:
				continue;
		}
		strcpy(varname, fset_array[i].name);
		lower(varname);
		Tcl_LinkVar(irp, varname, 
			(fset_array[i].type == STR_TYPE_VAR) ? 
				(char *)&fset_array[i].string : 
				(char *)&fset_array[i].integer,
			type_of);
		if (fset_array[i].type == STR_TYPE_VAR)
		{
			Tcl_TraceVar(irp, varname, TCL_TRACE_WRITES,
				(Tcl_VarTraceProc *)fset_rem_str, (ClientData)&fset_array[i]);
		}
	}
}
#endif
