#ifndef PARAM_DBASE_H
#define PARAM_DBASE_H

/* structure representing a single parameter entry, with a key and its value */
typedef struct 
{
    char* key;
    char* val;
} param_t;

/* structure containing a database of all parameter entries */
typedef struct 
{
    int num_param;
    int space_for_param;
    param_t *param;
} param_dbase_t;

/* prototypes */
void init_param_dbase(param_dbase_t* dbase);
void param_dbase_setval(param_dbase_t* dbase, const char* key, const char *val);
char* param_dbase_getval(const param_dbase_t* dbase, const char* key);
void clear_param_dbase(param_dbase_t* dbase);

#endif /* PARAM_DBASE_H */
