/* bookmark.h
 * 
 * Copyright (c) 1992-1998 by Mike Gleason.
 * All rights reserved.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 * 
 */

typedef struct Bookmark *BookmarkPtr;
typedef struct Bookmark {
	char				bookmarkName[16];
	char				name[64];
	char				user[64];	/* Leave room for user@host.name */
	char				pass[32];
	char				acct[16];
	char				dir[160];
	char				ldir[160];
	int				xferType;
	unsigned int			port;
	time_t				lastCall;
	int				hasSIZE;
	int				hasMDTM;
	int				hasPASV;
	int				isUnix;
	char				lastIP[32];
	char				comment[128];
	int				xferMode;
	int				hasUTIME;

	int				deleted;
} Bookmark;

#define kBookmarkVersion		8
#define kBookmarkMinVersion		3
#define kBookmarkFileName		"bookmarks"
#define kTmpBookmarkFileName		"bookmarks.tmp"
#define kOldBookmarkFileName		"hosts"
#define kBookmarkBupFileName		"bookmarks.old"

#define BMTINDEX(p) ((int) ((char *) p - (char *) gBookmarkTable) / sizeof(Bookmark))

/* bookmark.c */
void BookmarkToURL(BookmarkPtr, char *, size_t);
void SetBookmarkDefaults(BookmarkPtr);
int ParseHostLine(char *, BookmarkPtr);
void CloseBookmarkFile(FILE *);
FILE *OpenBookmarkFile(int *);
FILE *OpenTmpBookmarkFile(int);
int SaveBookmarkTable(void);
int GetNextBookmark(FILE *, Bookmark *);
int GetBookmark(const char *const, Bookmark *);
int PutBookmark(Bookmark *, int);
int LoadBookmarkTable(void);
BookmarkPtr SearchBookmarkTable(const char *);
void SortBookmarks(void);
void DefaultBookmarkName(char *, size_t, char *);
