/*  itstime.c is part of Statnet */
/* Statnet is protected under the GNU Public License (GPL2). */
/* Author: Jeroen Baekelandt (jeroenb@igwe.vub.ac.be)       */
/* 27DEC95: Scot E. Wilcoxon (sewilco@fieldday.mn.org)      */
/*  DISPDATA.C is part of NETWATCH  which like Statnet is under GPL2 */

#include "netwatch.h"
#include "curs.h"
#include <sys/time.h>
#ifdef OLDLINUX
#include <ncurses.h>
#else
#include <curses.h>
#endif
#include <signal.h>
#include <unistd.h>

#define MAXREFRESH 15
#define ROUTERSTATSMAX 60

extern int curskeyspot;
extern int curskeyval;
extern int cursllockout;
extern int cursrlockout;
extern int curslines;
extern int curshosttrim;
extern int cursproto;
extern int cursdest;

extern int scrmid;
extern struct itimerval oldtm, newtm;
extern int selecthost;
extern int numselect;
extern int selectside;
extern int selectchange;
extern int selectside;
extern char progtitle[60];
extern int ignoredomain;
extern int bluedie;
extern int selprob;
extern int selcode;

extern long int ethcnt;
extern int keycnt;
extern int probcnt;
extern int intrcnt;

#define MAGNABUFSIZE 4196
struct magrec
  {
    int len;
    char dir;
    unsigned char buf[MAGNABUFSIZE];
  };
#define MAGNAMAX 10
#define MAGNAOFFS 40
extern struct magrec magna[MAGNAMAX];
extern int magnacnt;
extern int magnaoffs;
extern char magnamatch[80];
extern HOSTINFO *magnaspot;
extern unsigned long int magnakey;
extern int magnaphys;
extern int magnafirst;
extern int magnafull;
extern HOSTINFO *magnacomhost;
extern unsigned long int magnacomkey;


void makeaddr (char naddr[], char ascii[]);

void 
cleancol (int col, int strow, int finrow)
{
  int i;

  for (i = strow; i <= finrow; i++)
    mvaddch (i, col, ' ');
}

void 
displaybuf (struct magrec b, int y, int x)
{
  int i, len;
  int scrmid = COLS / 2 - 8;
  char *p;

  if (magnafull)
    {
      scrmid = COLS - 8;
      x = 3;
    }
  len = b.len - magnaoffs + 1;
  p = &b.buf[magnaoffs];
  if (len > 0)
    {
      move (y, x);
      if (b.dir)
	{
	  attron (col1);
	  addch ('>');
	  attron (col4);
	}
      else
	{
	  attron (col2);
	  addch ('<');
	  attron (col4);
	}
      for (i = 0; i < len && i < scrmid; i++, p++)
	{
	  if (isprint (*p))
	    addch (*p);
	  else
	    addch ('.');
	}
    }
}

void
dispdata (int errnum)
{

  int xleft = 1;		/* Offset for Local Info */
  int xright;
  int y;
  static int refreshscr = 0;
  static int routerstats = 0;
  extern double maxburst;
  static time_t bursttime;
  static char burst[80];
  static time_t routertime;
  static unsigned long int oldrouteruse = 0;
  static unsigned long int oldrouterto = 0;
  static unsigned long int oldrouterfrom = 0;
  unsigned long int tfuse;
  unsigned long int ttuse;
  unsigned long int ttotal;
  static unsigned long int minfuse;
  static unsigned long int mintuse;
  static unsigned long int sec;
  static unsigned long int use;
  double fuse;
  extern unsigned long int routeruse;
  extern int bugfix;

  int lcnt = 0;
  int rcnt = 0;
  static char ttt[260];
  static char thost[60];
  static int statsonce = FALSE;
  static int disableburst = FALSE;
  int yact;
  unsigned char *pc;
  extern int help;
  extern int watch;
  extern int wai;
  extern int llockout;
  extern int rlockout;
  extern int lydisp;
  extern int rydisp;
  extern int localkey;
  extern int localupdate;
  extern int remoteupdate;
  extern int refreshloc;
  extern int refreshrem;
  extern int poschange;
  extern int disprouterstats;
  extern unsigned long routerto;
  extern unsigned long routerfrom;
  extern unsigned long routeruse;
  static unsigned long orouterto = 0;
  static unsigned long orouterfrom = 0;
  static unsigned long orouteruse = 0;
  unsigned long wrouteto, wroutefrom, wrouteuse;
  int localbypass = FALSE;
  int remotebypass = FALSE;
  time_t mnew;
  extern int dispopt;		/* TXRC IPPROTO OTHER */
  int updaterest = 0;
  int xoff;
  int ii, ij;
  time_t colred, colyel, colgreen, testt;
  extern HOSTINFO *lfirst;
  extern HOSTINFO *rfirst;
  HOSTINFO *current;

  mnew = time (0);
  localbypass = (!localkey && (watch || help));
  remotebypass = (localkey && (watch || help));
  colred = mnew - 60;		/* 1 min */
  colyel = mnew - 300;		/* 5 min */
  colgreen = mnew - 1800;	/* 30 min */
  scrmid = COLS / 2;
  xright = scrmid + 1;
  signal (SIGALRM, dispdata);
  newtm.it_value.tv_sec = 1;
  newtm.it_value.tv_usec = 0;
  setitimer (ITIMER_REAL, &newtm, &oldtm);	/* first screen update in 1 sec (exact) */

  if (rewrite_labels)
    {				/* if rewrite_labels */

      clrportion (1, 1, 4, COLS - 1);
      mvprintw (0, (COLS / 2) - 10, "%s", progtitle);
      mvprintw (1, COLS - (COLS) / 3, "REMOTE NETWORK");
      mvprintw (1, (COLS - 22) / 4, "LOCAL NETWORK");
      switch (dispopt)
	{
	case DISP_TX_RC:
	  mvprintw (2, (xright + 5), "HOST          (PKTS)     X      R");
	  mvprintw (2, (xleft + 5), "HOST          (PKTS)     X      R");
	  break;
	case DISP_IPPROTO:
	  mvprintw (2, (xright + 5), "HOST             IP      SERVICE");
	  mvprintw (2, (xleft + 5), "HOST             IP      SERVICE");
	  break;
	case DISP_DEST2:
	case DISP_DEST1:
	  mvprintw (2, (xright + 5), "HOST                TALKING TO");
	  mvprintw (2, (xleft + 5), "HOST                TALKING TO");
	  break;
	case DISP_ACCT:
	  mvprintw (2, (xright + 5), "HOST     (BYTES)    X          R ");
	  mvprintw (2, (xleft + 5), "HOST      (BYTES)    X          R ");
	  break;
	case DISP_INTTXRCP:
	  mvprintw (2, (xright + 5), "HOST      LOCAL PKTS     X      R");
	  mvprintw (2, (xleft + 5), "HOST      LOCAL PKTS     X      R");
	  break;
	case DISP_EXTTXRCP:
	  mvprintw (2, (xright + 5), "HOST       REM. PKTS     X      R");
	  mvprintw (2, (xleft + 5), "HOST       REM. PKTS     X      R");
	  break;
	case DISP_INTTXRC:
	  mvprintw (2, (xright + 5), "HOST    LOCAL BYTES X          R ");
	  mvprintw (2, (xleft + 5), "HOST    LOCAL BYTES  X          R ");
	  break;
	case DISP_EXTTXRC:
	  mvprintw (2, (xright + 5), "HOST    REM. BYTES  X          R ");
	  mvprintw (2, (xleft + 5), "HOST    REM. BYTES   X          R ");
	  break;
	}
      refresh ();
      rewrite_labels = 0;
    }
/*    if (selcode<0) */
/*    {
   mvprintw(LINES-1,2,"Routercnt#%4d Key:%3d",routerstats,keycnt); 
   }  */
/*      mvprintw(LINES-1,2,"Routerstats #%4d",routerstats); */
  mvprintw (LINES - 1, 60, " Eth:%8ld ", ethcnt);
/*      mvprintw(LINES-1,52,"INTR=%5d  PROBE=%5d",intrcnt,probcnt); */
  if (localkey)
    {
      attron (col2);
      mvprintw (1, 1, "KEY");
      attron (col4);
      mvprintw (1, curskeyval, "   ");
    }
  else
    {
      attron (col4);
      mvprintw (1, 1, "   ");
      attron (col2);
      mvprintw (1, curskeyval, "KEY");
      attron (col4);
    }
/*
   if (llockout)
   mvprintw (0, cursllockout, "LX");
   else
   {
   mvaddch (0, cursllockout, ACS_HLINE);
   addch (ACS_HLINE);
   }
   if (rlockout)
   mvprintw (0, cursrlockout, "RX");
   else
   {
   mvaddch (0, cursrlockout, ACS_HLINE);
   addch (ACS_HLINE);
   }
   if (poschange)
   mvprintw (0, curskeyspot, "P");
   else
   mvaddch (0, curskeyspot, ACS_HLINE);
 */
  mvprintw (0, curslines, "LINE %3d ", rydisp);
  mvprintw (0, 2, "LINE %3d ", lydisp);
/*  mvprintw (0, 12, "SEL = %3d ", selprob); */
  if (poschange)
    lcnt = 0;
  if (!routerstats)
    routertime = mnew;
  routerstats++;
  if (routerstats == ROUTERSTATSMAX)
    {
      statsonce++;
      sec = mnew - routertime;
      use = routeruse - oldrouteruse;
      mintuse = routerto - oldrouterto;
      minfuse = routerfrom - oldrouterfrom;
      routertime = mnew;
      oldrouteruse = routeruse;
      oldrouterto = routerto;
      oldrouterfrom = routerfrom;
      /* CALC STATS for ROUTER 
         use = # of bytes thru router in "sec" seconds
       */
      fuse = (double) (use >> 7) / sec;
/*      if (fuse > 1.0) */
      mvprintw (LINES - 1, scrmid - 15, " ROUTER %10.2g kbits/sec ", fuse);
/*      else
   mvprintw (LINES - 1, scrmid - 15, " ROUTER %10.2g bits/sec ", fuse *  ); */
      routerstats = 0;
    }
  xoff = 1;
  tfuse = routerfrom - orouterfrom;
  ttuse = routerto - orouterto;
  ttotal = tfuse + ttuse;
  fuse = (double) (ttotal >> 7);
  if (!disableburst && fuse > maxburst)
    {
      maxburst = fuse;
      bursttime = mnew;
      strcpy (burst, ctime (&bursttime));
      burst[strlen (burst) - 1] = 0;
    }
  if (disableburst)
    disableburst = FALSE;

  if (watch)
    {
      if (disprouterstats)
	{
	  if (localkey)
	    xoff = scrmid + 1;
	  mvprintw (6, xoff + 10, "ROUTER STATS BYTES");
	  mvprintw (8, xoff + 3, "Over 1 second period:");
	  mvprintw (13, xoff + 3, "Over 1 minute period:");
	  mvprintw (9, xoff + 3, " Incoming: %8lu", tfuse);
	  mvprintw (10, xoff + 3, " Outgoing: %8lu", ttuse);
	  mvprintw (11, xoff + 3, " Total:    %8lu", ttotal);
/*      if (fuse >= 1.0)  */
	  mvprintw (11, xoff + 22, "(%5.1f kbps)", fuse);
/*      else
   mvprintw (11, xoff + 22, "(%5.1f bps )", fuse * 1000); */

	  if (statsonce)
	    {
	      mvprintw (14, xoff + 3, " Incoming: %8lu", minfuse);
	      mvprintw (15, xoff + 3, " Outgoing: %8lu", mintuse);
	      mvprintw (16, xoff + 3, " Total:    %8lu", use);
	    }
	  else
	    mvprintw (15, xoff + 3, " N/A");
	  if (maxburst > 1.0)
	    {
	      mvprintw (18, xoff + 3, " MAX. BURST:    %5.1f kbps", maxburst);
	      mvprintw (19, xoff + 3, " at %s", burst);
	    }
	}
      else if (selecthost)
	{
	  if (magnafull)
	    {
	      xoff = 1;
	      clrportion (6, xoff + 3, LINES - 4, COLS - 3);
	    }
	  else
	    {
	      if (localkey)
		{
		  xoff = scrmid + 1;
		  clrportion (6, xoff + 3, LINES - 4, COLS - 3);
		}
	      else
		{
		  xoff = 1;
		  clrportion (6, xoff + 3, LINES - 4, scrmid - 3);
		}
	    }
	  mvprintw (6, xoff + 4, "TRACE %s", magnamatch);
	  mvprintw (7, xoff + 10, "Offset = %3d", magnaoffs);
	  if (magnafull)
	    {
	      if (magnacomhost == NULL)
		{
		  pc = (unsigned char *) magnaspot->othaddr;
		  mvprintw (7, xoff + 30, "Communicating with %u.%u.%u.%u",
			    pc[0], pc[1], pc[2], pc[3]);
		  mvprintw (6, xoff + 40, "SERVICES LOC %s",
			    magnaspot->servicename);
		}
	      else
		{
		  mvprintw (7, xoff + 30, "Communicating with %s",
			    magnacomhost->name);
		  mvprintw (6, xoff + 40, "SERVICES LOC %s  REM %s",
			 magnaspot->servicename, magnacomhost->servicename);
		}


	    }
	  for (ii = 0, ij = magnaphys; ii < MAGNAMAX; ii++)
	    {
	      displaybuf (magna[ij], 9 + ii, xoff + 2);
	      ij++;
	      if (ij == MAGNAMAX)
		ij = 0;
	    }

	}
    }
  orouterfrom = routerfrom;
  orouterto = routerto;
/*   if (wai == CURSESBUG)
   {
   ungetch (' ');
   disableburst = TRUE;
   }
   if (bugfix)
   {
   mvprintw (0, 60, "%c", ACS_HLINE);
   bugfix = FALSE;
   }
 */
  refreshscr++;
  if (refreshscr > MAXREFRESH)
    {
      poschange = 1;
      refreshscr = 0;
    }
  if (poschange)
    {
      refreshloc = refreshrem = TRUE;
    }
  if (bluedie == 1)
    {
      refreshloc = refreshrem = TRUE;
      bluedie += 2;
    }
  if (ignoredomain == 1)
    {
      refreshrem = TRUE;
      ignoredomain += 2;
    }
  if (magnafull)
    {
      localbypass = remotebypass = TRUE;
    }

  if (refreshloc && !localbypass)
    clrportion (4, 1, LINES - 1, scrmid);
  if (refreshrem && !remotebypass)
    clrportion (4, scrmid + 1, LINES - 1, COLS - 1);
  if (!magnafull && (selectchange || refreshloc || refreshrem))
    {
      cleancol (xright - 1, 4, LINES - 2);
      if (selectside)
	mvaddch (numselect + 4, xright - 1, ACS_LARROW);
      else
	mvaddch (numselect + 4, xright - 1, ACS_RARROW);
    }
  if (!localbypass && !llockout && (localupdate || refreshloc))
    {
      mvaddch (3, 0, ACS_VLINE);
      lcnt = 0;
      current = lfirst->flink;
      while (current != lfirst)
	{
	  y = lcnt;
	  if ((current->tstamp < colgreen && bluedie))
	    {
	      current = current->flink;
	      continue;
	    }
	  lcnt++;
	  yact = y - lydisp;
	  if (yact >= 0 && yact < LINES - 5)
	    {
	      yact += 4;
	      if (refreshloc || updaterest || current->update)
		{
		  strncpy (thost, current->name, curshosttrim);
		  if (selectchange && selecthost && numselect + 4 == yact)
		    {
		      magnakey = *((unsigned long *) current->addr);
		      strncpy (magnamatch, current->name, 80);
		      magnaspot = current;
		      magnacomhost = NULL;
		      magnacomkey = *((unsigned long *) current->othaddr);
		      magnafirst = TRUE;
		      selectchange = FALSE;
		    }
		  thost[curshosttrim] = 0;
		  testt = current->tstamp;
		  if (testt > colred)
		    attron (col1);
		  else if (testt > colyel)
		    attron (col2);
		  else if (testt > colgreen)
		    attron (col3);
		  else
		    attron (col4);
		  switch (dispopt)
		    {
		    case DISP_TX_RC:
		      sprintf (ttt, "%*s %6d %6d", -curshosttrim - 1, thost,
			       current->pktcntsend, current->pktcntrec);
		      break;
		    case DISP_INTTXRCP:
		      sprintf (ttt, "%*s %6d %6d", -curshosttrim - 1, thost,
			     current->intpktcntsend, current->intpktcntrec);
		      break;
		    case DISP_EXTTXRCP:
		      sprintf (ttt, "%*s %6d %6d", -curshosttrim - 1, thost,
			     current->extpktcntsend, current->extpktcntrec);
		      break;
		    case DISP_IPPROTO:
		      thost[cursproto] = 0;
		      sprintf (ttt, "%*s %8s %10s   ", -cursproto, thost,
			       current->ip_pr, current->servicename);
		      break;
		    case DISP_DEST1:
		      pc = (unsigned char *) current->othaddr;
		      thost[cursdest] = 0;
		      sprintf (ttt, "%*s %u.%u.%u.%u        ", -cursdest, thost,
			       pc[0], pc[1], pc[2], pc[3]);
		      break;
		    case DISP_DEST2:
		      pc = (unsigned char *) current->othaddr;
		      makeaddr (current->addr, thost);
		      thost[cursdest] = 0;
		      sprintf (ttt, "%*s %u.%u.%u.%u        ", -cursdest, thost,
			       pc[0], pc[1], pc[2], pc[3]);
		      break;
		    case DISP_ACCT:
		      thost[cursproto] = 0;
		      sprintf (ttt, "%*s %10lu %10lu", -cursproto, thost,
			       current->sendbytes, current->recbytes);
		      break;
		    case DISP_EXTTXRC:
		      thost[cursproto] = 0;
		      sprintf (ttt, "%*s %10lu %10lu", -cursproto, thost,
			       current->extsendbytes, current->extrecbytes);
		      break;
		    case DISP_INTTXRC:
		      thost[cursproto] = 0;
		      sprintf (ttt, "%*s %10lu %10lu", -cursproto, thost,
			       current->intsendbytes, current->intrecbytes);
		      break;
		    }
		  ttt[scrmid - 2] = 0;
		  mvprintw (yact, xleft, ttt);
		  attron (col4);
		  if (current->update)
		    {
		      if (current->update == 1)
			updaterest = 1;
		      current->update = 0;
		    }
		}
	    }
	  else
	    {
	      if (yact < 0)
		mvaddch (3, 0, ACS_UARROW);
	      else
		mvaddch (3, 0, ACS_DARROW);
	    }
	  current = current->flink;
	}

      localupdate = 0;
    }
  if (!remotebypass && !rlockout && (remoteupdate || refreshrem))
    {
/*   rcnt++;
   mvprintw(11,10,"%2d",rcnt);  */
      mvaddch (3, COLS - 1, ACS_VLINE);
      rcnt = 0;
      current = rfirst->flink;
      while (current != rfirst)
	{
/*              y = current->disprow; */
	  y = rcnt;
	  if ((current->tstamp < colgreen && bluedie) ||
	      (ignoredomain && !strcmp (current->servicename, "domain:")))
	    {
	      current = current->flink;
	      continue;
	    }
	  rcnt++;
	  yact = y - rydisp;
	  if (yact >= 0 && yact < LINES - 5)
	    {
	      yact += 4;
	      if (refreshrem || updaterest || current->update)
		{
		  strncpy (thost, current->name, curshosttrim);
		  if (selectchange && selecthost && numselect + 4 == yact)
		    {
		      magnakey = *((unsigned long *) current->addr);
		      strncpy (magnamatch, current->name, 80);
		      magnafirst = TRUE;
		      selectchange = FALSE;
		    }
		  thost[curshosttrim] = 0;
		  testt = current->tstamp;
		  if (testt > colred)
		    attron (col1);
		  else if (testt > colyel)
		    attron (col2);
		  else if (testt > colgreen)
		    attron (col3);
		  else
		    attron (col4);
		  switch (dispopt)
		    {
		    case DISP_TX_RC:
		    case DISP_INTTXRCP:
		    case DISP_EXTTXRCP:
		      sprintf (ttt, "%*s %6d %6d", -curshosttrim - 1, thost,
			       current->pktcntsend, current->pktcntrec);
		      break;
		    case DISP_IPPROTO:
		      thost[cursproto] = 0;
		      sprintf (ttt, "%*s %8s %10s   ", -cursproto, thost,
			       current->ip_pr, current->servicename);
		      break;
		    case DISP_DEST1:
		      pc = (unsigned char *) current->othaddr;
		      thost[cursdest] = 0;
		      sprintf (ttt, "%*s %u.%u.%u.%u        ", -cursdest, thost,
			       pc[0], pc[1], pc[2], pc[3]);
		      break;
		    case DISP_DEST2:
		      pc = (unsigned char *) current->othaddr;
		      makeaddr (current->addr, thost);
		      thost[cursdest] = 0;
		      sprintf (ttt, "%*s %u.%u.%u.%u        ", -cursdest, thost,
			       pc[0], pc[1], pc[2], pc[3]);
		      break;
		    case DISP_ACCT:
		    case DISP_EXTTXRC:
		    case DISP_INTTXRC:
		      thost[cursproto] = 0;
		      sprintf (ttt, "%*s %10lu %10lu", -cursproto, thost,
			       current->sendbytes, current->recbytes);
		      break;
		    }
		  ttt[scrmid - 2] = 0;
		  mvprintw (yact, xright, ttt);
		  attron (col4);
		  if (current->update)
		    {
		      if (current->update == 1)
			updaterest = 1;
		      current->update = 0;
		    }
		}
	    }
	  else
	    {
	      if (yact < 0)
		mvaddch (3, COLS - 1, ACS_UARROW);
	      else
		mvaddch (3, COLS - 1, ACS_DARROW);
	    }
	  current = current->flink;
	}
      remoteupdate = 0;
    }
  poschange = 0;
  refresh ();

}
