/*
  $Id: common.h,v 1.6 1996/08/21 16:34:42 luik Exp $

  common.h - common definitions for online mirror daemon package.
  Copyright (C) 1996, Andreas Luik, <luik@pharao.s.bawue.de>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef COMMON_H_INCLUDED
#define COMMON_H_INCLUDED

#ifdef HAVE_CONFIG_H		/* use <> instead of "" to ensure config.h is */
#include <config.h>		/* not searched for in the current directory */
#endif

#ifdef	__cplusplus
extern "C" {
#endif

#if !defined(__STDC__) && !defined(__cplusplus)
#define volatile /* as nothing */
#endif

#ifdef NEED_ALLOCA
/* AIX requires this to be the first thing in the file.  */
#ifdef __GNUC__
# define alloca __builtin_alloca
#else
# if HAVE_ALLOCA_H
#  include <alloca.h>
# else
#  ifdef _AIX
 #pragma alloca
#  else
#   ifndef alloca /* predefined by HP cc +Olibcalls */
void *alloca ();
#   endif
#  endif
# endif
#endif
#endif /* NEED_ALLOCA */

/* Since we need <string.h> nearly everywhere, we include it here
   unconditionally.  */
#if STDC_HEADERS
#include <string.h>
#define memzero(S,N)	memset((S), (N), 0)
#else /* !STDC_HEADERS */
#ifndef HAVE_STRCHR
#define strchr index
#define strrchr rindex
#endif
extern char *strchr();
extern char *strrchr();
#ifndef HAVE_MEMCPY
#define memcpy(D,S,N)	bcopy((S), (D), (N))
#define memmove(D,S,N)	bcopy((S), (D), (N))
#define memzero(S,N)	bzero((S), (N))
#endif /* !defined(HAVE_MEMCPY) */
#endif /* !STDC_HEADERS */
#define streq(A,B)	(strcmp(A, B) == 0)
#define strneq(A,B,N)	(strncmp(A, B, N) == 0)

/* Including <sys/time.h> and <time.h> the correct way is a bit
   difficult, therefore we do it here if NEED_TIME is defined.  */
#ifdef NEED_TIME
# if TIME_WITH_SYS_TIME
#  include <sys/time.h>
#  include <time.h>
# else /* !TIME_WITH_SYS_TIME */
#  if HAVE_SYS_TIME_H
#   include <sys/time.h>
#  else /* !HAVE_SYS_TIME_H */
#   include <time.h>
#  endif /* !HAVE_SYS_TIME_H */
# endif /* !TIME_WITH_SYS_TIME */
#endif /* defined(NEED_TIME) */


#if (__GNUC__ == 2 && __GNUC_MINOR__ >= 7) || (__GNUC__ > 2)
#define UNUSED__    __attribute__ ((__unused__))
#else
#define UNUSED__
#endif


#ifdef	__cplusplus
}
#endif

#endif /* defined(COMMON_H_INCLUDED) */
