/*
  $Id: cfnl.c,v 1.5 1997/01/16 21:00:50 luik Exp $

  cfnl.c - omirrd config file namelist handling.
  Copyright (C) 1996, Andreas Luik, <luik@pharao.s.bawue.de>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "common.h"

#if defined(RCSID) && !defined(lint)
static char rcsid[] UNUSED__ = "$Id: cfnl.c,v 1.5 1997/01/16 21:00:50 luik Exp $";
#endif /* defined(RCSID) && !defined(lint) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "error.h"
#include "cfnl.h"
#include "omirrd.h"


CfNameList cfAllocNameListEnt(char *name)
{
    CfNameList nl;

    nl = (CfNameList) malloc(sizeof(CfNameListRec));
    if (nl == NULL)
	fatal("ran out of memory\n");
    nl->n_name = name;
    nl->n_next = NULL;
    return(nl);
}

CfNameList cfAppendNameListEnt(CfNameList list, char *name)
{
    while (list->n_next)
	list = list->n_next;
    list->n_next = cfAllocNameListEnt(name);
    return(list->n_next);
}

void cfFreeNameListEnt(CfNameList list)
{
    free(list->n_name);
    free(list);
}

void cfFreeNameList(CfNameList list)
{
    CfNameList nl;

    while (list) {
	nl = list->n_next;
	cfFreeNameListEnt(list);
	list = nl;
    }
}

int cfMatchNameInList(char *name, CfNameList nl,
		      int (*compar)(char *path, const char *pattern),
		      char **targetnamep)
{
    int has_one_elem = (nl && nl->n_next == NULL);
    int result;
    char *cp;

    while (nl) {
	if ((*compar)(name, nl->n_name))
	    break;
	nl = nl->n_next;
    }
    result = (nl != NULL);
    if (result && targetnamep) {
	cp = nl->n_name;
	while ((cp = strchr(cp + 1, '/')))
	    name = strchr(name + 1, '/');
	if (has_one_elem)
	    name = strchr(name + 1, '/');
	if (name)
	    name++;
	*targetnamep = name;
    }
    return result;
}


#ifdef DEBUG
void cfDebugNameList(char *prefix, CfNameList nl)
{
    while (nl) {
	printf("%s%s\n", prefix, nl->n_name);
	nl = nl->n_next;
    }
}
#endif /* DEBUG */
