/*
  $Id: request.h,v 1.7 1997/01/16 15:04:20 luik Exp $

  template.c - template for omirrd C source file.
  Copyright (C) 1996-1997, Andreas Luik, <luik@pharao.s.bawue.de>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef REQUEST_H_INCLUDED
#define REQUEST_H_INCLUDED

#include <sys/types.h>

#ifdef	__cplusplus
extern "C" {
#endif

#include "iname.h"

/* ReqState specifies the different states of the ompath to pathname
   resolver.  The state is not explicitly saved but is implicitly
   determined from the values of the ReqPath structure using the
   following table (entries marked with an asterisk (*) are
   dynamically allocated):

   state			ompath	root_found	file	path
					|pwd_found
					|file_found
					|file != NULL
   ----------------------------------------------------------------------
   REQ_INCOMPLETE		!NULL*	0		NULL	NULL
   REQ_PROCESSING		!NULL*	1		?	NULL
   REQ_COMPLETE			!NULL*	1		!NULL	!NULL*
   REQ_ERROR			!NULL*	1		!NULL	""
*/

typedef enum ReqState_ {
    REQ_INCOMPLETE,
    REQ_PROCESSING,
    REQ_COMPLETE,
    REQ_ERROR
} ReqState;

typedef struct ReqPath_ {
    char *ompath;		/* ompath (malloc'ed) or NULL */
    unsigned int root_found:1;	/* does root_di contain dev/ino pair */
    unsigned int pwd_found:1;	/* does pwd_di contain dev/ino pair */
    unsigned int file_found:1;	/* does file_di contain dev/ino pair */
    DevInoRec root_di;		/* dev/ino pair of root directory */
    DevInoRec pwd_di;		/* dev/ino pair of pwd */
    DevInoRec file_di;		/* dev/ino pair of file */
    char *file;			/* pointer to file part of ompath */
    char *path;			/* resolved pathname (malloc'ed) or "" or NULL */
} *ReqPath, ReqPathRec;

typedef struct ReqRequest_ *ReqRequest;
typedef struct ReqQueue_ *ReqQueue;

typedef struct ReqRequest_ {
    ReqQueue queue;
    ReqRequest next;
    char op;			/* operation */
    char subop;			/* sub-operation */
    DevInoRec di;		/* dev/ino pair */
    ReqPathRec path;		/* pathname argument */
    ReqPathRec newpath;		/* 2nd pathname argument */
    char *s;			/* multi purpose string (malloc'ed) */
    int i1, i2;			/* multi purpose integer arguments */
    time_t timestamp;		/* kernel timestamp of request */
    int outfd;			/* output file descr for this request message */
} ReqRequestRec;

typedef struct ReqQueue_ {
    ReqRequest head;
    ReqRequest tail;
} ReqQueueRec;

/* request.c */
extern ReqQueue reqAllocQueue(void);
extern void reqFreeQueue(ReqQueue q);
extern ReqRequest reqAllocRequest(ReqQueue q);
extern ReqRequest reqGetFirstRequest(ReqQueue q);
extern ReqRequest reqGetNextRequest(ReqRequest r);
extern void reqDropFirstRequest(ReqQueue q);
extern void reqError(char *errmsg, char *line);
extern ReqRequest reqParseMessage(ReqQueue q, char *line);
extern ReqState reqFillRequest(ReqRequest r);
extern int reqProcessKernelRequest(ReqRequest r);
extern char *reqRequestToMessage(ReqRequest r);

#ifdef	__cplusplus
}
#endif

#endif /* !defined(REQUEST_H_INCLUDED) */

