# A person who can do *anything* in/to the moo, except execute arbitrary perl
# code.

package Wizard;
use strict;
use vars qw(@ISA);
use Db;
use Programmer;
use Verb;
use VerbCall;
use ThingList;
use Password;
use UNIVERSAL qw(isa);
@ISA=qw{Programmer};

sub new {
	my $proto = shift;
	my $class = ref($proto) || $proto;
	my $this  = Programmer::new($class,@_);
	bless ($this, $class);
	return $this;
}

# Set a given person's password.
sub verb_setpassword {
	my $this=shift;
	my $verbcall=shift;

	return Error->new("No way.") if ($this != ActiveUser::getactive);

	if ($verbcall->direct_object) {
		$verbcall->direct_object->password(Password::encrypt($verbcall->word('indirect_object')));
		return "Password set.";
	}
	else {
		return Error->new("Need to specify a person.");
	}
}

# Allows a Wizard to broadcast to everyone on the MOO
sub verb_shout {
	my $this = shift;
	my $verbcall = shift;
	
	return Error->new("No way.") if ($this != ActiveUser::getactive);

	my $text = $verbcall->command;
	$text=~s/^\s*\w+\s+//; # remove command.
	my $name = $verbcall->caller->name;

	foreach (ThingList::FindByType("Person")) {
		if($_ && $_->connected && !($_==$verbcall->caller)) {
			$_->tell("$name shouts, \"$text\"");
		}
	}
	return "You shout, \"$text\"";
}

# Like audit, but lists everything in the whole moo.
sub verb_listall {
	my $this=shift;
	my $verbcall=shift;

	return Error->new("No way.") if ($this != ActiveUser::getactive);

	my $thing;
	my @list;
	my ($locname, $locnum, $ownname, $ownnum);
	my (%thingsbyid, $keyvalue);
	
	foreach $thing (ThingList::All) {
		$thingsbyid{$keyvalue++} = [$thing, $thing->id];
	}

	foreach (sort { $thingsbyid{$a}->[1] <=> $thingsbyid{$b}->[1] } keys(%thingsbyid)) {
		$thing = $thingsbyid{$_}->[0];
		if ($thing->location) {
			$locname=$thing->location->name;
			$locnum="(#".$thing->location->id.")";
		}
		else {
			$locname="<nowhere>";
			$locnum="";
		}
		if ($thing->owner) {
			$ownname=$thing->owner->name;
			$ownnum="(#".$thing->owner->id.")";
		}
		else {
			$ownname="<none>";
			$ownnum="";
		}
		push @list, [ref($thing), "#".$thing->id, $thing->name, $ownname, $ownnum, $locname, $locnum];
	}

	return Text::tablemaker("The whole moo",
		["TYPE", "ID", "NAME", "OWNER","","LOCATION",""],
		@list,
	);	
}

sub verb_dumpdb {
	my $this=shift;
	my $verbcall=shift;

	return Error->new("No way.") if ($this != ActiveUser::getactive);

	my $ret=Db::DumpDb('requested by wizard #'.$this->id);
	if (! $ret) {
		return Error->new("Database dump not preformed - another is already in progress.");
	}
	else {
		return "Now dumping database in background.";
	}
}

1
