#!/usr/bin/perl
# This defines a core db.
# TODO: file too long. Split?

# The id numbers assigned to objects in this file are important historically.
# do _not_ change!

use Method;
use Verb;
use Db;
use Thing;
use Room;
use LoginRoom;
use GuestAllocator;
use Wizard;
use Exit;
use Generics;
use HelpObject;

# Set up the generic thing, parent of all others.
$gen_thing=Thing->new(
	id => 1,
	name => "generic thing",
	description => "Looks uninteresting",
	fertile => 1,
	take_msg => "You pick up \$name.",
	take_fail_msg => "You can't pick that up.",
	drop_msg => "You drop \$name.",
);
$gen_thing->addverb(Verb->new(
	sub => 'verb_describe',
	command => 'describe',
	direct_object => 'this',
	preposition => 'any',
	indirect_object => 'any',
));
$gen_thing->addhelp('describe',
	"Changes the description of an object.",
	"Syntax: describe <object> as \"<text>\"",
	"",
	"The description is what a user sees when they look at the object.",
);	
$gen_thing->addverb(Verb->new(
	sub => 'verb_rename',
	command => 'rename',
	direct_object => 'this',
	preposition => 'any',
	indirect_object => 'any',
));
$gen_thing->addhelp('rename',
	"Change the name of an object, and optionally set aliases for it.",
	"Syntax: rename <object> to <name>[,<aliases>]",
	"",
	"The optional list of aliases is a comma-seperated list of other names that can be used for the object.",
);	
$gen_thing->addverb(Verb->new(
	sub => 'verb_help',
	command => 'help',
	direct_object => 'this',
	preposition => 'any',
	indirect_object => 'any',
));
$gen_thing->addhelp('help',
	"Outputs help on a given command.",
	"Syntax: help <topic>",
	"        help <object> <topic>",
	"",
	"The first syntax queries a variety of objects to see if any can give you help on the specified topic.",
	"",
	"The second syntax asks a specific object to show its help text on the topic.",
);
$gen_thing->perms_r('perms_r',1);
$gen_thing->perms_r('perms_w',1);
$gen_thing->perms_r('parent',1);
$gen_thing->perms_r('id',1);
$gen_thing->perms_r('name',1);
$gen_thing->perms_r('home',1);
$gen_thing->perms_r('aliases',1);
$gen_thing->perms_r('location',1);
$gen_thing->perms_w('location',1); # is this safe?
$gen_thing->perms_r('description',1);
$gen_thing->perms_r('owner',1);
$gen_thing->perms_r('take_msg',1);
$gen_thing->perms_r('take_fail_msg',1);
$gen_thing->perms_r('drop_msg',1);
$gen_thing->perms_r('verbs',1);
$gen_thing->perms_r('fertile',1);
$gen_thing->perms_r('methods',1);
$gen_thing->perms_r('help',1);
$gen_thing->perms_r('commandaliases',1);

$gen_container=Container->new(
	id => 2,
	parent => $gen_thing,
	name => "generic container",
	empty_msg => "It is empty.",
	filled_msg => "The \$name contains:\n\t\$list.",
	put_msg => "You put \$thing in \$name.",
);

$gen_container->contents([]);
$gen_container->perms_r('contents',1);
$gen_container->perms_w('contents',1);
$gen_container->perms_r('empty_msg',1);
$gen_container->perms_r('filled_msg',1);
$gen_container->perms_r('put_msg',1);

$gen_person=Person->new(
	id => 3,
	parent => $gen_container,
	name => "generic person",
	empty_msg => "",
	filled_msg => "Carrying:\n\t\$list",
	output_callback => sub {},
	close_callback => sub {},
	question_callback => '',
	description => "Someone who should describe themselves with \"describe me as ...\"",
	connected => '',
	fertile => '',
	host => '',
	lastlogin => '',
	lastactive => '',
	commandaliases => {
		'"' => 'say ',
		':' => 'emote ',
		"'" => 'whisper ',
		'-' => 'sayto ',
	}
);
$gen_person->perms_r('connected',1);
$gen_person->perms_r('host',1);
$gen_person->perms_r('lastlogin',1);
$gen_person->perms_r('lastactive',1);
$gen_person->perms_r('output_callback',1); # needed to other people can call tell on a person.
$gen_person->addverb(Verb->new(
	sub => 'verb_get',
	command => 'g*et',
	direct_object => 'any',
	preposition => 'any',
	indirect_object => 'any',
));
$gen_person->addhelp('get take',
	"Pick up an object.",
	"Syntax: get <object>",
	"        take <object>",
	"        get <object> from <container>",
	"        take <object> from <container>",
	"",
	"The first two forms pick up the named object and place it in your inventory.".
	"",
	"The remaining forms move the named object from inside the named container into your inventory.",
	"",
	"Note that you can use 'all' as the object to get all objects.",
);
$gen_person->addverb(Verb->new(
	sub => 'verb_get',
	command => 't*ake',
	direct_object => 'any',
	preposition => 'any',
	indirect_object => 'any',
));
# Help above.
$gen_person->addverb(Verb->new(
	sub => 'verb_drop',
	command => 'd*rop',
	direct_object => 'any',
));
$gen_person->addhelp('drop',
	"Drop an object",
	"Syntax: drop <object>",
	"",
	"This removes an object you are carrying from your inventory and puts it in your current room.",
	"You can use 'drop all' to drop every object you are holding.",
);
$gen_person->addverb(Verb->new(
	sub => 'verb_put',
	command => 'p*ut',
	direct_object => 'any',
	preposition => 'any',
	indirect_object => 'any',
));
$gen_person->addhelp('put move',
	"Change the location of an object.",
	"Syntax: put <object> in <container>",
	"        move <object> to <container>",
	"",
	"Move the object into the container. Note that people and rooms are valid containers. This can also be useful for teleporting yourself and other objects around.",
);	
$gen_person->addverb(Verb->new(
	sub => 'verb_put',
	command => 'mo*ve',
	direct_object => 'any',
	preposition => 'any',
	indirect_object => 'any',
));
$gen_person->addverb(Verb->new(
	sub => 'verb_put',
	command => 'give',
	direct_object => 'any',
	preposition => 'any',
	indirect_object => 'any',
));	
# Help above.
$gen_person->addverb(Verb->new(
	sub => 'verb_inventory',
	command => 'i'
));
$gen_person->addverb(Verb->new(
	sub => 'verb_inventory',
	command => 'inv*entory'
));
$gen_person->addhelp('inventory',
	"Show what you're carrying",
	"Syntax: inventory",
	"        i",
	"",
	"This prints a list of every object you are carrying.",
);
$gen_person->addverb(Verb->new(
	sub => 'verb_home',
	command => 'home',
));
$gen_person->addhelp('home',
	"Teleport home",
	"Syntax: home",
	"",
	"Instantly teleports you to your designated home room.",
	"You can change your designated home; see 'help sethome' for details.",
);
$gen_person->addverb(Verb->new(
	sub => 'verb_sethome',
	command => 'sethome',
));
$gen_person->addhelp('sethome',
	"Set your designated home",
	"Syntax: sethome",
	"",
	"Sets your designated home (see help home') to be the room you're in now. Note that this is also the room you will appear in when you log on.",
);
$gen_person->addverb(Verb->new(
	sub => 'verb_password',
	command => 'password',
	direct_object => 'any',
	preposition => 'any',
));
$gen_person->addhelp('password',
	"Change your password",
	"Syntax: password <old-password> <new-password>",
	"",
	"Changes your password (as typed in the 'connect' command when you log in) to <new-password>. For security reasons, you are required to type your current (soon to be old) password as the first argument.",
	"",
	"Your password is stored in an encrypted form in the moo database; in principle, not even the wizards can tell what it is, though they can change it, of course. It is recommended that your password not be your name or a common word; passwords have been stolen or cracked in the past. Your password is your security; choose a safe one.",
);
$gen_person->addverb(Verb->new(
	sub => 'verb_chown',
	command => 'chown',
	direct_object => 'any',
	preposition => 'any',
	indirect_object => 'any',
));
$gen_person->addhelp('chown',
	"Changes the ownership of the specified object",
	"Syntax: chown <object> to <person>",
	"",
	"Each object in the moo has an owner - a person who can modify the object and see all its properties. The chown command changes the owner of an object.",
);	
$gen_person->addverb(Verb->new(
	sub => 'verb_logout',
	command => 'logout',
));
$gen_person->addverb(Verb->new(
	sub => 'verb_logout',
	command => 'quit',
));
$gen_person->addhelp('logout quit',
	"Disconnect from the moo.",
	"Syntax: logout",
	"        quit",
	"",
	"This breaks your network connection and leaves your character sleeping.",
);
$gen_person->addverb(Verb->new(
	sub => 'verb_who',
	command => 'who',
));
$gen_person->addhelp('who',
	"List logged in users.",
	"Syntax: who",
	"",
	"This lists all connected users, along with how long they have been connected, how long they have been idle, and where they are currently in the moo.",
);	
$gen_person->addverb(Verb->new(
	sub => 'verb_lastlog',
	command => 'lastlog',
));
$gen_person->addhelp('lastlog',
	"Show recent logins to the moo.",
	"Syntax: lastlog",
	"",
	"This lists all people who have logged into the moo, with those who have logged in most recently first. It tells when they last logged in, if they are currently connected, and what host theylogged on from.",
);
$gen_person->addverb(Verb->new(
	sub => 'verb_audit',
	command => 'audit',
	direct_object => 'any'
));
$gen_person->addhelp('audit',
	"List all the objects you or someone else owns",
	"Syntax: audit",
	"        audit <person>",
	"",
	"The first form lists all objects you own. The second lists all objects someone else owns.",
);	
$gen_person->addverb(Verb->new(
	sub => 'verb_whisper',
	command => 'whisper',
	direct_object => 'any',
	preposition => 'any',
	indirect_object => 'any'
));
$gen_person->addhelp('whisper',
	"Send someone a private message",
	"Syntax: whisper \"<text>\" to <person>",
	"",
	"Sends <text> to the specified person, so that noone elase can see it.",
);	
$gen_person->addverb(Verb->new(
	sub => 'verb_delete',
	command => 'delete',
	direct_object => 'any',
));
$gen_person->addhelp('delete',
	"Remove an object from the moo",
	"Syntax: delete <object>",
	"",
	"Destroys the indicated object utterly and irretrievably. Naturally, you may only do this to objects that you own (unless you are a wizard).",
);
$gen_person->addverb(Verb->new(
	sub => 'verb_page',
	command => 'page',
	direct_object => 'any',
	preposition => 'any',
	indirect_object => 'any',
));
$gen_person->addhelp('page',
	"Send a message to a person",
	"Syntax: page <person> [[with] <text>]",
	"",
	"Sends a message to the person, no matter where they are in the moo. If <text> is omitted, the person will just be informed you have paged them.",
);
$gen_person->addverb(Verb->new(
        sub => 'verb_sayto',
	command => 'sayto',
	direct_object => 'any',
	preposition => 'any',
	indirect_object => 'any',
));
$gen_person->addhelp('sayto',
	"Say something directed to a specific person",
	"Syntax: sayto <person> <message> ...",
	"        -<person> <message> ...",
	"",
	"This is like 'say' ('help say'), in that it makes you say something that can be heard by everyone in the same location as you. The difference is that what you say with this command is directed to a specific person in the room. This is especially useful in a crowded room with many conversations going on at once, or when you need to get someone's attention.",
);
$gen_person->addverb(Verb->new(
	sub => 'verb_uptime',
	command => 'uptime',
));
$gen_person->addhelp('uptime',
	"Show how long the moo has been running",
	"Syntax: uptime",
	"",
	"This simply shows you how long the moo has been running.",
);	
$gen_person->addverb(Verb->new(
	sub => 'verb_version',
	command => 'version',
));
$gen_person->addhelp('version',
	"Show moo version number",
	"Syntax: version",
	"",
	"This shows the version number of perlmoo that is running this moo, along with the version of perl it is running under.",
);

$gen_room=Room->new(
	id => 4,
	parent => $gen_container,
	name => "generic room",
	empty_msg => "",
	filled_msg => "You see \$list here.",
	exit_msg => "\$name to \$roomname.\n",
);
$gen_room->perms_r('exit_msg',1);
$gen_room->addverb(Verb->new(
	sub => 'verb_look',
	command => 'l*ook',
	direct_object => 'any',
	preposition => 'any',
	indirect_object => 'any',
));
$gen_room->addhelp('look',
	"Look at an object.",
	"Syntax: look",
	"        look <object>",
	"        look <object> in <container>",
	"",
	"The first form, with no arguments, shows you the name and description of the room you're in, along with a list of the other objects that are there.",
	"",
	"The second form, lets you look at a specific object. Most objects have descriptions that may be read this way. You can look at your own description using 'look me'. You can set the description for an object or room, including yourself, with the 'describe' command (see 'help describe').",
	"",
	"The third form shows you the description of an object that is inside some other object, including objects being carried by another person.",
);
$gen_room->addverb(Verb->new(sub => 'verb_exits', command => 'exits'));
$gen_person->addhelp('exits',
	"List exits in a room",
	"Syntax: exits",
	"",
	"Prints a list of all exits from a room.",
);
$gen_room->addverb(Verb->new(
	sub => 'verb_say',
	command => 'say',
	direct_object => 'any',
	preposition => 'any',
	indirect_object => 'any',
));
$gen_room->addhelp('say',
	"Say something to people in the room",
	"Syntax: say <text> ...",
	"        \"<text> ...",
	"",
	"Says <anything> out loud, so that everyone in the same room hears it. This is used so often that there is a special abbreviation for it - any command line starting with a double quote is treated as a 'say' command.",
);	
$gen_room->addverb(Verb->new(
	sub => 'verb_emote',
	command => 'emote',
	direct_object => 'any',
	preposition => 'any',
	indirect_object => 'any',
));
$gen_room->addhelp('emote',
	"Non-verbal communication with others in the room",
	"Syntax: emote <anything> ...",
	"        :<anything> ...",
	"        ::<anything> ...",
	"",
	"Announces <anything> to everyone in the same room, prepending your name. This is commonly used for various forms of non-verbal communication. In fact, it is so commonly used that there's a special abbreviation for it: any command line starting with ':' is treated as an 'emote' command.",
	"",
	"The alternate form, '::' (less commonly 'emote :'), does not insert the space between your name and the text.",
);	
$gen_room->addverb(Verb->new(
	sub => 'verb_look',
	command => 'l*ook',
	direct_object => 'any',
	preposition => 'any',
	indirect_object => 'any',
));
$gen_room->addverb(Verb->new(
	sub => 'verb_help',
	command => 'help',
	direct_object => 'any',
));
$gen_room->addverb(Verb->new(
	sub => 'verb_go',
	command => 'go',
	direct_object => 'any',
	preposition => 'any',
	indirect_object => 'any'
));
$gen_room->addhelp('go',
	"Move from room to room",
	"Syntax: go <exit> ..",
	"",
	"Goes to the named exits in the named order. If multiple exits are specified, you will move through multiple rooms in a single command.",
);	
$gen_room->exits([]);
$gen_room->perms_r('exits',1);
$gen_room->perms_w('exits',1);

$gen_exit=Exit->new(
	id => 5,
	parent => $gen_thing,
	name => "generic exit",
	
	destination => undef,
	message => "",
);
$gen_exit->addverb(Verb->new(
	sub => 'verb_go',
	command => 'go',
	direct_object => 'this',
	preposition => 'any',
	indirect_object => 'any',
));
$gen_exit->perms_r('destination',1);
$gen_exit->perms_r('message',1);
$gen_exit->perms_w('location',1);

$gen_builder=Builder->new(
	id => 6,
	parent => $gen_person,
	name => "generic builder",
);
$gen_builder->addverb(Verb->new(
	sub => 'verb_create',
	command => 'cre*ate',
	direct_object => 'any',
	preposition => 'any',
	indirect_object => 'any',
));
$gen_builder->addhelp('create',
	"Make a new object",
	"Syntax: create <parent> named <name>[,<aliases>]",
	"",
	"This is the main command for creating objects other than rooms and exits (for them, see 'help dig'; it's much more convenient).",
	"",
	"The first argument specifies the 'parent' of the new object: loosely speaking, the 'kind' of object you're creating. The new object will start out looking like an exact copy of its parent, except it will have a different id number and a different name and aliases. You can use another object you can see as the parent, or you can use one of the generic objects (\$thing, \$container, etc).",
	"",
	"This command may only be used by builders.",
);	
$gen_builder->addverb(Verb->new(
	sub => 'verb_dig',
	command => 'dig',
	direct_object => 'any',
	preposition => 'any',
	indirect_object => 'any',
));
$gen_builder->addhelp('dig',
	"Conveniently build new rooms and exits",
	"Syntax: dig \"<new-room-name>\"",
	"        dig <exit-spec> to \"<new-room-name>\"",
	"        dig <exit-spec> to \"<old-room>\"",
	"",
	"This is the basic building tool. It's much easier to make rooms and exits this way rather than with plain old 'create'.",
	"",
	"First a word about topology. A room is any place a person can be. Rooms are connected by exits - an exit simply allows you to go from one room to another. Exits often, but not always come in pairs, so you can go back to whence you came.",
	"",
	"The first form of the command creates a new room with the given name. The new room is not connected to anywhere else; it is floating in limbo. The 'dig' command tells you its object number, though, so you can use the 'move' command to get there easily.",
	"",
	"The second form of the command not only creates the room, but one or two exits linking your current location to (and possibly from) the new room. An <exit-spec> has one of these formats:",
	"\t<fromname>",
	"\t<fromname>|<toname>",
	"The first format is used when you only want to create an exit out of the current room to the new room. The second format is used if you want to also create an exit back from the new from to the current room. The exit names can optionally be follwoed by a comma and a list of aliases for that exit, separated by commas.",
	"",
	"The third form of the dig command is just like the second form except that no new room is created; you instead specify (typically by object id number) the other room to/from which the new exits will connect.",
	"",
	"This command may only be used by builders.",
);
$gen_builder->addverb(Verb->new(
	sub => 'verb_show',
	command => 'show',
	direct_object => 'any',

));	
$gen_builder->addhelp('show',
	"Show an object's properties",
	"Syntax: show <object>",
	"",
	"This prints out a comprehensive list of all of the object's properties.",
	"",
	"This command may only be used by builders.",
);

$gen_programmer=Programmer->new(
	id => 7,
	parent => $gen_builder,
	name=> "generic programmer",
);
# Add eval alias.
my %commandaliases=%{$gen_programmer->commandaliases};
$commandaliases{';'}="eval ";
$gen_programmer->commandaliases(\%commandaliases);
$gen_programmer->addverb(Verb->new(
	sub => 'verb_eval',
	command => 'eval',
	direct_object => 'any',
	preposition => 'any',
	indirect_object => 'any',
));
$gen_programmer->addhelp('eval',
	"Immediatly execute perl code",
	"Syntax: eval <perl-code>",
	"        ;<perl-code>",
	"",
	"The perl code is immediatly evaluated in a perl Safe. This prevents you from doing some malicious or accidental things that could mess up the moo. The value the code returns is shown to you. You can use \$me to refer to yourself, and \$location is your current location. These variables are objects, you can examine their properties, for example, this prints out your current name:",
	"\t;\$me->name",
	"and this changes it:",
	"\t;\$me->name('fred')",
	"",
	"This command may only be used by programmers.",
);
$gen_programmer->addverb(Verb->new(
	sub => 'verb_teach',
	command => 'teach',
	direct_object => 'any',
	preposition => 'any',
	indirect_object => 'any',
));
$gen_programmer->addhelp('teach',
	"Add a verb to an object",
	"Syntax: teach <object> to <command> [<direct-object> [<preposition> [<indirect-object>]]]",
	"",
	"This command defines a new verb on an object, and specifies what arguments the verb takes.",
	"<command> is the command the user types to activate the verb. If '*' appears somewhere in a command, the remainder of that command is optional. If '*' appears at the end of a command, the user can add any text to the end.",
	"The <direct-object>, <preposition> and <indirect-object> combine to specify what parameters the verb takes. If parameters that don't match the specification are passed to the verb, the verb won't be ran at all. In general, any word you specify must be entered by the user for the verb to be run. The following words are special for the direct object and indirect object:",
	"\tthis - must be current object",
	"\tany  - anything is allowed, including nothing",
	"\tnone - nothing is allowed",
	"",
	"The <preposition> can use 'any' and 'none' to mean similar things. If any of the 3 parameters is omitted, 'none' is assummed to be the value of those parameters.",
	"",
	"See also the 'verbcode' command ('help verbcode').",
	"",
	"This command may only be used by programmers.",
);
$gen_programmer->addverb(Verb->new(
	sub => 'verb_verbcode',
	command => 'verbcode',
	direct_object => 'any',
	preposition => 'any',
	indirect_object => 'any',
));
$gen_programmer->addhelp('verbcode',
	"Add/change code that is executed for a verb",
	"Syntax: verbcode <object> <command> \"<code>\"",
	"",
	"The object and command specify which verb this code is linked to. The code is perl code, that is run inside a subroutine, inside a perl Safe when the verb is called. Anything the code returns is displayed to the user. The subrouting the code runs is is passed at least 2 parameters - the first is the object that contains the verb. The second is a VerbCall, which lets you see what parameters the user entered.)",
	"",
	"See also the 'teach' command ('help teach').",
	"",
	"This command may only be used by programmers.",
);	
$gen_programmer->addverb(Verb->new(
	sub => 'verb_code',
	command => 'code',
	direct_object => 'any',
	preposition => 'any',
	indirect_object => 'any',
));
$gen_programmer->addhelp('code',
	"Add/change code that is executed for a method",
	"Syntax: code <object> <method> \"<code>\"",
	"",
	"This is similar to verbcode, except you arn't limited to writing verbs, you can write other methods on an object as well (and override things like the 'tell' method). See verbcode ('help verbcode') for details.",
	"",
	"Note that this command can be used to do everything verbcode can do, you just need to prefix the name of the verb with 'verb_'.",
	"",
	"This command may only be used by programers.",
);
$gen_programmer->addverb(Verb->new(
	sub => 'verb_codedel',
	command => 'codedel',
	direct_object => 'any',
	preposition => 'any',
));
$gen_programmer->addhelp('codedel',
	"Remove a method from an object",
	"Syntax: codedel <object> <method>",
	"",
	"This removes the method from the specified object.",
	"",
	"This command may only be used by programmers.",
);
$gen_programmer->addverb(Verb->new(
	sub => 'verb_verbdel',
	command => 'verbdel',
	direct_object => 'any',
	preposition => 'any',
));
$gen_programmer->addhelp('verbdel',
	"Remove a verb from an object",
	"Syntax: verbdel <object> <verb>",
	"",
	"This removes the specified verb from the specified object. The code for running the verb is removed, and so is the verb definition.",
	"",
	"This command may only be used by programmers.",
);

$wizard=Wizard->new(
	id => 8,
	parent => $gen_programmer,
	name => "Wizard",
	description => "An all powerful wizard.",
);
$wizard->addverb(Verb->new(
	sub => 'verb_setpassword',
	command => 'setpassword',
	direct_object => 'any',
	preposition => 'any',
	indirect_object => 'any',
));
$wizard->addhelp('setpassword',
	"Set a person's password",
	"Syntax: setpassword <person> to <password>",
	"",
	"This command sets the password of a person in the moo. This can be useful when adding a new user, or when a user has forgotten their password.",
	"",
	"This command may only be used by wizards.",
);	
$wizard->addverb(Verb->new(
	sub => 'verb_shout',
	command => 'shout',
	direct_object => 'any',
	preposition => 'any',
	indirect_object => 'any',
));
$wizard->addhelp('shout',
	"Broadcast the text to every user in the moo.",
	"Syntax: shout <text> ...",
	"",
	"This displays the specified text to every user of the moo.",
	"",
	"This command may only be used by wizards.",
);	
$wizard->addverb(Verb->new(
	sub => 'verb_listall',
	command => 'listall',
));
$wizard->addhelp('listall',
	"List all objects in the moo",
	"Syntax: listall",
	"",
	"Listall is like the 'audit' command ('help audit'), except it lists every single object in the whole moo.",
	"",
	"This command may only be used by wizards.",
);
$wizard->addverb(Verb->new(
	sub => 'verb_dumpdb',
	command => 'dumpdb',
));
$wizard->addhelp('dumpdb',
	"Save the current moo db",
	"Syntax: dumpdb",
	"",
	"This command makes the moo immediatly dump out the database. If a database dump is already in progress, it will have no effect.",
);

$helpobject=HelpObject->new(
	id => 13,
	parent => $gen_thing,
	name => 'generic help object',
);
$helpobject->addhelp('index',
	"Help is available on the following general topics:",
	"",
	"introduction  -- The basics of perlmoo and what's going on here.",
	"",
	"self          -- Setting characteristics of yourself.",
	"movement      -- Moving between rooms.",
	"communication -- Communicating with other users.",
	"manipulation  -- Moving or using other objects.",
	"miscellaneous -- Commands that don't fit anywhere else.",
	"",
	"building      -- Extending and modifying the moo.",
	"programming   -- Adding code to the moo.",
	"wizindex      -- Wizardly topics",
	"",
	"Type 'help <topic>' for information on a particular topic.",
);
$helpobject->addhelp('introduction',
	"Perlmoo is a kind of virtual reality, in which people move about from place to place manipulating their environment in what we hope are amusing, entertaining, or enlightening ways.",
	"",
	"Perlmoo is more of a pastime than a game in the usual sense; there is no score kept, there are no specific goals to attain in general, and there's no competition involved. Perlmoo participants explore the virtual world, talk to the other participants, try out the weird gadgets that others have built, and create new places and things for others to encounter and enjoy.",
	"",
	"Most commands have the form of simple English sentences:",
	"\t<verb>",
	"\t<verb> <direct object>",
	"\t<verb> <direct object> <preposition> <indirect object>",
	"Don't use English articles (e.g. 'a', 'an', or 'the') in your commands; Perlmoo won't understand them. You can refer to yourself as 'me' and the room you're in as 'here'. You can use 'it' to refer to the last object you referred to. Commands can often be shortened, for example, you can use 'inv' as a shorthand for 'inventory'. You can also shorten the names of objects you refer to.",
	"",
	"The first five things you'll want to know are listed below. Type 'help <thing>' for details on any of them:",
	"",
	"look     -- getting a description of the current room or any other object",
	"say      -- speaking to the other people in the same room as you",
	"who      -- showing which people are currently connected to Perlmoo",
	"movement -- how to move around in Perlmoo, from room to room",
	"quit     -- disconnecting from Perlmoo",
);
$helpobject->addhelp('self',
	"There are a number of commands for modifying various characteristics of the object representing you in Perlmoo. Help on them is available in the following topics:",
	"",
	"describe -- setting what others see when they look at you",
	"password -- changing your password",
	"sethome  -- changing your designated home room",
	"rename   -- changing your name and/or aliases",
);	
$helpobject->addhelp('movement',
	"The descriptions of most rooms outline the directions in which exits exist. Typical directions include the eight compass points ('north', 'south', 'east', 'west', 'northeast', 'southeast', 'northwest', and 'southwest'), 'up', 'down', and 'out'. You can sometimes use the 'exits' command (see 'help exits') to view the exits from a room.",
	"",
	"To go in a particular direction, simply type the name of that direction (e.g, 'north', 'up').  The name of the direction can usually be abbreviated to one or two characters (e.g., 'n', 'sw').  You can also type 'go <direction>' to move; this is particularly useful if you know you're going to type several movement commands in a row (see 'help go').",
	"",
	"You can also use the 'home' command to teleport you to your designated home (see 'help home' for more details).",
);
$helpobject->addhelp('communication',
	"There are several commands available to allow you to communicate with others in the moo. Help is available on the following communication-related topics:",
	"",
	"say     -- talking to the other people in the same room",
	"whisper -- talking privately to someone in the same room",
	"emote   -- non-verbal communication with others in the same room",
	"sayto   -- say something directed to sonother person",
	"page    -- communicate with someone in another room",
);	
$helpobject->addhelp('manipulation',
	"Here are some commands you can use to manipulate objects:",
	"",
	"get  -- pick an object up and place it in your inventory",
	"drop -- remove an object from your inventory and place it in the room",
	"put  -- take an object from your inventory and place it in a container",
	"give [5~-- hand an object to some other person",
	"look -- see what an object looks like",
);
$helpobject->addhelp('miscellaneous',
	"Here are some commands that didn't fit in any other categories:",
	"",
	"lastlog -- finding out when somone last connected",
	"who     -- showing who is logged on",
	"quit    -- disconnecting from Perlmoo",
	"help    -- displaying help",
	"s///    -- recalling and modifying a command",
	"version -- show perlmoo version",
	"uptime  -- show how long the moo has been running",
);
$helpobject->addhelp('building',
	"There are a number of commands available to people for modifying the moo:",
	"",
	"describe -- changing what an object looks like",
	"rename   -- changing an object's name and aliases",
	"chown    -- changes who owns an object",
	"audit    -- list all the objects you or someone else owns",
	"delete   -- remove an object from the moo",
	"",
	"These commands are mostly only of use to builders - normal users will not have permission to execute them:",
	"",
	"dig      -- conveniently building new rooms and exits",
	"create   -- making other kinds of objects",
	"show     -- listling properties of objects",
);
$helpobject->addhelp('programming',
	"Perlmoo can be programmed to create interesting new objects. This can only be done by programmers - normal users will not have permission to use these commands:",
	"",
	"eval     -- immediatly execute perl code",
	"teach    -- adding a new verb to an object",
	"verbcode -- adding/changing the code that is executed for a verb",
	"code     -- adding/changing an object's method",
	"",
	"Of course, Perlmoo is programmed in perl, and you use perl code in the above commands. See the fine perl documentation to learn more about programming in perl.",
);
$helpobject->addhelp('wizindex',
	"Wizards have many special powers - they can examine and change all properties of all objects. They also have some special commands:",
	"",
	"listall     -- listing every object in the whole moo",
	"shout       -- broadcasting a message to all users",
	"setpassword -- changing a user's password",
	"dumpdb      -- immediatly saving the database",
	"",
	"Here are some other help texts wizards may find helpful:",
	"",
	"newuser     -- adding a new user to the moo",
	"loginroom   -- customizing the login room",
);	
$helpobject->addhelp('newuser',
	"Here is the process to follow to add a new user to the moo:",
	"\tcreate \$person named linus",
	"\tdescribe linus as \"We all know what linus looks like, right?\"",
	"\tsetpassword linus to linux",
	"\tchown linus to linus",
	"Now linus can log in with a password of 'linux'",
	"",
	"You may want to set up some people with higher permissions than a default person has. Just substitute \$builder, \$programmer, or even \$wizard for \$person above.",
);
$helpobject->addhelp('loginroom',
	"The login room is the room people first see when they login. You may want to change the room's description and name to customize what people see when they connect to the moo. To do this, just refer to \$loginroom. For example:",
	"\trename \$loginroom to MyMoo",
	"\tdescribe \$loginroom as \"Welcome to my moo!\"",
);
$helpobject->addhelp('s///',
	"Recall a command, modify it, and re-execute it",
	"Syntax: s/<from>/<to>/<flags>",
	"",
	"This command recalls your last command, does a substitution on it, and immediatly sends the result to the moo as if the result was the command you had typed. This can be very useful for correcting typos in a command. It can also be quite annoying if overused on things like 'say' commands that output things to others in the room.",
	"",
	"<from> is the regular expression to match in the last command you entered.",
	"<to> is the value to replace matches with.",
	"<flags> is a set of flags to control the s/// command's operation. Use 'g' to repeat the modification as many times as possible. Use 'i' to make the matching of <from> case-insensative. The flags can appear in any order.",
	"",
	"This is a dumbed down version of the perl s/// operator. See the perlop man page for details on the regexps and on all the neat things you can do with it (many of them vastly overkill for the simple purposes this command is used for in the moo).",
);	

$loginroom=LoginRoom->new(
	id => 12,
	parent => $gen_room,
	name => 'perlmoo',
	description => q{An experimental perl moo. If you have an account here, type "connect name password" to login. Otherwise, you can log in as a guest user ("connect guest"). If you find something that looks like a bug, send joey@kitenet.net a transcript. Once you log in, type "help intro" to get started.},
);

$generic=Generics->new(
	id => 9,
	parent => $gen_thing,
	name => 'Generic Objects',
	thing_gen => $gen_thing,
	container_gen => $gen_container,
	person_gen => $gen_person,
	room_gen => $gen_room,
	exit_gen => $gen_exit,
	builder_gen => $gen_builder,
	programmer_gen => $gen_programmer,
	wizard_gen => $wizard,
	helpobject_gen => $helpobject,
	loginroom_gen => $loginroom,
	fertile => undef,
);
$generic->perms_r('thing_gen',1);
$generic->perms_r('container_gen',1);
$generic->perms_r('person_gen',1);
$generic->perms_r('room_gen',1);
$generic->perms_r('exit_gen',1);
$generic->perms_r('builder_gen',1);
$generic->perms_r('programmer_gen',1);
$generic->perms_r('wizard_gen',1);
$generic->perms_r('loginroom_gen',1);
$generic->perms_r('helpobject_gen',1);


$room=$gen_room->new(
	id => 10,
	parent => $gen_room,
	name => "Void",
	description => "A lot of nothing, ready to be shaped into something.",
);

$guest=GuestAllocator->new(
	id => 11,
	parent => $gen_person,
	# This is a list of all valid names for guests.
	guestlist => [
		"red_guest",
		"yellow_guest",
		"blue_guest",
		"green_guest",
		"purple_guest",
		"orange_guest",
		"cyan_guest",
		"tan_guest",
		"magenta_guest",
		"turquoise_guest",
	],
	name => "guest",
	maxguests_msg => "Sorry, there are too many guests already logged in. Come back later.",
	fertile => undef,
);
$guest->perms_r('guestlist',1);
$guest->perms_r('maxguests_msg',1);

$gen_thing->home($room);
$gen_thing->owner($wizard);
