/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996, 1997, 1998 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    bhor0533@lehr.chem.TU-Berlin.DE
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifndef MAIN
#define MAIN
#include <sys/file.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define MAXCLIENTHOSTS       100 /* see main.c */
#define MAXCLIENTS           5 /* see main.c */
#define VERSION              "0.8.9"
#define HUNAME               32767
#define LONAME               1024
#define SONAME               256
#define BUFSIZE              32767
#define DEFAULT_STDIN_BUFSIZ 4096
#define MAXIMUM_UPLOAD_LIMIT 4096
#define PFTP_NEW_DATA_MSG    "You have new data.\n"

#include "status.h"
extern struct status_type *statstr[MAXCLIENTS+1];

#ifdef USE_POSIX_THREAD
extern pthread_mutex_t interactiv;
#endif
extern short CHILDNUM; /* number of children currently running */
extern short pftpnoroot; /* number of children currently running */
extern int OUTPUT;
extern int s;         /* Socket */
extern FILE *slfp; /* pointer to stderr or server log file or NULL */
extern volatile short _WINROWS_; /* Number of rows on the screen */
extern volatile short _WINCOLS_; /* Number of columns on the screen */
extern char *pftplog;  /* holds the name of the log file if any */
extern char *_CLIENTHOSTNAME_[MAXCLIENTHOSTS]; /* specified client host names */
extern char *filter[SONAME]; /* holds the name of the filter program and its arguments */
extern char *_STDOUT_BUFFER_; /* buffers stdout data */
extern char *client_destdir; /* Destination directory if sending to the daemon */
extern char *data_subject; /* subject of data sent */
extern char *data_info; /* holds info file about data sent */

#endif
