/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996, 1997, 1998 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    bhor0533@lehr.chem.TU-Berlin.DE
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef unicos
#include <fcntl.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#endif
#include "connect.h"
#include "main.h"

extern void set_tty(int);
extern void import(char *, unsigned long, unsigned long, int);
extern void timing(int, double *);
extern short get_var_from_pftprc(const char *, char *, short);
extern char *time_string(void);
extern short check_pass(int);
extern char *tabdir(char *);

double sum_bytes[MAXCLIENTS+1];

void receive_data(void *structure_number)
{
   FILE *fd=stdout, *ld, *fp=NULL;
   int strnum = (int)*(int *)structure_number;
   int mode=0, smode=0755;
   volatile int appending=0;
   short FIRST=1;
   int ft;
   register int cc;
   int ccc, pp;
   unsigned long filesize=0;
   unsigned long ci; /* number of bytes received */
   unsigned long number=0; /* This should be enough ;^) */
   char *name=NULL, fname[LONAME];
   char fstr[BUFSIZE];
   struct stat buf;
   fp = (*(statstr+strnum))->fp;

#ifdef USE_POSIX_THREAD
   pthread_mutex_lock(&interactiv);
#endif
   /*
    * If server is running as daemon or was started by inetd.
    */
   if ((*statstr)->_PFTP_DAEMON_) if (!check_pass(strnum)) {
#ifdef USE_POSIX_THREAD
      pthread_mutex_unlock(&interactiv);
      (*(statstr+strnum))->free = 1;
#endif
      return;
   }

   /*
    * Start timing.
    */
   *(sum_bytes+strnum) = 0;
   if (slfp) timing(strnum, sum_bytes+strnum);

#ifdef USE_POSIX_THREAD
   pthread_mutex_unlock(&interactiv);
   CHILDNUM++;
#endif
   do {
      /*
       * Get some information about the file.
       */
      *fname = '\0';
      if (!fgets(fstr, BUFSIZE, fp)) continue;
      else {
         char *strptr=NULL;
         for (strptr=fstr; *strptr && *strptr != '\n'; strptr++);
         *strptr = '\0';
         for (cc=1; *strptr != ' ' && strptr != fstr; strptr--);
         *strptr = '\0';
         if (fstr == strptr) cc = 0;
         else {
            filesize = (unsigned long)atol(++strptr);
            if ((*(statstr+strnum))->from) {
               if (((*(statstr+strnum))->mul -= filesize) < 0) {
                  send((*(statstr+strnum))->ws, "ERRO ** No space left.\n", 24, MSG_OOB);
                  close((*(statstr+strnum))->ws);
                  if (shutdown((*(statstr+strnum))->ns, 2) < 0) {
                     if (slfp) fprintf(slfp, "** shutdown: %s\n", _PFTP_ERROR_ARRAY_);
#ifdef USE_POSIX_THREAD
                     (*(statstr+strnum))->free = 1;
#endif
                     exit(1);
                  }
                  if (slfp) {
                     fprintf(slfp, "%s %s No space left.\n",
                     time_string(), (*(statstr+strnum))->pw_name);
                     fflush(slfp);
                  }
#ifdef USE_POSIX_THREAD
                  (*(statstr+strnum))->free = 1;
#endif
                  return;
               }
            }
            for (strptr--; *strptr != ' ' && strptr != fstr; strptr--);
            *strptr = '\0';
            if (fstr == strptr) cc = 0;
            else {
               mode = atoi(++strptr);
               strcpy(fname, fstr);
            }
         }

         if (!cc || ('H' != (char)fgetc(fp))) {
            fclose(fp);
		      if (mode < 0) break;
		      if (slfp) {
#ifdef USE_POSIX_THREAD
		         pthread_mutex_lock(&interactiv);
		         if (CHILDNUM > 1) {
                  if ((*statstr)->RECEIVING) putc('\n', slfp);
		         }
#else
		         putc('\n', slfp);
#endif
		         fprintf(slfp, "** Can't get file name from client %s\n",\
		         (*(statstr+strnum))->REMOTEHOSTNAME);
#ifdef USE_POSIX_THREAD
		         pthread_mutex_unlock(&interactiv);
#endif
            }
#ifdef USE_POSIX_THREAD
            CHILDNUM--;
            (*(statstr+strnum))->free = 1;
#endif
            return;
         }
         umask(~mode);
         umask(~smode);
      }
      if (!*fname) continue;

      if ((*(statstr+strnum))->_SKIP_ == 3) (*(statstr+strnum))->_SKIP_ = 0;
      else if ((*(statstr+strnum))->_SKIP_) (*(statstr+strnum))->_SKIP_ = 1;

#ifdef USE_POSIX_THREAD
      pthread_mutex_lock(&interactiv);
      if (slfp && FIRST && CHILDNUM == 1 && !((*statstr)->_PFTP_DAEMON_)) {
         putc(slfp == stderr ? '\r': '\n', slfp);
      }
      else if (slfp && FIRST) {
         if ((*statstr)->RECEIVING) putc('\n', slfp);
      }
#else
      if (slfp && FIRST) {
         if (!((*statstr)->_PFTP_DAEMON_)) putc('\n', slfp);
      }
#endif
      FIRST = 0;
      /*
       * Check for remote standard input stream.
       */
      if (!strcmp(fname, "|") && (*(statstr+strnum))->_STANDARD_INPUT_) {
         fd = stdout;
         MEM_CHECK((name = (char *)calloc(7, sizeof(char))));
         strcpy(name, "Stream");
      }
      /*
       * Check for regular file.
       */
      else {
         /*
          * Check and create file name and directories.
          */
         if (!strcmp(fname, "|")) {
            number++;
            sprintf(fname, "%s.%lu", "Stream", number);
            /*
             * Take another number if file already exists.
             */
            while (!access(fname, F_OK)) {
               number++;
               sprintf(fname, "%s.%lu", "Stream", number);
            }
         }

         if ((*(statstr+strnum))->_RECURS_) {
            MEM_CHECK((name = (char *)calloc(LONAME, sizeof(char))));
         }
         else name = fname;
         for (cc=ccc=pp=0; cc < LONAME && *(fname+cc); cc++) {
            if ((*(statstr+strnum))->_RECURS_) {
               /*
                * Avoiding trojan horses.
                */
               name[ccc] = fname[cc];
               if (name[ccc] == '.') pp++;
               else if (name[ccc] != '/') pp = 0;

               ccc++;
               if (fname[cc] == '/') {
                  if (pp == 1) {
                     ccc -= 2;
                  }
                  else if (pp == 2) {
                     ccc -= 3;
                  }
                  else if (ccc == 1) {
                     ccc = 0;
                  }
                  else if (access(name, F_OK)) {
                     name[ccc-1] = '\0';
                     if (mkdir(name, smode)) {
                        if (slfp) fprintf(slfp, "** %s: %s\n", name, _PFTP_ERROR_ARRAY_);
                        shutdown((*(statstr+strnum))->ns, 2);
#ifdef USE_POSIX_THREAD
                        (*(statstr+strnum))->free = 1;
                        pthread_mutex_unlock(&interactiv);
#endif
                        fclose(fp);
                        return;
                     }
                     name[ccc-1] = '/';
                  }
                  pp = 0;
               }
            }
            else if (fname[cc] == '/') {
               name = fname + cc + 1;
            }
         }

         /*
          * Testing for exitence of file on local host.
          */
         while (!access(name, F_OK)) {
            int hor='\0';

            if ((*(statstr+strnum))->_SKIP_) {
               (*(statstr+strnum))->_SKIP_ = 2;
               break;
            }
            else if ((*(statstr+strnum))->OVERWRITE) {
               if (stat(name, &buf) < 0) {
                  if (slfp) fprintf(slfp, "** stat: %s: %s\n", \
                  name, _PFTP_ERROR_ARRAY_);
                  shutdown((*(statstr+strnum))->ns, 2);
#ifdef USE_POSIX_THREAD
                  (*(statstr+strnum))->free = 1;
                  pthread_mutex_unlock(&interactiv);
#endif
                  fclose(fp);
                  return;
               }
               else if ((buf.st_mode & 0200) != 0200) {
                  if (chmod(name, mode|0200) < 0) {
                     fprintf(stderr, "** chmod: %s: %s\n", \
                     name, _PFTP_ERROR_ARRAY_);
                     shutdown((*(statstr+strnum))->ns, 2);
#ifdef USE_POSIX_THREAD
                     (*(statstr+strnum))->free = 1;
                     pthread_mutex_unlock(&interactiv);
#endif
                     fclose(fp);
                     return;
                  }
               }
               break;
            }
            fprintf(stderr, "** File %s exists! (from %s)\n** Overwrite(y|n) all(Y), append(a), skip(s) all(S)? ", name, (*(statstr+strnum))->REMOTEHOSTNAME);
            set_tty(1);
            hor=fgetc(stdin);
            set_tty(0);
            if (hor != '\n') fputc('\n', stderr);
            if(hor=='Y' || hor=='y' || hor=='a') {
               if (stat(name, &buf) < 0) {
                  fprintf(stderr, "** stat: %s: %s\n", \
                  name, _PFTP_ERROR_ARRAY_);
                  exit(1);
               }
               else if ((buf.st_mode & 0200) != 0200) {
                  if (chmod(name, mode|0200) < 0) {
                     fprintf(stderr, "** chmod: %s: %s\n", \
                     name, _PFTP_ERROR_ARRAY_);
                     exit(1);
                  }
               }
               if (hor=='Y') (*(statstr+strnum))->OVERWRITE = BIT_ONE;
               else if (hor=='a') appending |= O_APPEND;
               break;
            }
            else if(hor=='s') {
               (*(statstr+strnum))->_SKIP_ = 3;
               break;
            }
            else if(hor=='S') {
               (*(statstr+strnum))->_SKIP_ = 2;
               break;
            }
            else {
               char *str=NULL;
               char *stmp=NULL;
               MEM_CHECK((str = (char *)calloc(SONAME, sizeof(char))));
#ifdef NEXTSTEP
               getwd(str);
#else
               getcwd(str, SONAME);
#endif
               set_tty(2);
               stmp = tabdir(str);
               set_tty(0);
               fprintf(stderr, "\n");
               if (!stat(stmp, &buf) && (buf.st_mode & S_IFDIR)) {
                  strcat(stmp, "/");
                  strcat(stmp, name);
               }
               if (stmp) strcpy(name, stmp);
               free(str);
            }   
         }
         if ((*(statstr+strnum))->_SKIP_ < 2) {
            /*
             * Open file on local host for writing.
             */
            if ((ft = open(name, O_CREAT|O_WRONLY|appending, mode)) < 0) {
               if ((*statstr)->_PFTP_DAEMON_ && slfp) {
                  fprintf(slfp, "%s %s: %s\n",
                  time_string(), name, _PFTP_ERROR_ARRAY_);
               }
               else if (slfp) {
                  fprintf(slfp, "** %s: %s\n", name, _PFTP_ERROR_ARRAY_);
               }
               close((*(statstr+strnum))->ws);
               shutdown((*(statstr+strnum))->ns, 2);
#ifdef USE_POSIX_THREAD
               (*(statstr+strnum))->free = 1;
               pthread_mutex_unlock(&interactiv);
#endif
               fclose(fp);
               return;
            }
            fd = fdopen(ft, "w");
            appending = 0;
         }
      }

      /*
       * Read file from client/filter and write to 
       * local file respectively standard out.
       */
      ci=0;
      (*(statstr+strnum))->lol=0;
      if (slfp && !((*statstr)->_PFTP_DAEMON_)) import(name, filesize, ci, strnum);
#ifdef USE_POSIX_THREAD
      pthread_mutex_unlock(&interactiv);
#endif

      if ((*(statstr+strnum))->_SKIP_ > 1) {
         register int rr = (unsigned int)BUFSIZE < filesize ? BUFSIZE : filesize;
         while (ci < filesize && (cc = fread(fstr, sizeof(char), rr, fp)) > 0) {
            if ((ci+=cc) > (filesize - rr)) rr = filesize - ci;
         }
      }
      else if (filesize) {
         register int rr;
         for (rr = (unsigned int)BUFSIZE < filesize ? BUFSIZE : filesize;
         ci < filesize && (cc = fread(fstr, sizeof(char), rr, fp)) > 0;
         ((ci+=cc) > (filesize - rr))? (rr = filesize - ci) :rr)
            fwrite(fstr, sizeof(char), cc, fd);
      }
      else for (ci=0; (cc = fgetc(fp)) != EOF; ci++) fputc(cc, fd);
      fflush(fd);

      if (!ci) (*(statstr+strnum))->lol = 1;
      else *(sum_bytes+strnum) += (double)ci;
      if ((*(statstr+strnum))->_SKIP_ < 2) fclose(fd);
#ifdef USE_POSIX_THREAD
      pthread_mutex_lock(&interactiv);
#endif
      if (slfp && !(((*statstr)->_PFTP_DAEMON_) && !((*statstr)->lognames))) {
         import(name, filesize, ci, strnum);
      }

      if ((*(statstr+strnum))->_RECURS_) free(name);
      /*
       * Check of size of file.
       */
      if (slfp && filesize > ci && !(*(statstr+strnum))->_STANDARD_INPUT_ && filesize > 0) {
         fprintf(slfp, "** File is incomplete. ");
         fprintf(slfp, "Actual size of file is %ld bytes.\n", filesize);
         if (pftplog) {
            if ((ld = fopen(pftplog, "a")) != NULL) {
               fprintf(ld, "** File is incomplete. ");
               fprintf(ld, "Actual size of file is %ld bytes.\n", filesize);
               fclose(ld);
            }
         }
      }
#ifdef USE_POSIX_THREAD
      pthread_mutex_unlock(&interactiv);
#endif
      ci = 0;
   } while (strcmp(fname, ""));
#ifdef USE_POSIX_THREAD
   pthread_mutex_lock(&interactiv);
   if (slfp) {
      if ((*statstr)->RECEIVING && !(*(statstr+strnum))->_STANDARD_INPUT_) {
         putc('\n', slfp);
      }
      if ((*statstr)->_PFTP_DAEMON_) {
         fprintf(slfp, "%s %s", time_string(),
         (*(statstr+strnum))->REMOTEHOSTNAME);
      }
      else {
         fprintf(slfp, "<%d> Connection to %s",
         strnum, (*(statstr+strnum))->REMOTEHOSTNAME);
      }
      /*
       * End timing.
       */
      timing(strnum, sum_bytes+strnum);
   }
   
   pthread_mutex_unlock(&interactiv);
   (*(statstr+strnum))->free = 1;
   CHILDNUM--;
#else
   if (slfp) {
      if ((*statstr)->_PFTP_DAEMON_) {
         fprintf(slfp, "%s %s", time_string(),
         (*(statstr+strnum))->REMOTEHOSTNAME);
      }
      else {
         fprintf(slfp, "<*> Connection to %s",
         (*(statstr+strnum))->REMOTEHOSTNAME);
      }
      timing(strnum, sum_bytes+strnum);
   }
#endif
   if (write((*(statstr+strnum))->ws, "OKAY <*> Data successfully sent", 32) < 0) {
      fprintf(slfp, "** write: %s\n", _PFTP_ERROR_ARRAY_);
   }
   if ((*(statstr+strnum))->pw_name) free((*(statstr+strnum))->pw_name);
   if ((*(statstr+strnum))->from) free((*(statstr+strnum))->from);
   shutdown((*(statstr+strnum))->ws, 2);
   shutdown((*(statstr+strnum))->ns, 2);
}
