/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996, 1997, 1998 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    bhor0533@lehr.chem.TU-Berlin.DE
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/types.h>
#include <sys/errno.h>
#endif
#include <ctype.h>
#include <pwd.h>
#include <sys/types.h>
#include <dirent.h>
#if defined Linux || defined NEXTSTEP
#include <sys/dir.h>
#endif
#include "main.h"

extern void bubble_sort(char **, char *, long);
extern short mycmp(char *, char *);
char *list_dir(char *, char *);


char *tabdir(char *str)
{
   struct stat buf;
   char *cdir=NULL, *cstr=NULL;
   char *tmp=NULL, *ctmp=NULL;
   char *blankline=NULL;
   char c='\0';

   MEM_CHECK((cdir = (char *)calloc(LONAME, sizeof(char))));
   MEM_CHECK((cstr = (char *)calloc(LONAME, sizeof(char))));
   MEM_CHECK((tmp = (char *)calloc(LONAME, sizeof(char))));
   MEM_CHECK((blankline = (char *)calloc(SONAME, sizeof(char))));
   for (ctmp=blankline; ctmp - blankline < _WINCOLS_; ctmp++) *ctmp = ' ';
   *ctmp='\r';
   *++ctmp='\0';

   /*
    * Find default directory.
    */
   for (ctmp=str; *ctmp; ctmp++);
   do {
      if (!stat(str, &buf)) if (buf.st_mode & S_IFDIR) break;
      for (; *ctmp != '/' && ctmp != str; ctmp--);
      if (ctmp == str) {
         ctmp++;
         break;
      }
      *ctmp = '\0';
   } while (!c);

   for (ctmp=cdir; ctmp-cdir < LONAME; ctmp++) *ctmp = '\0';
   ctmp = cdir;

   fprintf(stdout, "[%dH%s\r", _WINROWS_, blankline);
   fprintf(stdout, "Destination [%s]: ", str);
   do {
      while ((c = fgetc(stdin)) == '');
      switch(c) {
         case '\t': case '':
            ctmp = NULL;
            if (*cdir == '/') {
               strcpy(tmp, cdir);
            }
            else if (*cdir) {
               if (*cdir == '~' && getpwuid(getuid())) {
                  sprintf(tmp, "%s%s%s", (char *)getpwuid(getuid())->pw_dir, \
                  *(cdir+1) == '/'? "/": "", *(cdir+2)? cdir+2: "");
               }
               else {
                  sprintf(tmp, "%s%s%s", str, strcmp(str, "/")? "/": "", cdir);
               }
            }
            else strcpy(tmp, str);
            if (*cdir) {
            for (ctmp=tmp; *ctmp; ctmp++);
            for (; *ctmp != '/'; ctmp--);
            if (ctmp == tmp) {
               strcpy(cstr, tmp);
               strcpy(tmp, "/");
               ctmp = cstr+1;
            }
            else {
               *ctmp = '\0';
               ++ctmp;
            }
            }
            ctmp = list_dir(tmp, ctmp);
            if (tmp) strcat(cdir, tmp);
            if (ctmp) fprintf(stdout, "%s", tmp);
            else fprintf(stdout, "\nDestination [%s]: %s", str, cdir);
            for (ctmp=cdir; *ctmp; ctmp++);
            break;
         case '': case '':
            if (ctmp > cdir) {
               ctmp--;
               fprintf(stdout, "\b \b");
               *ctmp = '\0';
            }
            break;
         case '':
            if (blankline) free(blankline);
            if (tmp) free(tmp);
            if (cstr) free(cstr);
            if (cdir) free(cdir);
            return NULL;
         case '\n': break;
         case '':
            fprintf(stdout, "[H[JDestination [%s]: %s", str, cdir);
            break;
         default:
            if (isprint(c) && ctmp - cdir < LONAME) {
               *ctmp = c;
               ctmp++;
               fputc(c, stdout);
            }
      }
   } while (c != '\n');

   if (blankline) free(blankline);
   if (tmp) free(tmp);
   if (cstr) free(cstr);
   if (*cdir == '~' && getpwuid(getuid())) {
      sprintf(str, "%s%s%s", (char *)getpwuid(getuid())->pw_dir, \
      *(cdir+1) == '/'? "/": "", *(cdir+2)? cdir+2: "");
   }
   else {
      sprintf(str, "%s%s%s", *cdir == '/' ? "" : str,
      *cdir == '/' || strlen(str) == 1 ? "" : "/", cdir);
   }

   /*
    * Dereference `..'
    */
   for (tmp=ctmp=str; (*tmp = *ctmp); tmp++, ctmp++) {
      if (*ctmp == '.' && *(ctmp+1) == '.' && \
         (*(ctmp+2) == '/' || !*(ctmp+2))) { 
         ctmp += 2;
         if (--tmp != str) for (tmp--; *tmp != '/' && tmp != str; tmp--);
         *tmp = *ctmp;
      }
      else if (*ctmp == '/' && *(ctmp+1) == '/') ctmp++;
   }
   for (tmp--;*tmp == '/' && tmp != str; tmp--);
   *++tmp = '\0';

   stat(str, &buf);
   if (!(buf.st_mode & S_IFDIR)) {
      for (ctmp=str; *ctmp; ctmp++);
      if (*--ctmp == '/' && ctmp != str) *ctmp = '\0';
   }
   if (cdir) free(cdir);

   return str;
}


char *list_dir(char *directory, char *mask)
{
   int endnum=0, j=0, i=0, epl=0;
   int maxlen=0, masklen=0;
   char *direntries[HUNAME];
   char *tmp=NULL, *oformat=NULL;
   char last='\0';
   DIR *dp=NULL;
#if defined Linux || defined NEXSTEP
   struct direct *dir;
#else
   struct dirent *dir;
#endif
   struct stat buf;


   MEM_CHECK((tmp = (char *)calloc(LONAME, sizeof(char))));
   MEM_CHECK((oformat = (char *)calloc(SONAME, sizeof(char))));
   if (mask) masklen=strlen(mask);
   if (!(dp = opendir(directory))) {
      fprintf(stdout, "\n** %s: %s", directory, _PFTP_ERROR_ARRAY_);
      *directory = '\0';
      if (oformat) free(oformat);
      if (tmp) free(tmp);
      return NULL;
   }

   for (endnum=0; (dir = readdir(dp)); endnum++) {
      if (mask) {
         if (dir->d_ino && !strncmp(dir->d_name, mask, masklen) && strcmp(dir->d_name, ".") \
            && (*(dir->d_name) != '.' || !strcmp(dir->d_name, "..") || *mask == '.')) {
            MEM_CHECK((*(direntries+endnum) = (char *)calloc(LONAME, sizeof(char))))
            strcpy(*(direntries+endnum), dir->d_name);
            sprintf(tmp, "%s/%s", directory, dir->d_name);
            if (!stat(tmp, &buf) && (buf.st_mode & S_IFDIR)) {
                strcat(*(direntries+endnum), "/");
            }
         }
         else endnum--;
      }
      else {
         if (dir->d_ino && strcmp(dir->d_name, ".") \
            && (*(dir->d_name) != '.' || !strcmp(dir->d_name, ".."))) {
            MEM_CHECK((*(direntries+endnum) = (char *)calloc(LONAME, sizeof(char))))
            strcpy(*(direntries+endnum), dir->d_name);
            sprintf(tmp, "%s/%s", directory, dir->d_name);
            if (!stat(tmp, &buf) && (buf.st_mode & S_IFDIR)) {
                strcat(*(direntries+endnum), "/");
            }
         }
         else endnum--;
      }
   }
   closedir(dp);
   *(direntries+endnum) = NULL;

   if (endnum == 1) {
      if (mask) {
         strcpy(directory, ((*direntries)+masklen));
      }
      else strcpy(directory, *direntries);
   }
   else if (endnum > 1) {
      int line=1;
      /*
       * Sort directory entries.
       */
      bubble_sort(direntries, directory, (long) endnum);
      
      for (maxlen=i=0; i < endnum; i++) {
         if ((j = strlen(*(direntries+i))) > maxlen) maxlen = j;
      }
      for (j=2; j < maxlen; j++) {
         if (maxlen >= ((_WINCOLS_-(j*3)) / j)) {
            epl = j-1;
            break;
         }
      }
      if (!epl) epl = _WINCOLS_ / 6;
      sprintf(oformat, "%%-%ds  ", maxlen);

      /*
       * Print out entries which match the mask.
       */
      fprintf(stdout, "\n");
      for (i=j=0; i < endnum; i++, j++) {
         if (j == epl) {
            line++;
            if (line == _WINROWS_) {
               line = 1;
               fprintf(stdout, "\n--more--\r");
               if (fgetc(stdin) == 'q') {
                  fprintf(stdout, "          \r");
                  fputc('\b', stdout);
                  break;
               }
            }
            else fputc('\n', stdout);
            j=0;
         }
         fprintf(stdout, oformat, *(direntries+i));
      }
      maxlen = strlen(*direntries);
      last = **direntries;
      for (i=masklen; i < maxlen && last; i++) {
         last = *((*direntries)+i);
         for (j=1; j < endnum; j++) {
            if (last != *(*(direntries+j)+i)) last = '\0';
         }
         *(directory+i-masklen) = last;
      }
      *(directory+i-masklen) = '\0';
      mask = NULL;
   }
   else *directory = '\0';
   for (endnum--; endnum+1; endnum--) {
      if (*(direntries+endnum)) {
         free(*(direntries+endnum));
      }
   }
   if (oformat) free(oformat);
   if (tmp) free(tmp);
   return mask;
}
