/*
Copyright (c) 1998 Peter Zelezny.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "xchat.h"
#include "userlist.h"
#include <fcntl.h>


extern struct xchatprefs prefs;
extern GSList *sess_list;
extern struct server firstserver;

extern char *get_xdir(void);
extern void dcc_chat(struct session *sess, char *nick);
extern void kill_session(GtkWidget *win, struct session *sess);
extern GtkWidget *createmenus(struct session *sess);
extern void handle_inputgad(GtkWidget *igad, struct session *sess);
extern int handle_keypress(GtkWidget *widget, GdkEventKey *event, struct session *sess);
extern void dcc_send_filereq(struct session *sess, char *nick);
extern struct dialog *new_dialog(struct server *serv, char *nick);
extern struct dialog *find_dialog(struct server *serv, char *nick);

GdkColor colors[] =
{
     { 0, 0xffff, 0xffff, 0xffff }, /* 0  white */
     { 0, 0, 0, 0 },                /* 1  black */
     { 0, 0, 0, 0xcccc },           /* 2  blue */
     { 0, 0, 0xbbbb, 0 },           /* 3  green */
     { 0, 0xbbbb, 0, 0 },           /* 4  red */
     { 0, 0xaaaa, 0xaaaa, 0 },      /* 5  yellow/brown */
     { 0, 0xbbbb, 0, 0xbbbb },      /* 6  purple */
     { 0, 0xcccc, 0xcccc, 0 },      /* 7  orange */  
     { 0, 0xeeee, 0xeeee, 0 },      /* 8  yellow */
     { 0, 0, 0xffff, 0 },           /* 9  green */
     { 0, 0, 0xbbbb, 0xbbbb },      /* 10 aqua */
     { 0, 0, 0xeeee, 0xeeee },      /* 11 light aqua */  
     { 0, 0, 0, 0xffff },           /* 12 blue */
     { 0, 0xffff, 0, 0xffff },      /* 13 pink */    
     { 0, 0x7777, 0x7777, 0x7777 }, /* 14 grey */  
     { 0, 0x9999, 0x9999, 0x9999 }, /* 15 light grey */   
};


void gui_change_nick(struct server *serv, char *newnick)
{
   GSList *list = sess_list;
   struct session *sess;
   strcpy(serv->nick, newnick);
   while(list)
   {
      sess = (struct session *)list->data;
      if(sess->server == serv)
	 gtk_label_set(GTK_LABEL(sess->nickgad), newnick);
      list = list->next;
   }
}

void handle_topicgad(GtkWidget *igad, struct session *sess)
{
   char *topic = gtk_entry_get_text(GTK_ENTRY(igad));
   char tbuf[256];
   if(sess->channel[0] && sess->server->flags&(1<<0))
   {
     sprintf(tbuf, "TOPIC %s :%s\r\n", sess->channel, topic);
     send(sess->server->sok, tbuf, strlen(tbuf), 0);
   } else
     gtk_entry_set_text(GTK_ENTRY(igad), "");
}

void ul_row_unselected(GtkWidget *clist, gint row, gint column,
		       GdkEventButton *even, struct session *sess)
{
     sess->selected = -1;
}

void ul_row_selected(GtkWidget *clist, gint row, gint column,
		       GdkEventButton *even, struct session *sess)
{
     sess->selected = row;
}

char *find_selected_nick(struct session *sess)
{
   int i = 0;
   struct user *user = sess->userlist;
   if(sess->selected == -1) return 0;
   while(user)
   {
      if(sess->selected == i) return(user->user);
      i++;
      user = user->next;
   }
   return FALSE;
}

void chat_clicked(GtkWidget *wid, struct session *sess)
{
   gchar *nick = find_selected_nick(sess);
   if(nick) dcc_chat(sess, nick);
}

void dialog_clicked(GtkWidget *wid, struct session *sess)
{
   gchar *nick = find_selected_nick(sess);
   if(nick)
   {
      if(!find_dialog(sess->server, nick))
	new_dialog(sess->server, nick);
   }
}

void kick_clicked(GtkWidget *wid, struct session *sess)
{
   gchar *nick = find_selected_nick(sess);
   if(nick)
   {
      char tbuf[128];
      sprintf(tbuf, "KICK %s %s\r\n", sess->channel, nick);
      send(sess->server->sok, tbuf, strlen(tbuf), 0);
   }
}

void whois_clicked(GtkWidget *wid, struct session *sess)
{
   gchar *nick = find_selected_nick(sess);
   if(nick)
   {
      char tbuf[128];
      sprintf(tbuf, "WHOIS %s\r\n", nick);
      send(sess->server->sok, tbuf, strlen(tbuf), 0);
   }
}

void deop_clicked(GtkWidget *wid, struct session *sess)
{
   gchar *nick = find_selected_nick(sess);
   if(nick)
   {
      char tbuf[128];
      sprintf(tbuf, "MODE %s -o %s\r\n", sess->channel, nick);
      send(sess->server->sok, tbuf, strlen(tbuf), 0);
   }
}

void ban_clicked(GtkWidget *wid, struct session *sess)
{
   gchar *nick = find_selected_nick(sess);
   if(nick)
   {
      char tbuf[128];
      sprintf(tbuf, "MODE %s +b %s!*@*\r\n", sess->channel, nick);
      send(sess->server->sok, tbuf, strlen(tbuf), 0);
   }
}

void op_clicked(GtkWidget *wid, struct session *sess)
{
   gchar *nick = find_selected_nick(sess);
   if(nick)
   {
      char tbuf[128];
      sprintf(tbuf, "MODE %s +o %s\r\n", sess->channel, nick);
      send(sess->server->sok, tbuf, strlen(tbuf), 0);
   }
}

void send_clicked(GtkWidget *wid, struct session *sess)
{
   gchar *nick = find_selected_nick(sess);
   if(nick) dcc_send_filereq(sess, nick);
}

/*void size_request_textgad(GtkWidget *win, GtkRequisition *req)
{
   if (win->allocation.width < 50) req->width = 400;
   if (win->allocation.height < 50) req->height = 420;
}*/

static void size_request(GtkWidget *win, GtkRequisition *req)
{
   if (win->allocation.width < 50) req->width = 500;
   if (win->allocation.height <= 1) req->height = 460;
}

void add_tip(GtkWidget *wid, char *text)
{
   GtkWidget *tip = (GtkWidget*)gtk_tooltips_new();
   //gtk_tooltips_set_colors((GtkTooltips*)tip, &colors[10], &colors[1]);
   gtk_tooltips_set_tip((GtkTooltips*)tip, wid, text, 0);
}

void focus_in(GtkWindow *win, GtkWidget *wid, struct session *sess)
{
   sess->server->front_session = sess;
}

/*void change_channel_flag(GtkWidget *wid, struct session *sess, char flag)
{
   if(sess->server->flags&(1<<0) && sess->channel[0])
   {
      char outbuf[128];
      if(GTK_TOGGLE_BUTTON(wid) -> active)
	sprintf(outbuf, "MODE %s +%c\r\n", sess->channel, flag);
      else
	sprintf(outbuf, "MODE %s -%c\r\n", sess->channel, flag);
      send(sess->server->sok, outbuf, strlen(outbuf), 0);
      sprintf(outbuf, "MODE %s\r\n", sess->channel);
      send(sess->server->sok, outbuf, strlen(outbuf), 0);
   }
}

void flagt_hit(GtkWidget *wid, struct session *sess)
{
   change_channel_flag(wid, sess, 't');
}*/

void show_and_unfocus(GtkWidget *wid)
{
   GTK_WIDGET_UNSET_FLAGS(wid, GTK_CAN_FOCUS);
   gtk_widget_show(wid);
}

void add_flag_wid(GtkWidget **wid, char *tip, GtkWidget *box, char *face)
{
   *wid = gtk_toggle_button_new_with_label(face);
   gtk_widget_set_usize(*wid, 16, -1);
   add_tip(*wid, tip);
   gtk_box_pack_end(GTK_BOX(box), *wid, 0, 0, 0);
   //gtk_widget_show(*wid);
   show_and_unfocus(*wid);
}

void userlist_button(GtkWidget *box, char *label, void *callback,
		     struct session *sess, int a, int b, int c, int d)
{
   GtkWidget *wid = gtk_button_new_with_label(label);
   gtk_signal_connect(GTK_OBJECT(wid), "clicked",
		      GTK_SIGNAL_FUNC(callback), sess);
   gtk_table_attach_defaults(GTK_TABLE(box), wid, a, b, c, d);
   show_and_unfocus(wid);
}

void maingui_create_textlist(struct session *sess, GtkWidget *leftpane)
{
   int fh;
   char tbuf[200];
   GtkStyle *style = gtk_style_new();
   GdkPixmap *pixmap;
   GdkBitmap *mask;
   
   sess->textgad = gtk_text_new(0, 0);
   memcpy(style, gtk_widget_get_style(sess->textgad), sizeof(GtkStyle));
   memcpy(style->base, &colors[prefs.bg_color], sizeof(GdkColor));
   memcpy(style->bg, &colors[prefs.bg_color], sizeof(GdkColor));
   memcpy(style->fg, &colors[prefs.fg_color], sizeof(GdkColor));
   
   sprintf(tbuf, "%s/backgnd.xpm", get_xdir());
   fh = open(tbuf, O_RDONLY);
   if(fh != -1)
   {
      close(fh);
      pixmap = gdk_pixmap_create_from_xpm(sess->window->window, &mask,
				       &style->bg[GTK_STATE_NORMAL], tbuf);
      if(pixmap) style->bg_pixmap[0] = pixmap;
   }
   
   gtk_widget_set_style(sess->textgad, style);
   //gtk_signal_connect (GTK_OBJECT (sess->textgad), "size_request",
   //                     GTK_SIGNAL_FUNC(size_request_textgad), sess->textgad);
   gtk_widget_set_usize(sess->textgad, 380, 0);
   //gtk_idle_add(reset_usize, sess->textgad);
   gtk_text_set_word_wrap (GTK_TEXT(sess->textgad), TRUE);
   gtk_text_set_editable (GTK_TEXT (sess->textgad), FALSE);
   gtk_container_add(GTK_CONTAINER(leftpane), sess->textgad);
   gtk_widget_show(sess->textgad); 
   
   sess->vscrollbar = gtk_vscrollbar_new (GTK_TEXT(sess->textgad)->vadj);
   gtk_box_pack_start(GTK_BOX(leftpane), sess->vscrollbar, FALSE, FALSE, 0);
   show_and_unfocus(sess->vscrollbar);
}

void create_window(struct session *sess, char *channel)
{
   char tbuf[164];
   GtkWidget *leftpane, *rightpane, *paned;
   GtkWidget *vbox, *tbox, *bbox, *nlbox;
   GtkWidget *menubar, *box, *wid;
   int i;

   if(sess->server->servername[0] == 0)
     strcpy(tbuf, "X-Chat ("VERSION")");
   else
     sprintf(tbuf, "X-Chat ("VERSION"): %s", sess->server->servername);   

   sess->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   if(!sess->server->front_session) sess->server->front_session = sess;
   gtk_window_set_title((GtkWindow *)sess->window, tbuf);
   gtk_signal_connect((GtkObject *)sess->window, "destroy",
                            GTK_SIGNAL_FUNC(kill_session), sess);
   gtk_signal_connect((GtkObject *)sess->window, "size_request",
                        GTK_SIGNAL_FUNC(size_request), sess->window);
   gtk_signal_connect ((GtkObject *)sess->window, "focus_in_event",
                        GTK_SIGNAL_FUNC(focus_in), sess);
   //gtk_widget_set_usize(GTK_WIDGET(sess->window), 620, 460);
   gtk_window_set_policy((GtkWindow *)sess->window, TRUE, TRUE, FALSE);

   for (i=0; i<16; i++) 
   {
        colors[i].pixel =
            (gulong)((colors[i].red & 0xff00)*256 +
                     (colors[i].green & 0xff00) +
                     (colors[i].blue & 0xff00)/256);
        gdk_color_alloc(gtk_widget_get_colormap(sess->window), &colors[i]);
   }

   vbox = gtk_vbox_new(FALSE, 0);
   gtk_container_border_width((GtkContainer *)vbox, 4);
   gtk_container_add((GtkContainer *)sess->window, vbox);
   gtk_widget_show(vbox);

   menubar = createmenus(sess);
   gtk_box_pack_start(GTK_BOX(vbox), menubar, FALSE, TRUE, 0);
   gtk_widget_show(menubar);

   tbox = gtk_hbox_new(FALSE, 0);
   gtk_container_border_width(GTK_CONTAINER(tbox), 0);
   gtk_box_pack_start(GTK_BOX(vbox), tbox, FALSE, TRUE, 2);
   gtk_widget_show(tbox);

   if(channel && channel[0])
     sess->changad = gtk_label_new(channel);
   else
     sess->changad = gtk_label_new("#nonejoined");
   gtk_box_pack_start(GTK_BOX(tbox), sess->changad, FALSE, FALSE, 10);
   gtk_widget_show(sess->changad);

   sess->topicgad = gtk_entry_new_with_max_length( 255 );
   gtk_signal_connect(GTK_OBJECT(sess->topicgad), "activate",
		      GTK_SIGNAL_FUNC(handle_topicgad), sess);
   gtk_container_add(GTK_CONTAINER(tbox), sess->topicgad);
   gtk_widget_show(sess->topicgad);

   add_tip(sess->topicgad, "The channel topic");

   wid = gtk_entry_new();
   gtk_widget_set_usize(wid, 25, -1);
   gtk_box_pack_end(GTK_BOX(tbox), wid, 0, 0, 0);
   gtk_widget_show(wid);

   add_flag_wid(&(sess->flag_k), "Keyword", tbox, "K");

   wid = gtk_entry_new();
   gtk_widget_set_usize(wid, 25, -1);
   gtk_box_pack_end(GTK_BOX(tbox), wid, 0, 0, 0);
   gtk_widget_show(wid);

   add_flag_wid(&(sess->flag_l), "User Limit", tbox, "L");
   add_flag_wid(&(sess->flag_m), "Moderated", tbox, "M");
   add_flag_wid(&(sess->flag_p), "Private", tbox, "P");
   add_flag_wid(&(sess->flag_i), "Invite Only", tbox, "I");
   add_flag_wid(&(sess->flag_s), "Secret", tbox, "S");
   add_flag_wid(&(sess->flag_n), "No outside messages", tbox, "N");
   add_flag_wid(&(sess->flag_t), "Topic Protection", tbox, "T");

   leftpane = gtk_hbox_new(FALSE, 0);
   gtk_widget_show(leftpane);
   sess->leftpane = leftpane;

   paned = gtk_hpaned_new();
   gtk_container_add(GTK_CONTAINER(vbox), paned);
   gtk_widget_show(paned);

   rightpane = gtk_hbox_new(FALSE, 8);
   gtk_widget_show(rightpane); 

   gtk_paned_add1(GTK_PANED(paned), leftpane);
   gtk_paned_add2(GTK_PANED(paned), rightpane);
   gtk_paned_gutter_size(GTK_PANED(paned), 10);

   nlbox = gtk_vbox_new(FALSE, 2);
   gtk_container_add(GTK_CONTAINER(rightpane), nlbox);
   gtk_widget_show(nlbox);

   sess->namelistinfo = gtk_label_new("");
   gtk_box_pack_start(GTK_BOX(nlbox), sess->namelistinfo, FALSE, FALSE, 0);
   gtk_widget_show(sess->namelistinfo);

   maingui_create_textlist(sess, leftpane);
   
   sess->namelistgad = gtk_clist_new(1);
   //gtk_widget_set_usize(sess->namelistgad, 40, 0);
   //gtk_idle_add(reset_usize_ul, sess->namelistgad);
   gtk_signal_connect(GTK_OBJECT(sess->namelistgad),
		      "select_row", GTK_SIGNAL_FUNC(ul_row_selected), (gpointer)sess);
   gtk_signal_connect(GTK_OBJECT(sess->namelistgad),
		      "unselect_row", GTK_SIGNAL_FUNC(ul_row_unselected), (gpointer)sess);
   gtk_clist_set_border(GTK_CLIST(sess->namelistgad), GTK_SHADOW_OUT);
   //gtk_clist_set_column_width(GTK_CLIST(sess->namelistgad), 0, 40);
   gtk_clist_set_policy(GTK_CLIST(sess->namelistgad), GTK_POLICY_AUTOMATIC,
			      GTK_POLICY_AUTOMATIC);
   gtk_container_add(GTK_CONTAINER(nlbox), sess->namelistgad); 
   gtk_widget_show(sess->namelistgad);
   
   box = gtk_table_new(5, 2, FALSE);
   gtk_box_pack_end(GTK_BOX(nlbox), box, FALSE, FALSE, 1);
   gtk_widget_show(box);

   userlist_button(box, "Op", op_clicked, sess, 0, 1, 0, 1);
   userlist_button(box, "DeOp", deop_clicked, sess, 1, 2, 0, 1);
   userlist_button(box, "Ban", ban_clicked, sess, 0, 1, 1, 2);
   userlist_button(box, "Kick", kick_clicked, sess, 1, 2, 1, 2);
   userlist_button(box, "Send", send_clicked, sess, 0, 1, 2, 3);
   userlist_button(box, "Chat", chat_clicked, sess, 1, 2, 2, 3);
   userlist_button(box, "Dialog", dialog_clicked, sess, 0, 1, 3, 4);
   userlist_button(box, "Whois", whois_clicked, sess, 1, 2, 3, 4);

   bbox = gtk_hbox_new(FALSE, 0);
   gtk_container_border_width(GTK_CONTAINER(bbox), 0);
   gtk_box_pack_end(GTK_BOX(vbox), bbox, FALSE, TRUE, 2);
   gtk_widget_show(bbox);

   sess->nickgad = gtk_label_new(sess->server->nick);
   gtk_box_pack_start(GTK_BOX(bbox), sess->nickgad, FALSE, FALSE, 10);
   gtk_widget_show(sess->nickgad);

   sess->inputgad = gtk_entry_new_with_max_length( 255 );
   gtk_container_add(GTK_CONTAINER(bbox), sess->inputgad);
   gtk_signal_connect(GTK_OBJECT(sess->inputgad), "activate",
		      GTK_SIGNAL_FUNC(handle_inputgad), sess);
   gtk_signal_connect(GTK_OBJECT (sess->inputgad), "key_press_event",
	               GTK_SIGNAL_FUNC(handle_keypress), sess);
   gtk_widget_show(sess->inputgad);
   gtk_widget_grab_focus(sess->inputgad);

   add_tip(sess->inputgad, "Type in here");

   gtk_widget_show(sess->window);
}
