#include "util.h"
#include "MPList.h"

MPListEntry *MPList::postserver(const char *group) {
  int i;
  // bm=Best Match
  int bm=-1,bmlen=0,clen;
  
  for(i=0;i<e_used;i++) {
    clen=matchgroup(entries[i].postTo,group);
    if(clen>bmlen) {
      bm=i; bmlen=clen;
    }
  }
  if(bm>=0 && entries[bm].hostname[0]!='\0') return entries+bm;
  return NULL;
} 

MPListEntry *MPList::server(const char *group) {
  int i;
  // bm=Best Match
  int bm=-1,bmlen=0,clen;
  
  for(i=0;i<e_used;i++) {
    clen=matchgroup(entries[i].read,group);
    if(clen>bmlen) {
      bm=i; bmlen=clen;
    }
  }
  if(bm>=0 && entries[bm].hostname[0]!='\0') return entries+bm;
  return NULL;
} 

void MPList::read(Lexer &lex) {
  string tok,host,port;

  tok=lex.getToken();
  if(tok!="{") throw SyntaxError(lex,"expected '{'");
  for(;;) {
    tok=lex.getToken();
    if(tok=="Server") {
      host=lex.getToken();
      port=lex.getToken();
      readServer(lex,host.c_str(),port.c_str());
    } else if(tok=="NoServer") {
      readServer(lex,NULL,NULL);
    } else if(tok=="}") {
      break;
    } else {
      throw SyntaxError(lex,"expected declaration or '}'");
    }
  }
}

void MPList::readServer(Lexer &lex, const char *host, const char *port) 
{
  string tok,a1,a2,a3;
  int havePostTo=0;
  MPListEntry *cur;

  if(e_used==e_alloc) myrealloc(e_used+1);
  entries[e_used].init(host,port);
  cur=entries+e_used;
  e_used++;

  tok=lex.getToken();
  if(tok!="{") throw SyntaxError(lex,"expected '{'");
  for(;;) {
    tok=lex.getToken();
    if(tok=="Read") {
      a1=lex.getToken();
      if(a1.length()>=sizeof(cur->read)) 
	throw SyntaxError(lex,"group description too long");
      strcpy(cur->read,a1.c_str());
      if(!havePostTo) {
	if(a1.length()>=sizeof(cur->postTo)) 
	  throw SyntaxError(lex,"group description too long");
	strcpy(cur->postTo,a1.c_str());
      }
    } else if(tok=="PostTo") {
      a1=lex.getToken();
      if(a1.length()>=sizeof(cur->postTo)) 
	throw SyntaxError(lex,"group description too long");
      strcpy(cur->postTo,a1.c_str());
    } else if(tok=="GroupTimeout") {
      a1=lex.getToken();
      cur->groupTimeout=atoi(a1.c_str());
    } else if(tok=="Options") {
      int flag;
      for(;;) {
	a1=lex.getToken();
	if(lex.isFlag(a1.c_str(),"setpostflag",&flag)) {
	  if(flag) cur->flags|=MPListEntry::F_SETPOSTFLAG;
	  else cur->flags&=~MPListEntry::F_SETPOSTFLAG;
	} else if(lex.isFlag(a1.c_str(),"cached",&flag)) {
	  if(flag) cur->flags|=MPListEntry::F_CACHED;
	  else cur->flags&=~MPListEntry::F_CACHED;
	} else if(lex.isFlag(a1.c_str(),"offline",&flag)) {
	  if(flag) cur->flags|=MPListEntry::F_OFFLINE;
	  else cur->flags&=~MPListEntry::F_OFFLINE;
	} else if(a1=="semioffline") {
	  cur->flags|=MPListEntry::F_SEMIOFFLINE;
	} else {
	  break;
	}
      }
      lex.putbackToken(a1);
    } else if(tok=="}") {
      break;
    } else {
      throw SyntaxError(lex,"expected declaration or '}'");
    }
  }
}
