#ifndef _MPList_h_
#define _MPList_h_
#include <ctype.h>
#include <stdio.h>
#include <netdb.h>
#include <sys/param.h>

#include <iostream.h>
#include <fstream.h>

#include "Debug.h"
#include "Error.h"
#include "OverviewFmt.h"
#include "Lexer.h"

struct MPListEntry {
public:
  enum { 
    F_SETPOSTFLAG=0x01,
    F_CACHED=0x02,
    F_OFFLINE=0x04,
    F_SEMIOFFLINE=0x08
  };
  // nntpflags supported by the server
  enum {
    F_POST=0x01,
    F_LIST_ACTIVE_WILDMAT=0x02,
    F_OVER=0x04,
    F_XOVER=0x08,
    F_LISTGROUP=0x10
  };
  char hostname[MAXHOSTNAMELEN];
  char servicename[256];
  OverviewFmt overview;

  char read[2048];                   // Groups read from that server
  char postTo[2048];                 // Postings handled by this server
  time_t groupTimeout;

  int flags;                         // configuration flags
  int nntpflags;                     // supported NNTP-Commands

  void init(const char *ns=NULL, 
	    const char *np=NULL) {
    if(ns) strcpy(hostname,ns);
    else hostname[0]='\0';
    if(np) strcpy(servicename,np);
    else servicename[0]='\0';

    read[0]=postTo[0]='\0';
    groupTimeout=120;

    flags=F_SETPOSTFLAG|F_CACHED;
    nntpflags=-1;
  }
  void clear() { 
    init(NULL,NULL); 
  }
};

class MPList {
public:
  struct MPListEntry *entries;
  int e_used;

private:
  int e_alloc;
  void myrealloc(int sz) {
    int nsz=(sz+0x10)&(~0xf);
    if(entries) {
      entries=(MPListEntry*)realloc(entries,nsz*sizeof(struct MPListEntry));
    } else {
      entries=(MPListEntry*)malloc(nsz*sizeof(struct MPListEntry));
    }
    if(entries==NULL) {
      throw SystemError("malloc or realloc failed",errno);
    }
    e_alloc=nsz;
  }

public:
  MPList() { entries=NULL; e_alloc=0; e_used=0; }
  
  void addserver(const char *ns,const char *p,const char *g) {
    if(e_used==e_alloc) myrealloc(e_used+1);
    entries[e_used].init(ns,p);
    if(g) {
      strcpy(entries[e_used].read,g);
      strcpy(entries[e_used].postTo,g);
    }
    e_used++;
  }

  const char *makeFilter(int servernbr, const char *listarg) const {
    static string filter;
    char c;
    int i;
    
    if(strcmp(listarg,"*")==0) {
      const char *p,*q;
      filter=entries[servernbr].read;
      for(i=0;i<e_used;i++) {
	if(i!=servernbr) {
	  p=entries[i].read;
	  for(;;) {
	    q=p;
	    while((c=*p)!=',' && c) p++;
	    filter+=",!";
	    filter.append(q,p-q);
	    if(!c) break;
	    p++;
	  }
	}
      }
    } else {
      const char *listp, *p, *q;
      filter="*";
      if(servernbr==0) i=1;
      else i=0;
      listp=listarg;
      c='\0';
      while(i<e_used) {
	if(!c) {
	  q=p=entries[i].read;
	}
	while((c=*listp) && c==*p) { listp++; p++; }
	if(*listp=='*') {
	  // p is matched by listarg
	  ASSERT(if(*p=='*') {
	    slog.p(Logger::Error) << "Same newsgroup expression configured for two different servers!\n";
	  });
	  filter+=",!";
	  while((c=*p)!=',' && c) p++;
	  filter.append(q,p-q);
	} else {
	  // p is not matched by listarg
	  while((c=*p)!=',' && c) p++;
	}
	if(!c) {
	  i++;
	  if(servernbr==i) i++;
	} else {
	  q=++p;
	}
      }
    }

    return filter.c_str();
  }

  MPListEntry *server(const char *group);
  MPListEntry *postserver(const char *group);
  void read(Lexer &lex);    
  void readServer(Lexer &lex, const char *host, const char *port);

//   void dump(ostream &ofs) {
//     int i;
//     ofs << "  MPList {\n";
//     for(i=0;i<e_used;i++) {
//       if(entries[i].hostname[0]) {
// 	ofs << "    Server   \t"
// 	    << entries[i].hostname << '\t'
// 	    << entries[i].servicename << '\t'
// 	    << entries[i].read << endl;
//       } else {
// 	ofs << "    NoServer \t" << entries[i].raeds << endl;
//       }
//     }
//     ofs << "  }\n";
//   }
    
};

#endif
