#ifndef _NSError_h_
#define _NSError_h_

#include <stdlib.h>
#include <errno.h>

#include <string>

#include "Debug.h"
#include "Logger.h"
#include "Error.h"

/* NSError: ErrorCodes 
 */
class NSError: public Error {
public:
  NSError(const char *txt="unknown") : Error(txt) {
    VERB(slog.p(Logger::Error); NSError::print());
  }
  NSError(const string &txt) : Error(txt) {
    VERB(slog.p(Logger::Error); NSError::print());
  }
  virtual ~NSError() {}

  virtual void print() {
    slog << "Exception!\n"
	 << "  Type: NServer\n"
	 << "  Desc: " << _errtext << "\n";
  }
};

class InvalidArticleError: public NSError {
public:
  InvalidArticleError(const char *txt="unknown") : NSError(txt) {}
  InvalidArticleError(const string &txt) : NSError(txt) {}

  virtual void print() {
    slog << "Exception!\n" 
	 << "  Type: InvalidArticle\n"
	 << "  Desc: " << _errtext << "\n";
  }
};

class NoNewsServerError: public NSError {
public:
  NoNewsServerError(const char *txt="unknown") : NSError(txt) {}
  NoNewsServerError(const string &txt) : NSError(txt) {}

  virtual void print() {
    slog << "Exception!\n" 
	 << "  Type: NoNewsServer\n"
	 << "  Desc: " << _errtext << "\n";
  }
};

class NoSuchGroupError: public NSError {
public:
  NoSuchGroupError(const char *txt="unknown") : NSError(txt) {}
  NoSuchGroupError(const string &txt) : NSError(txt) {}

  virtual void print() {
    slog << "Exception!\n" 
	 << "  Type: NoSuchGroup\n"
	 << "  Desc: " << _errtext << "\n";
  }
};

class NoSuchArticleError: public NSError {
public:
  NoSuchArticleError(const char *txt="unknown") : NSError(txt) {}
  NoSuchArticleError(const string &txt) : NSError(txt) {}

  virtual void print() {
    slog << "Exception!\n" 
	 << "  Type: NoSuchArticle\n"
	 << "  Desc: " << _errtext << "\n";
  }
};

class PostingFailedError: public NSError {
public:
  PostingFailedError(const char *txt="unknown") : NSError(txt) {}
  PostingFailedError(const string &txt) : NSError(txt) {}

  virtual void print() {
    slog << "Exception!\n" 
	 << "  Type: NoSuchArticle\n"
	 << "  Desc: " << _errtext << "\n";
  }
};

class NotAllowedError: public NSError {
public:
  NotAllowedError(const char *txt="unknown") : NSError(txt) {}
  NotAllowedError(const string &txt) : NSError(txt) {}

  virtual void print() {
    slog << "Exception!\n" 
	 << "  Type: NoSuchArticle\n"
	 << "  Desc: " << _errtext << "\n";
  }
};

class UsageError: public NSError {
public:
  UsageError(const char *txt="unknown") : NSError(txt) {}
  UsageError(const string &txt) : NSError(txt) {}
  
  virtual void print() {
    slog << "Exception!\n" 
	 << "  Type: Usage\n"
	 << "  Desc: " << _errtext << "\n";
  }
};
typedef UsageError UsageErr;

class ResponseError: public NSError {
public:
  string _command;
  string _expected;
  string _got;

  ResponseError() {}
  ResponseError(const char *command, const char *exp, const char *got)
    : _command(command), _expected(exp), _got(got)
  {
    VERB(slog.p(Logger::Error); ResponseError::print());
  }
  ResponseError(const char *command, const char *exp, const string &got)
    : _command(command), _expected(exp), _got(got)
  {
    VERB(slog.p(Logger::Error); ResponseError::print());
  }
  ResponseError(const string &command, const string &exp, const string &got) 
    : _command(command), _expected(exp), _got(got)
  {
    VERB(slog.p(Logger::Error); ResponseError::print());
  }
  
  virtual void print() {
    slog << "Exception!\n" 
	 << "  Type: Response\n"
	 << "  Cmd : " << _command << "\n"
	 << "  Exp : " << _expected << "\n"
	 << "  Got : " << _got << "\n";
  }  
};
typedef ResponseError ResponseErr;

#endif
