#ifndef _Error_h_
#define _Error_h_

#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include <string>

#include "Debug.h"
#include "Logger.h"

extern Logger slog;

class Error {
public:
  string _errtext;
  Error(const char *txt="unknown") : _errtext(txt) {}
  Error(const string &txt) : _errtext(txt) {}
  virtual ~Error() {}

  virtual void print() {
    slog << "Exception!\n" 
	 << "  Desc: " << _errtext << "\n";
  }
};

class SystemError: public Error {
public:
  int _errno;
  SystemError(const char *txt="unknown", int errnbr=-1)
    : Error(txt), _errno(errnbr)
  {
    VERB(slog.p(Logger::Error); SystemError::print());
  }
  SystemError(const string &txt, int errnbr=-1)
    : Error(txt), _errno(errnbr)
  {
    VERB(slog.p(Logger::Error); SystemError::print());
  }  

  virtual void print() {
    slog << "Exception!\n"
	 << "  Type: System\n" 
	 << "  Desc: " << _errtext 
	 << "  ErrStr(" << _errno << "): " << strerror(_errno) << "\n";
  }
};

class IOError: public SystemError {
public:
  IOError(const char *txt="unknown", int errnbr=-1) : SystemError(txt,errnbr) {
    VERB(slog.p(Logger::Error); IOError::print());
  }
  IOError(const string &txt, int errnbr=-1) : SystemError(txt,errnbr) {
    VERB(slog.p(Logger::Error); IOError::print());
  }

  virtual void print() {
    slog << "Exception!\n"
	 << "  Type: IO\n" 
	 << "  Desc: " << _errtext << "\n"
	 << "  ErrStr(" << _errno << "): " << strerror(_errno) << "\n";
  }
};

class NotFoundError : public Error {
public:
  NotFoundError(const char *txt) : Error(txt) {}
  NotFoundError(const string &txt) : Error(txt) {}

  virtual void print() {
    slog << "Exception!\n" 
	 << "  Type: NotFound\n"
	 << "  Desc: " << _errtext << "\n";
  }
};

class AssertionError : public Error {
public:
  AssertionError(const char *txt) : Error(txt) {
    VERB(slog.p(Logger::Error); AssertionError::print());
  }
  AssertionError(const string &txt) : Error(txt) {
    VERB(slog.p(Logger::Error); AssertionError::print());
  }

  virtual void print() {
    slog << "Exception!\n" 
	 << "  Type: Assertion\n"
	 << "  Desc: " << _errtext << "\n";
  }
};

#endif
