/*  VER 139  TAB P   $Id: pull.c,v 1.12 1998/09/09 07:32:13 src Exp $
 *
 *  pull news      
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: pull.c,v $
 *  Revision 1.12  1998/09/09 07:32:13  src
 *  Version 1.1
 *
 *  Revision 1.11  1998/09/03 05:14:30  src
 *  Improved bad syntax messages
 *
 *  Revision 1.9  1998/09/03 02:49:30  src
 *  Fixed stuff detected by -Wall
 *
 *  Revision 1.8  1998/07/12 09:39:29  src
 *  newsx version 1.0
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "statistics.h"
#include "news.h"

/* BUG: have NNTP timeout function with unlimited line length */

/* 
 *  globals for pull_group
 */

extern long bytes_in_spool; /* external: number of bytes read */
extern long latest_where;   /* external: last article read OK */

/*
 *  for pull() and pull_cleanup()
 */
static int pull_active;
static int pull_anything;
static FILE *pull_in;
static FILE *pull_tmp;
static char activename[PATH_MAX];
static char active_tmp[PATH_MAX];
static char active_old[PATH_MAX];

/*
 *  pull newsgroup
 *  return false if no point in continuing (i.e. an error occurred)
 */
static int 
pull_group(char *group, long *wherep, int is_new)
{
    int more = 1;
    int first_time = 1;
    long first,last;
    long where;

    where = *wherep;
    if (noaction_opt) {
	/* dummy for testing */
	first = where;
	last = where-1;
	pull_anything = 1;
    } else switch (select_group(group,&first,&last)) {
    case 1:       /* OK */
	break;  
    case 0:       /* no such group - continue */
	++unavailable_groups; 
	return 1;
    default:
	return 0; /* no point in continuing */
    }
    log_msg(L_DEBUGMORE,"group selected %s, %ld-%ld",group,first,last);
    /* BUG: check for consistency?! */

    if (zap_opt || (is_new && zapnew_opt)) {
	/* silently update to latest article */
	log_msg(L_DEBUG,"zap from %d to %ld in %s",where,last+1,group);
	where = last+1;
    } else if (reset_opt) {
	/* fetch all articles */
	where = first;
    } else {
	/* fetch from where we left */
	if (where < 0 || where < first) {
	    log_msg(L_DEBUG,"bumping from %ld to %ld in %s",where,first,group);
	    where = first;
	}
    }

    /*
     *  fetch all articles
     */
    if (is_new && max_new && where < last+1-max_new) {
	log_msg(L_DEBUG,"skipping %ld articles due to --maxnew",
						(last+1-where) - max_new);
	where = last+1-max_new;
    }
    if (max_articles && where < last+1-max_articles) {
	log_msg(L_DEBUG,"skipping %ld articles due to --maxart",
					    (last+1-where) - max_articles);
	where = last+1-max_articles;
    }

    latest_where = -1L;
    while (where <= last) {
	if (!fetch_article(where,first_time)) {
	     more = 0;
	     break;
	}
	first_time = 0;
	/* BUG: NOTE that 400 is used for aborting a transfer... */
	++where;

	if (bytes_in_spool > minspool) {
	    /* flush spool if too large */
	    /* BUG: L_DEBUGMORE */
	    log_msg(L_DEBUG,"flushing spool...");
	    flush_spool(0);
	    bytes_in_spool = 0;
	}
    }
    /* flush all remaining requests */
    if (!flush_request()) {
	more = 0;
    }

    /* update article index */
    if (more) {
	/* everything went smoothly */
	*wherep = where;
    } else {
	log_msg(L_DEBUGMORE,"transfer interrupted");
	if (latest_where) {
	    /* this was the last article we retieved */
	    *wherep = latest_where;
	    log_msg(L_DEBUGMORE,"latest article was %ld", latest_where);
	}
    }

    return more;
}

/*
 *  clean up news fetching
 *  NOTE: could be called from a signal handler
 */
void 
pull_cleanup(int urgent)
{
    FILE *f;
    int l_debug = urgent ? L_DEBUG : L_DEBUGMORE;

    if (!pull_active) return;
    pull_active = 0;

    /* finish of spooled batch */
    flush_spool(urgent);

    progtitle("pull: cleanup");
    if ((f = pull_in)) {
	pull_in = 0;
	fclose(f);
    }
    if ((f = pull_tmp)) {
	pull_tmp = 0;
	fclose(pull_tmp);
    }

    /* clean up and update host active */
    if (pull_anything) {
	log_msg(l_debug,"%d group%s contained new articles",
			pull_anything,
			pull_anything==1 ? "":"s");
	pull_anything = 0;

	if (active_old[0]) {
	    log_msg(l_debug,"renaming %s to %s",activename,active_old);
	    unlink(active_old);
	    if (!rename_file(activename,active_old)) exit_cleanup(6);
	}
	log_msg(l_debug,"renaming %s to %s",active_tmp,activename);
	if (!rename_file(active_tmp,activename)) exit_cleanup(6);
    } else {
	log_msg(L_DEBUG,"no news is good news!");
	unlink(active_tmp);
    }
}

/*
 *  pull news 
 */
int
pull(char *spoolname)
{
    char *p,*t;
    char buf[BUFSIZ];
    int skip = 0;
    int n;
    long where,where0;
    char group[BUFSIZ];
    char inhostsdir[PATH_MAX];

    progtitle("pull: opening host active");

    pull_anything = 0;
    pull_active = 0;

    /* BUG: add procid or something... */
    /* BUG: make directory if not there ? */

    build_alt_filename(inhostsdir,SPOOL,INHOSTS,inhosts);
    build_filename(activename,inhostsdir,"/",spoolname,NULL);
    build_filename(active_tmp,inhostsdir,"/",spoolname,_TMP);
    build_filename(active_old,inhostsdir,"/",spoolname,_OLD);

    if (!(pull_in = fopen(activename,"r"))) {
	log_msg(L_ERRno,"can't find a host active \"%s\"",activename);
	active_old[0] = '\0';
	/* but let us continue */
    }
    if (!(pull_tmp = fopen(active_tmp,"w"))) {
	log_msg(L_ERRno,"can't create temporary host active \"%s\"",active_tmp);
	exit_cleanup(6);
    }

    pull_active = 1;
    if (pull_in) {
	while (fgets(buf,BUFSIZ,pull_in)) {
	    p = buf;
	    while (isspace(*p)) ++p;
	    /* BUG: implement include-file mechanism... */
	    /* BUG: or have one rc per server, and let another file
		    decide which groups we'll really use! use the
		    active file as a basis for this file */
	    /* BUG: remove group duplicates... */
	    if (!*p || *p == '#') {
		/* keep comments */
		fputs(buf,pull_tmp);
	    } else if (*p == ':') {
		/* tag */
		++p;
		while (isspace(*p)) ++p;
		t = p;
		if ((p=strchr(t,'\n'))) *p = '\0';
		if ((p=strchr(t,'\t'))) *p = '\0';
		if ((p=strchr(t,' '))) *p = '\0';
		if (end_tag && strcmp(t,end_tag)==0) {
		    log_msg(L_DEBUG,"end at tag \"%s\"",t);
		    skip = 1;
		}
		fprintf(pull_tmp,":%s\n",t);
	    } else {
		where = 0;
		if ((n=sscanf(p,"%[^ \n\t!:] %ld",group,&where)) < 1) {
		    if (!skip) {
			bad_syntax(p,n,1,"host active");
			fprintf(pull_tmp,"#ERR# %s",buf);
		    }
		} else {
		    if (!skip) {
			if (is_active(group)) {
			    where0 = where;
			    log_msg(L_DEBUGMORE,"pull group %s",group);
			    if (!pull_group(group,&where,0)) {
				fetch_aborted = 1;
				skip = 1;
				/* continue reading active to clean up things */
			    } else if (where0 != where) {
				++pull_anything;
				fflush(pull_tmp);
			    }
			} else {
			    log_msg(L_DEBUGMORE,"group %s not active",group);
			}
		    }
		    /* updated count */
		    fprintf(pull_tmp,"%s %ld\n",group,where);
		}
	    }
	}
	fclose(pull_in);
	pull_in = 0;
    }

    /*
     * fetch the remaining previously unseen groups,
     * adding them to the host active file 
     */
    if (!skip && !end_tag) {
	progtitle("pull: unseen groups");
	while (unseen_active(group)) {
	    where = 0;
	    log_msg(L_DEBUGMORE,"pull unseen group %s",group);
	    if (!pull_group(group,&where,1)) break;
	    fprintf(pull_tmp,"%s %ld\n",group,where);
	    ++unseen_groups;
	    if (where) {
		++pull_anything;
		fflush(pull_tmp);
	    }
	}
    }

    fclose(pull_tmp);
    pull_tmp = 0;

    /* finish of spooled batch */
    pull_cleanup(fetch_aborted);

    pull_active = 0;

    return !fetch_aborted;
}




