#!/bin/sh
##
## ppmimgvquant.sh
##	Simple palette mangler for image viewer pgm files.
##
## Copyright (C) 1997 Eric A. Howe
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##   Authors:  Eric A. Howe (mu@trends.net)
##
## $Mu: imgvtopgm/ppmimgvquant.sh 1.7 1998/06/02 22:31:31 $
##
MAPFILE=/tmp/$$.ppmimgvquant.$$

cleanup() {
	[ -r $MAPFILE ] && rm -f $MAPFILE
}

trap cleanup 2 3 9 13 15 

usage() {
	NAME=`basename $1`
	echo "$NAME [-hv] [ppmquant options]"
	cat <<_DONE_DONE_DONE_
	Convert the palette of a PPM image to the standard Image Viewer
	palette. All options except -h and -v are passed to ppmquant(1).

	-h	Display this usage message and exit.
	-v	Display the version number and exit.
_DONE_DONE_DONE_
}

version() {
	NAME=`basename $1`
	echo "$NAME @@VERSION@@"
}

DONE="no"
while [ $DONE != "yes" ]; do
	case X"$1" in
	X"-h")	usage $0;	exit 0	;;
	X"-v")	version $0;	exit 0	;;
	X*)	DONE="yes"		;;
	esac
done

cat > $MAPFILE <<_DONE_DONE_DONE_
P3
4 1
255
  0   0   0
 85  85  85
170 170 170
255 255 255
_DONE_DONE_DONE_

ppmquant -map $MAPFILE "$@" | ppmtopgm
cleanup
