#define AUMIX_VERSION "1.13"
#define AUMIXRC_PATH "/etc"
#define AUMIXRC "aumixrc"
#ifndef TRUE			/* defined in ncurses.h */
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif
#include <stdio.h>
#include <stdlib.h>		/* getenv() */
#include <getopt.h>		/* getopt() */
#include <strings.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#ifdef __linux__
#include <sys/soundcard.h>
#else				/* FreeBSD */
#include <machine/soundcard.h>
#endif
#ifdef HAVE_ALSA
#include <sys/asoundlib.h>
#endif
#if HAVE_LIBGPM
#include <gpm.h>
extern int MouseHandler(Gpm_Event * event, void *data);
#else
#include "gpm-xterm.h"
#endif
#if HAVE_LIBNCURSES
#define INCREMENT 3
#define BALANCE_INCREMENT 4
#define XOFFSET 6
#define YOFFSET 0
#include <ncurses.h>
#endif

/* Our `LOCAL_TEXT(STRING)' macro stands in for gettext (STRING)' when using
   NLS, and simply returns STRING otherwise.  */
#ifdef HAVE_NLS
#define LOCAL_TEXT(string) gettext (string)
#define PACKAGE "aumix"
#define LOCALEDIR "/usr/share/locale"
#ifdef HAVE_LIBINTL_H
#include <libintl.h>
#endif				/* HAVE_LIBINTL_H */
#else				/* HAVE_NLS not defined */
#define LOCAL_TEXT(string) string
#endif				/* HAVE_NLS */

extern int devmask, mixer_fd, recsrc, recmask, stereodevs, mutelevel[SOUND_MIXER_NRDEVICES],
 mutestate, interactive;
extern int ourlevel[SOUND_MIXER_NRDEVICES];	/* store levels to update screen and mute */
extern char *dev_label[SOUND_MIXER_NRDEVICES];
extern void RefreshAllSettings(void);
int ourlevel[SOUND_MIXER_NRDEVICES];
