
#ifdef HAVE_LIBNCURSES
#include "aumix.h"
#define TITLE_COLOR 1
#define TITLE_COLOR2 2
#define HANDLE_COLOR 3
#define TRACK_COLOR 4
#define REC_LED_COLOR 5
#define PLAY_LED_COLOR 6
#define ACTIVE_COLOR 7
#define INACTIVE_COLOR 8

void InitColors(void);
void Inter(void);
void AdjustLevel(int dev, int incr, int setlevel);
void SwitchRecordPlay(int dev);
void DrawRecordPlay(int dev);
void InitScreen(void);
void AdjustBalance(int dev, int incr, int setlevel);
void DrawLevel(int dev);
void DrawLevelBalMode(int dev, int mode);
void RedrawBalance(int dev);
void EraseLevel(int dev);
void CloseScreen(void);
void KeysBox(void);
void ToggleMute(void);

WINDOW *w_keys;
WINDOW *w_panel;

char *charQ, *charq, *charL, *charl, *charS;
char *chars, *charK, *chark, *charM, *charm;

void InitScreen()
{
	int i, y = 0;
	w_panel = newwin(LINES - 1, COLS, 0, 0);
	wclear(w_panel);
	wattrset(w_panel, COLOR_PAIR(TITLE_COLOR));
	wmove(w_panel, 2, 1);
	waddstr(w_panel, (char *) LOCAL_TEXT("uit "));
	wmove(w_panel, 3, 1);
	waddstr(w_panel, (char *) LOCAL_TEXT("oad "));
	wmove(w_panel, 4, 1);
	waddstr(w_panel, (char *) LOCAL_TEXT("ave "));
	wmove(w_panel, 5, 1);
	waddstr(w_panel, (char *) LOCAL_TEXT("eys "));
	wmove(w_panel, 6, 1);
	waddstr(w_panel, (char *) LOCAL_TEXT("ute "));
	wattrset(w_panel, COLOR_PAIR(TITLE_COLOR) | A_UNDERLINE);
	wmove(w_panel, 0, 0);
	waddstr(w_panel, "aumix");
	wattrset(w_panel, COLOR_PAIR(TITLE_COLOR2) | A_BOLD);
	wmove(w_panel, 2, 0);
	waddstr(w_panel, (char *) LOCAL_TEXT("Q"));
	wmove(w_panel, 3, 0);
	waddstr(w_panel, (char *) LOCAL_TEXT("L"));
	wmove(w_panel, 4, 0);
	waddstr(w_panel, (char *) LOCAL_TEXT("S"));
	wmove(w_panel, 5, 0);
	waddstr(w_panel, (char *) LOCAL_TEXT("K"));
	wmove(w_panel, 6, 0);
	waddstr(w_panel, (char *) LOCAL_TEXT("M"));
	wattrset(w_panel, COLOR_PAIR(INACTIVE_COLOR));
	for (i = 0; i < SOUND_MIXER_NRDEVICES; i++) {	/* total existing channels */
		if (devmask & (1 << i))
			y++;
	}
	if (YOFFSET + y <= LINES) {
		wmove(w_panel, YOFFSET + y, XOFFSET + 1);
		waddstr(w_panel, (char *) LOCAL_TEXT("0             Level            100          L         Balance        R"));
	}
	y = 0;			/* Now recycle it for a different use. */
	for (i = 0; i < SOUND_MIXER_NRDEVICES; i++) {
		if ((1 << i) & devmask) {
			wattrset(w_panel, COLOR_PAIR(INACTIVE_COLOR));
			/* draw control labels */
			wmove(w_panel, YOFFSET + y++, XOFFSET + 36);	/* devices really existing */
			waddstr(w_panel, dev_label[i]);
		}
	}
	refresh();
	wrefresh(w_panel);
	RefreshAllSettings();
}
void KeysBox(void)
{
	int key;
	w_keys = newwin(LINES, COLS, 0, 0);
	wclear(w_keys);
	wattrset(w_keys, COLOR_PAIR(INACTIVE_COLOR));
	wmove(w_keys, 3, 0);
	waddstr(w_keys, (char *) LOCAL_TEXT("page arrows\n"));
	waddstr(w_keys, (char *) LOCAL_TEXT("tab enter < > , .\n"));
	waddstr(w_keys, (char *) LOCAL_TEXT("+ - [ ] arrows\n"));
	waddstr(w_keys, (char *) LOCAL_TEXT("space\n"));
	waddstr(w_keys, (char *) LOCAL_TEXT("|\n"));
	wprintw(w_keys, (char *) LOCAL_TEXT("\nPress a key to resume."));
	wmove(w_keys, 1, 0);
	wprintw(w_keys, (char *) LOCAL_TEXT("Key                Function\n"));
	wprintw(w_keys, (char *) LOCAL_TEXT("------------------ --------------------"));
	wmove(w_keys, 3, 19);
	waddstr(w_keys, (char *) LOCAL_TEXT("change channel\n"));
	wmove(w_keys, 4, 19);
	waddstr(w_keys, (char *) LOCAL_TEXT("toggle level/balance\n"));
	wmove(w_keys, 5, 19);
	waddstr(w_keys, (char *) LOCAL_TEXT("adjust slider\n"));
	wmove(w_keys, 6, 19);
	waddstr(w_keys, (char *) LOCAL_TEXT("toggle record/play\n"));
	wmove(w_keys, 7, 19);
	waddstr(w_keys, (char *) LOCAL_TEXT("center balance\n"));
	wrefresh(w_keys);

#if HAVE_LIBGPM
	Gpm_Wgetch(w_keys);
#else
	getch();
#endif

	InitScreen();
}

void RefreshAllSettings(void)
{
	int dev;
	for (dev = 0; dev < SOUND_MIXER_NRDEVICES; dev++) {
		if ((1 << dev) & devmask) {
			EraseLevel(dev);
			RedrawBalance(dev);
			wattrset(w_panel, COLOR_PAIR(HANDLE_COLOR));
			DrawLevel(dev);
			/* print record/play indicators */
			if ((1 << dev) & recmask)
				DrawRecordPlay(dev);
		}
	}
	wrefresh(w_panel);
}

void RefreshNewSettings(void)
/* Periodically redraws the screen, in case another process has changed the
   mixer settings. */
{
	int dev, i = 0;
	for (dev = 0; dev < SOUND_MIXER_NRDEVICES; dev++) {
		if ((1 << dev) & devmask) {
			if (ioctl(mixer_fd, MIXER_READ(dev), &i) == -1) {
				perror("MIXER_READ");
				exit(-1);
			}
			if (i - ourlevel[dev]) {	/* Has the setting changed? */
				EraseLevel(dev);
				RedrawBalance(dev);
				DrawLevel(dev);
				if ((1 << dev) & recmask)
					DrawRecordPlay(dev);
				ourlevel[dev] = i;
			}
		}
	}
}

void ToggleMute(void)
{
	int dev, null = 0;
	if (mutestate) {
/* restore from array */
		for (dev = 0; dev < SOUND_MIXER_NRDEVICES; dev++) {
			if ((1 << dev) & devmask) {
				if (ioctl(mixer_fd, MIXER_WRITE(dev), &mutelevel[dev]) == -1) {
					perror("MIXER_WRITE");
					exit(-1);
				}
			}
		}
	} else {
/* Store levels in array; set channels to zero. */
		for (dev = 0; dev < SOUND_MIXER_NRDEVICES; dev++) {
			if ((1 << dev) & devmask) {
				if (ioctl(mixer_fd, MIXER_READ(dev), &mutelevel[dev]) == -1) {
					perror("MIXER_READ");
					exit(-1);
				}
				if (ioctl(mixer_fd, MIXER_WRITE(dev), &null) == -1) {
					perror("MIXER_WRITE");
					exit(-1);
				}
			}
		}
	}
	mutestate = !mutestate;
	RefreshAllSettings();
	wattrset(w_panel, COLOR_PAIR(INACTIVE_COLOR));
	wmove(w_panel, 1, 0);
	wprintw(w_panel, mutestate ? "%s" : "     ", LOCAL_TEXT("muted"));
	wrefresh(w_panel);
}

void InitColors(void)
{
	start_color();
	init_pair(TITLE_COLOR, COLOR_CYAN, COLOR_BLUE);
	init_pair(TITLE_COLOR2, COLOR_RED, COLOR_BLUE);
	init_pair(HANDLE_COLOR, COLOR_CYAN, COLOR_BLUE);
	init_pair(TRACK_COLOR, COLOR_BLUE, COLOR_BLACK);
	init_pair(REC_LED_COLOR, COLOR_RED, COLOR_BLACK);
	init_pair(PLAY_LED_COLOR, COLOR_GREEN, COLOR_BLACK);
	init_pair(ACTIVE_COLOR, COLOR_YELLOW, COLOR_RED);
	init_pair(INACTIVE_COLOR, COLOR_WHITE, COLOR_BLACK);
}

void Inter(void)
{
	int incr, key, dir, dev, levelbalmode, i, y;
#if (HAVE_LIBGPM != 1)
	i = halfdelay(2);	/* tenths of a second */
#endif
/* Find first existing channel. */
	for (dev = 0; !(devmask & (1 << dev)); dev++);
/* Highlight the label. */
	wattrset(w_panel, COLOR_PAIR(ACTIVE_COLOR) | ((has_colors())? A_BOLD : A_REVERSE));
	y = 0;
	for (i = 0; i < dev; i++) {
		if (devmask & (1 << i))
			y++;
	}
	wmove(w_panel, YOFFSET + y, XOFFSET + 36);
	waddstr(w_panel, dev_label[dev]);
	EraseLevel(dev);
	DrawLevel(dev);
	DrawLevelBalMode(dev, 0);
	wrefresh(w_panel);
	levelbalmode = 0;
	while (1) {
		RefreshNewSettings();
#if HAVE_LIBGPM			/* Gpm_Getch doesn't honor halfdelay. */
		key = Gpm_Getch();
#else
		key = getch();
#endif
		incr = 0;
		dir = 0;
		if (key == '.' || key == ',' || key == '<' || key == '>' ||
		    key == 9 || key == 10) {
			levelbalmode = !levelbalmode;
			wattrset(w_panel, COLOR_PAIR(INACTIVE_COLOR));
			y = 0;
			for (i = 0; i < dev; i++) {
				if (devmask & (1 << i))
					y++;
			}
			wmove(w_panel, YOFFSET + y, XOFFSET + 35);
			waddstr(w_panel, "          ");
			wattrset(w_panel, COLOR_PAIR(ACTIVE_COLOR) | ((has_colors())? A_BOLD : A_REVERSE));
			wmove(w_panel, YOFFSET + y, XOFFSET + 36);
			waddstr(w_panel, dev_label[dev]);
			DrawLevelBalMode(dev, levelbalmode);
		}
		if (key == 27 || key == 4 || key == *charQ ||
		    key == *charq) {
			return;
			dir = -1;
		}
		if (key == KEY_UP || key == KEY_PPAGE || key == KEY_DOWN ||
		    key == KEY_NPAGE) {
			if (key == KEY_UP || key == KEY_PPAGE) {
				dir = -1;
			}
			if (!dir)	/* if not PgUp or < pressed */
				dir = 1;
			/* un-highlight current label */
			EraseLevel(dev);
			DrawLevel(dev);
			wattrset(w_panel, COLOR_PAIR(INACTIVE_COLOR));
			y = 0;
			for (i = 0; i < dev; i++) {
				if (devmask & (1 << i))
					y++;
			}
			wmove(w_panel, YOFFSET + y, XOFFSET + 35);
			waddstr(w_panel, "          ");
			wattrset(w_panel, COLOR_PAIR(INACTIVE_COLOR));
			wmove(w_panel, YOFFSET + y, XOFFSET + 36);
			waddstr(w_panel, dev_label[dev]);
/* switch to next existing device */
			do {
				if (dir == 1) {
					dev++;
					if (dev > SOUND_MIXER_NRDEVICES - 1)
						dev = 0;
				} else {
					dev--;
					if (dev < 0)
						dev = SOUND_MIXER_NRDEVICES - 1;
				}
			}
			while (!((1 << dev) & devmask));
			/* highlight new device label */
			wattrset(w_panel, COLOR_PAIR(ACTIVE_COLOR) | ((has_colors())? A_BOLD : A_REVERSE));
			y = 0;
			for (i = 0; i < dev; i++) {
				if (devmask & (1 << i))
					y++;
			}
			wmove(w_panel, YOFFSET + y, XOFFSET + 36);
			waddstr(w_panel, dev_label[dev]);
			EraseLevel(dev);
			DrawLevel(dev);
			DrawLevelBalMode(dev, levelbalmode);
		}
		if (key == ' ') {
			SwitchRecordPlay(dev);
		}
		if (key == '[') {
			if ((levelbalmode) && ((1 << dev) & stereodevs))
				AdjustBalance(dev, 0, 0);
			else
				AdjustLevel(dev, 0, 0);
		}
		if (key == ']') {
			if ((levelbalmode) && ((1 << dev) & stereodevs))
				AdjustBalance(dev, 0, 100);
			else
				AdjustLevel(dev, 0, 100);
		}
		if (key == '+' || key == KEY_RIGHT || key == '-' ||
		    key == KEY_LEFT) {
			if (key == '+' || key == KEY_RIGHT) {
				incr = INCREMENT;
			}
			if (!incr)	/* '+'/up/right not pressed */
				incr = -INCREMENT;
			if ((levelbalmode) && ((1 << dev) & stereodevs))
				AdjustBalance(dev, incr, -1);
			else
				AdjustLevel(dev, incr, -1);
		}
		if (key == '|') {
			AdjustBalance(dev, -1, 50);
		}
		if (key == *chark || key == *charK) {
			KeysBox();
			DrawLevelBalMode(dev, levelbalmode);
			wmove(w_panel, YOFFSET + y, XOFFSET + 36);
			waddstr(w_panel, dev_label[dev]);
		}
		if (key == *charl || key == *charL) {
			LoadSettings();
		}
		if (key == *chars || key == *charS) {
			SaveSettings();
		}
		if (key == *charm || key == *charM) {
			ToggleMute();
		}
		wrefresh(w_panel);
	}
}

void DrawLevelBalMode(int dev, int mode)
/* arrow to show whether keyboard commands will adjust level or balance */
{
	int i, y = 0;
	for (i = 0; i < dev; i++) {
		if (devmask & (1 << i))
			y++;
	}
	wattrset(w_panel, COLOR_PAIR(ACTIVE_COLOR) | ((has_colors())? A_BOLD : A_REVERSE));
	if ((mode) && ((1 << dev) & stereodevs)) {
		wmove(w_panel, YOFFSET + y, XOFFSET + 44);
		waddch(w_panel, '>');
		wmove(w_panel, YOFFSET + y, XOFFSET + 44);
	} else {
		wmove(w_panel, YOFFSET + y, XOFFSET + 35);
		waddch(w_panel, '<');
		wmove(w_panel, YOFFSET + y, XOFFSET + 35);
	}
}

void AdjustLevel(int dev, int incr, int setlevel)
/*
 *  dev: device to adjust
 *  incr: signed percentage to increase (decrease) level, ignored unless
 *      setlevel = -1
 *  setlevel: level to set directly, or -1 to increment
 */
{
	int balset, max, left, right, temp;
	if (!((1 << dev) & devmask) || (dev > SOUND_MIXER_NRDEVICES - 1) || (dev < 0))
		return;
	if (ioctl(mixer_fd, MIXER_READ(dev), &temp) == -1) {
		CloseScreen();
		perror("MIXER_READ");
		exit(-1);
	}
	left = temp & 0x7F;
	right = (temp >> 8) & 0x7F;
	max = (left > right) ? left : right;
	if (max) {
		balset = (left > right) ? 50 * right / max : 100 - (50 * left / max);
	} else {
		balset = 50;
	}
	max += incr;
	if (balset > 49) {
		left = max * (100 - balset) / 50;
		right = max;
	} else {
		right = max * balset / 50;
		left = max;
	}
	left = (setlevel > -1) ? setlevel : left;
	right = (setlevel > -1) ? setlevel : right;
	left = (left > 100) ? 100 : left;
	right = (right > 100) ? 100 : right;
	left = (left < 0) ? 0 : left;
	right = (right < 0) ? 0 : right;
	temp = (right << 8) | left;
	if (ioctl(mixer_fd, MIXER_WRITE(dev), &temp) == -1) {
		CloseScreen();
		perror("MIXER_WRITE");
		exit(-1);
	}
	EraseLevel(dev);
	/* Draw handle at new position. */
	RedrawBalance(dev);
	DrawLevel(dev);
}

void DrawLevel(int dev)
{
	int left, right, temp, i, y = 0;
	if (!((1 << dev) & devmask) || (dev > SOUND_MIXER_NRDEVICES - 1) || (dev < 0))
		return;
	for (i = 0; i < dev; i++) {
		if (devmask & (1 << i))
			y++;
	}
	if (ioctl(mixer_fd, MIXER_READ(dev), &temp) == -1) {
		CloseScreen();
		perror("MIXER_READ");
		exit(-1);
	}
	left = temp & 0x7F;
	right = (temp >> 8) & 0x7F;
	wattrset(w_panel, COLOR_PAIR(INACTIVE_COLOR));
	wmove(w_panel, YOFFSET + y, XOFFSET + 1 + left / INCREMENT);
	waddch(w_panel, 'L');
	wmove(w_panel, YOFFSET + y, XOFFSET + 1 + right / INCREMENT);
	waddch(w_panel, 'R');
	wattrset(w_panel, COLOR_PAIR(HANDLE_COLOR) | ((has_colors())? A_BOLD : A_REVERSE));
	wmove(w_panel, YOFFSET + y, XOFFSET + 1 + (left + right) / INCREMENT / 2);
	waddch(w_panel, 'O');
	wmove(w_panel, YOFFSET + y, XOFFSET + 1 + (left + right) / INCREMENT / 2);
	wrefresh(w_panel);
}

void EraseLevel(int dev)
{
/* Redraw level track. */
	int i, y = 0;
	if (!((1 << dev) & devmask) || (dev > SOUND_MIXER_NRDEVICES - 1) || (dev < 0))
		return;
	for (i = 0; i < dev; i++) {
		if (devmask & (1 << i))
			y++;
	}
	wattrset(w_panel, COLOR_PAIR(TRACK_COLOR));
	for (i = 0; i < 34; i++) {
		wmove(w_panel, YOFFSET + y, XOFFSET + 1 + i);
		waddch(w_panel, '+');
	}
}

void AdjustBalance(int dev, int incr, int setabs)
/*
 *  dev: device to adjust
 *  incr: signed percentage to change balance
 *  setabs: absolute balance setting, or -1 to increment only
 *  Balance settings go from 0 to 100; at setting of 0, right amplitude is 0.
 */
{
	int balset, max, left, right, temp, left_orig, right_orig;
	if (!((1 << dev) & devmask) || (dev > SOUND_MIXER_NRDEVICES - 1))
		return;
	if (ioctl(mixer_fd, MIXER_READ(dev), &temp) == -1) {
		CloseScreen();
		perror("MIXER_READ");
		exit(-1);
	}
	left = temp & 0x7F;
	right = (temp >> 8) & 0x7F;
	left_orig = left;
	right_orig = right;
	max = (left > right) ? left : right;
	if (max) {
		balset = (left > right) ? 50 * right / max : 100 - (50 * left / max);
	} else {
		balset = 50;
	}
	balset = (setabs == -1) ? balset + incr : setabs;
	balset = (balset > 100) ? 100 : balset;
	balset = (balset < 0) ? 0 : balset;
	if (balset > 49) {
		left = max * (100 - balset) / 50;
		right = max;
	} else {
		right = max * balset / 50;
		left = max;
	}
	temp = (right << 8) | left;
	if (ioctl(mixer_fd, MIXER_WRITE(dev), &temp) == -1) {
		CloseScreen();
		perror("MIXER_WRITE");
		exit(-1);
	}
	/* Draw handle at new position. */
	RedrawBalance(dev);
}

void RedrawBalance(int dev)
/* Redraw balance track. */
{
	int left, right, max, temp, balset, i, y = 0;
	for (i = 0; i < dev; i++) {
		if (devmask & (1 << i))
			y++;
	}
	if ((1 << dev) & stereodevs) {
		wattrset(w_panel, COLOR_PAIR(TRACK_COLOR));
		for (temp = 0; temp < 26; temp++) {
			wmove(w_panel, YOFFSET + y, XOFFSET + 45 + temp);
			waddch(w_panel, '+');
		}
		if (ioctl(mixer_fd, MIXER_READ(dev), &temp) == -1) {
			CloseScreen();
			perror("MIXER_READ");
			exit(-1);
		}
		left = temp & 0x7F;
		right = (temp >> 8) & 0x7F;
		max = (left > right) ? left : right;
		if (temp) {
			balset = (left > right) ? 50 * right / max : 100 - (50 * left / max);
		} else {
			balset = 50;
		}
		wattrset(w_panel, COLOR_PAIR(HANDLE_COLOR) | ((has_colors())? A_BOLD : A_REVERSE));
		wmove(w_panel, YOFFSET + y, XOFFSET + 45 + balset / 4);
		waddch(w_panel, 'O');
		wmove(w_panel, YOFFSET + y, XOFFSET + 45 + balset / 4);
		wrefresh(w_panel);
	}
}

void SwitchRecordPlay(int dev)
{
	/* Toggle record/play. */
	if ((1 << dev) & recmask) {
		if (ioctl(mixer_fd, SOUND_MIXER_READ_RECSRC, &recsrc) == -1) {
			perror("SOUND_MIXER_READ_RECSRC");
			exit(-1);
		}
		if (recsrc & (1 << dev))
			recsrc &= ~(1 << dev);	/* Turn off recording. */
		else
			recsrc |= (1 << dev);	/* Turn on recording. */
		if (ioctl(mixer_fd, SOUND_MIXER_WRITE_RECSRC, &recsrc) == -1) {
			CloseScreen();
			perror("SOUND_MIXER_WRITE_RECSRC");
			exit(-1);
		}
		if (ioctl(mixer_fd, SOUND_MIXER_READ_RECSRC, &recsrc) == -1) {
			perror("SOUND_MIXER_READ_RECSRC");
			exit(-1);
		}
		DrawRecordPlay(dev);	/* Print indicators. */
	}
}

void DrawRecordPlay(int dev)
{
	int i, y = 0;
	wattrset(w_panel,
		 (1 << dev) & recsrc ? COLOR_PAIR(REC_LED_COLOR) | ((has_colors())? A_NORMAL : A_REVERSE) : COLOR_PAIR(PLAY_LED_COLOR));
	for (i = 0; i < dev; i++) {
		if (devmask & (1 << i))
			y++;
	}
	wmove(w_panel, YOFFSET + y, XOFFSET + 0);
	waddch(w_panel, ((1 << dev) & recsrc ? 'R' : 'P'));
	wmove(w_panel, YOFFSET + y, XOFFSET + 0);
	wrefresh(w_panel);
}

void CloseScreen(void)
{
	if (interactive) {
		initscr();	/* Calling refresh() will cause a segfault if we do it without initializing the screen. */
		clear();
		refresh();
		endwin();
	}
}

void ReadInteractiveKeys(void)
{
	charQ = malloc(strlen(LOCAL_TEXT("Q")));
	sprintf(charQ, LOCAL_TEXT("Q"));
	charq = malloc(strlen(LOCAL_TEXT("q")));
	sprintf(charq, LOCAL_TEXT("q"));
	charL = malloc(strlen(LOCAL_TEXT("L")));
	sprintf(charL, LOCAL_TEXT("L"));
	charl = malloc(strlen(LOCAL_TEXT("l")));
	sprintf(charl, LOCAL_TEXT("l"));
	charS = malloc(strlen(LOCAL_TEXT("S")));
	sprintf(charS, LOCAL_TEXT("S"));
	chars = malloc(strlen(LOCAL_TEXT("s")));
	sprintf(chars, LOCAL_TEXT("s"));
	charK = malloc(strlen(LOCAL_TEXT("K")));
	sprintf(charK, LOCAL_TEXT("K"));
	chark = malloc(strlen(LOCAL_TEXT("k")));
	sprintf(chark, LOCAL_TEXT("k"));
	charM = malloc(strlen(LOCAL_TEXT("M")));
	sprintf(charM, LOCAL_TEXT("M"));
	charm = malloc(strlen(LOCAL_TEXT("m")));
	sprintf(charm, LOCAL_TEXT("m"));
}

#endif
